/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import generic.jar.ResourceFile;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.signature.SignatureResult;
import ghidra.features.bsim.gui.filters.FunctionTagBSimFilterType;
import ghidra.features.bsim.query.DecompileFunctionTask;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.ParallelDecompileTask;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.features.bsim.query.protocol.PreFilter;
import ghidra.framework.Application;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;

public class GenSignatures {
    private DescriptionManager manager;
    private LSHVectorFactory vectorFactory = null;
    private Program program;
    private FunctionManager fmanage;
    private DecompileOptions options = null;
    private ExecutableRecord exerec = null;
    private SignatureTask singletask = null;
    private HashMap<String, Integer> attributes;
    private List<String> categories;
    private String dateColumnName;
    private boolean gencallgraph;
    private AtomicBoolean isShutdown = new AtomicBoolean(false);
    private ConcurrentLinkedDeque<ParallelDecompileTask> runningTasks = new ConcurrentLinkedDeque();

    public GenSignatures(boolean callgraph) {
        this.gencallgraph = callgraph;
        this.attributes = new HashMap();
        this.attributes.put("Function ID Analyzer", FunctionTagBSimFilterType.KNOWN_LIBRARY_MASK);
        this.categories = null;
        this.dateColumnName = null;
    }

    public void addExecutableCategories(List<String> names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            if (!CategoryRecord.enforceTypeCharacters(name)) {
                throw new IllegalArgumentException();
            }
            if (this.categories == null) {
                this.categories = new ArrayList<String>();
            }
            this.categories.add(name);
        }
    }

    public void addFunctionTags(List<String> names) {
        if (names == null) {
            return;
        }
        int flag = 1;
        flag <<= FunctionTagBSimFilterType.RESERVED_BITS;
        for (String name : names) {
            if (flag == 0 || !CategoryRecord.enforceTypeCharacters(name)) {
                throw new IllegalArgumentException();
            }
            this.attributes.put(name, flag);
            flag <<= 1;
        }
    }

    public void setVectorFactory(LSHVectorFactory vFactory) throws LSHException {
        if (vFactory.getSettings() == 0) {
            throw new LSHException("Cannot have signature setting of 0");
        }
        if (this.vectorFactory == vFactory) {
            return;
        }
        if (this.manager != null) {
            this.manager.clearFunctions();
        }
        this.vectorFactory = vFactory;
    }

    public void addDateColumnName(String name) {
        if (name == null) {
            return;
        }
        if (!CategoryRecord.enforceTypeCharacters(name)) {
            throw new IllegalArgumentException();
        }
        this.dateColumnName = name;
    }

    public DescriptionManager getDescriptionManager() {
        return this.manager;
    }

    public void clear() {
        if (this.manager != null) {
            this.manager.clear();
        }
        this.manager = null;
        this.program = null;
    }

    private String generateMetadataMD5(String nmover, String compover, String archover) {
        int i;
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] data = new byte[nmover.length() + compover.length() + archover.length()];
        int pos = 0;
        for (i = 0; i < nmover.length(); ++i) {
            data[pos++] = (byte)nmover.charAt(i);
        }
        for (i = 0; i < compover.length(); ++i) {
            data[pos++] = (byte)compover.charAt(i);
        }
        for (i = 0; i < archover.length(); ++i) {
            data[pos++] = (byte)archover.charAt(i);
        }
        digester.update(data);
        byte[] digest = digester.digest();
        StringBuffer buf = new StringBuffer();
        char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int i2 = 0; i2 < 16; ++i2) {
            char val1 = hexdigits[digest[i2] >> 4 & 0xF];
            char val2 = hexdigits[digest[i2] & 0xF];
            buf.append(val1).append(val2);
        }
        return buf.toString();
    }

    public void openProgram(Program prog, String nmover, String archover, String compover, String repo, String path) throws LSHException {
        String md5string;
        this.program = prog;
        if (nmover == null) {
            nmover = this.program.getDomainFile().getName();
        }
        if (archover == null) {
            archover = this.program.getLanguageID().getIdAsString();
        }
        if (compover == null) {
            compover = this.program.getCompilerSpec().getCompilerSpecID().getIdAsString();
        }
        if ((md5string = prog.getExecutableMD5()) == null || md5string.length() < 10) {
            md5string = this.generateMetadataMD5(nmover, compover, archover);
        }
        Date progDate = this.fillinDate();
        this.manager = new DescriptionManager();
        this.exerec = this.manager.newExecutableRecord(md5string, nmover, compover, archover, progDate, repo, path, null);
        this.singletask = null;
        this.fmanage = this.program.getFunctionManager();
        this.fillinExecutableCategories();
    }

    private void fillinExecutableCategories() {
        if (this.categories == null) {
            return;
        }
        ArrayList<CategoryRecord> catrecs = new ArrayList<CategoryRecord>();
        Options progoptions = this.program.getOptions("Program Information");
        for (String cat : this.categories) {
            Object optionobject;
            Object curproperty = cat;
            int count = 0;
            while (progoptions.contains((String)curproperty) && (optionobject = progoptions.getObject((String)curproperty, null)) instanceof String) {
                CategoryRecord rec = new CategoryRecord(cat, (String)optionobject);
                catrecs.add(rec);
                curproperty = cat + "_" + Integer.toString(++count);
            }
        }
        if (!catrecs.isEmpty()) {
            this.manager.setExeCategories(this.exerec, catrecs);
        }
    }

    private Date fillinDate() {
        String str;
        if (this.dateColumnName == null || this.dateColumnName.equals("Date Created") || this.dateColumnName.equals("Ingest Date")) {
            return this.program.getCreationDate();
        }
        Options progoptions = this.program.getOptions("Program Information");
        if (!progoptions.contains(this.dateColumnName)) {
            return ExecutableRecord.EMPTY_DATE;
        }
        Object optionobject = progoptions.getObject(this.dateColumnName, null);
        if (optionobject instanceof Date) {
            return (Date)optionobject;
        }
        Date res = ExecutableRecord.EMPTY_DATE;
        if (optionobject instanceof String && (str = (String)optionobject).length() == 19) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            try {
                res = dateFormat.parse(str);
            }
            catch (ParseException e) {
                res = ExecutableRecord.EMPTY_DATE;
            }
        }
        return res;
    }

    private CallRecord fillinProperties(Address addr) {
        CallRecord callRecord = new CallRecord();
        Function func = this.fmanage.getReferencedFunction(addr);
        Symbol rootSymbol = null;
        Address rootAddr = null;
        boolean hasbody = false;
        if (func == null) {
            SymbolTable symtab = this.program.getSymbolTable();
            rootSymbol = symtab.getPrimarySymbol(addr);
        } else {
            if (func.isThunk()) {
                func = func.getThunkedFunction(true);
            }
            rootAddr = func.getEntryPoint();
            rootSymbol = func.getSymbol();
            if (!func.isExternal()) {
                hasbody = this.hasBody(rootAddr);
            }
        }
        if (hasbody) {
            callRecord.exerec = this.exerec;
            callRecord.address = rootAddr.getOffset();
            callRecord.funcname = rootSymbol.getName(true);
        } else {
            String libraryName;
            callRecord.address = -1L;
            if (rootSymbol == null) {
                libraryName = "unknown";
                callRecord.funcname = "func_" + Long.toHexString(addr.getOffset());
            } else {
                libraryName = this.extractExternalName(rootSymbol, callRecord);
            }
            try {
                callRecord.exerec = this.manager.newExecutableLibrary(libraryName, this.exerec.getArchitecture(), null);
            }
            catch (LSHException e) {
                callRecord.exerec = this.exerec;
            }
        }
        return callRecord;
    }

    private String extractExternalName(Symbol sym, CallRecord callRecord) {
        String libraryName;
        String fullName = sym.getName(true);
        int ind = fullName.indexOf("::");
        if (ind >= 0) {
            libraryName = fullName.substring(0, ind);
            String tmpnm = fullName.substring(ind + 2);
            if (tmpnm.isEmpty()) {
                libraryName = "unknown";
                callRecord.funcname = fullName;
            } else if (libraryName.isEmpty()) {
                libraryName = "unknown";
                callRecord.funcname = tmpnm;
            } else {
                callRecord.funcname = tmpnm;
            }
            if (libraryName.equals("<EXTERNAL>")) {
                libraryName = "unknown";
            }
        } else {
            libraryName = "unknown";
            callRecord.funcname = fullName;
        }
        return libraryName;
    }

    private int recoverAttributes(Function func) {
        Bookmark[] bookmarks;
        int flags = 0;
        BookmarkManager bookmarkManager = this.program.getBookmarkManager();
        for (Bookmark bookmark : bookmarks = bookmarkManager.getBookmarks(func.getEntryPoint())) {
            Integer val = this.attributes.get(bookmark.getCategory());
            if (val == null) continue;
            flags |= val.intValue();
        }
        Set tags = func.getTags();
        for (FunctionTag tag : tags) {
            Integer val = this.attributes.get(tag.getName());
            if (val == null) continue;
            flags |= val.intValue();
        }
        return flags;
    }

    private List<CallRecord> collectCallsFromAddress(List<Address> calladdr) {
        ArrayList<CallRecord> calls = new ArrayList<CallRecord>();
        for (int i = 0; i < calladdr.size(); ++i) {
            Address addr = calladdr.get(i);
            CallRecord callRecord = this.fillinProperties(addr);
            calls.add(callRecord);
        }
        return calls;
    }

    private boolean hasBody(Address addr) {
        Listing listing = this.program.getListing();
        CodeUnit cu = listing.getCodeUnitAt(addr);
        if (!(cu instanceof Instruction)) {
            return false;
        }
        Instruction inst = (Instruction)cu;
        FlowType flowType = inst.getFlowType();
        return flowType != RefType.COMPUTED_JUMP;
    }

    private synchronized void writeToManager(Function func, int[] hash, List<CallRecord> callrecs, int flags) {
        FunctionDescription fdesc = this.manager.newFunctionDescription(func.getName(true), func.getEntryPoint().getOffset(), this.exerec);
        this.manager.setFunctionDescriptionFlags(fdesc, flags);
        if (hash != null) {
            LSHVector vec = this.vectorFactory.buildVector(hash);
            SignatureRecord sigrec = this.manager.newSignature(vec, 0);
            this.manager.attachSignature(fdesc, sigrec);
        }
        for (CallRecord callRecord : callrecs) {
            FunctionDescription destfunc = this.manager.newFunctionDescription(callRecord.funcname, callRecord.address, callRecord.exerec);
            this.manager.makeCallgraphLink(fdesc, destfunc, 0);
        }
    }

    public int transferCachedFunctions(DescriptionManager otherman, Iterator<Function> functions, PreFilter preFilter) throws LSHException {
        otherman.transferSettings(this.manager);
        int count = 0;
        BiPredicate<Program, FunctionDescription> filterPredicate = preFilter.getAndReducedPredicate();
        while (functions.hasNext()) {
            FunctionDescription desc;
            Function func = functions.next();
            String name = func.getName(true);
            long address = func.getEntryPoint().getOffset();
            try {
                desc = this.manager.findFunction(name, address, this.exerec);
            }
            catch (LSHException e) {
                continue;
            }
            if (!filterPredicate.test(this.program, desc)) continue;
            otherman.transferFunction(desc, true);
            ++count;
        }
        return count;
    }

    public void scanFunctions(Iterator<Function> functions, int countestimate, TaskMonitor monitor) throws DecompileException {
        if (!functions.hasNext()) {
            return;
        }
        if (this.isShutdown.get()) {
            return;
        }
        ParallelDecompileTask taskrun = new ParallelDecompileTask(this.program, monitor, new SignatureTask());
        this.runningTasks.add(taskrun);
        taskrun.decompile(functions, countestimate);
        this.runningTasks.remove(taskrun);
    }

    public void scanFunction(Function func) throws DecompileException {
        if (this.isShutdown.get()) {
            return;
        }
        if (this.singletask == null) {
            this.singletask = new SignatureTask();
            this.singletask.initializeGlobal(this.program);
            this.singletask = (SignatureTask)this.singletask.clone(0);
        }
        this.singletask.decompile(func, null);
    }

    public void scanFunctionsMetadata(Iterator<Function> iter, TaskMonitor monitor) {
        if (this.exerec == null) {
            return;
        }
        if (iter == null) {
            iter = this.fmanage.getFunctions(true);
        }
        while (iter.hasNext()) {
            Function func = (Function)iter.next();
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            if (func.isThunk() || !this.hasBody(func.getEntryPoint())) continue;
            int flags = this.recoverAttributes(func);
            FunctionDescription fdesc = this.manager.newFunctionDescription(func.getName(true), func.getEntryPoint().getOffset(), this.exerec);
            this.manager.setFunctionDescriptionFlags(fdesc, flags);
        }
    }

    public void dispose() {
        this.isShutdown.set(true);
        for (ParallelDecompileTask task : this.runningTasks) {
            task.shutdown();
        }
        this.runningTasks.clear();
        if (this.singletask != null) {
            this.singletask.shutdown();
        }
        this.clear();
    }

    public static String getPathFromDomainFile(Program program) {
        DomainFile domainFile = program.getDomainFile();
        String path = domainFile.getPathname();
        int ind = path.length() - domainFile.getName().length();
        if (ind >= 0 && !path.substring(ind).equals(domainFile.getName())) {
            ind = -1;
        }
        path = ind <= 0 ? null : path.substring(0, ind);
        return path;
    }

    public static ResourceFile getWeightsFile(LanguageID id1, LanguageID id2) throws IOException {
        String basefile;
        String[] split1 = id1.getIdAsString().split(":");
        String[] split2 = id2.getIdAsString().split(":");
        if (split1.length < 3 || split2.length < 3) {
            return null;
        }
        ResourceFile moduleDataSubDirectory = Application.getModuleDataSubDirectory((String)"");
        if (split1[0].equals("Dalvik") || split1[0].equals("JVM")) {
            if (!split2[0].equals(split1[0])) {
                return null;
            }
            return new ResourceFile(moduleDataSubDirectory, "lshweights_cpool.xml");
        }
        String size1 = split1[2];
        String size2 = split2[2];
        if (!size1.equals(size2)) {
            if (!size1.equals("64") && !size1.equals("32")) {
                return null;
            }
            if (!size2.equals("64") && !size2.equals("32")) {
                return null;
            }
            basefile = "lshweights_nosize.xml";
        } else if (size1.equals("32")) {
            basefile = "lshweights_32.xml";
        } else if (size1.equals("64")) {
            String version;
            basefile = "lshweights_64.xml";
            if (split1.length > 3 && (version = split1[3]).contains("-32")) {
                basefile = "lshweights_64_32.xml";
            }
        } else {
            basefile = "lshweights_nosize.xml";
        }
        return new ResourceFile(moduleDataSubDirectory, basefile);
    }

    public class SignatureTask
    implements DecompileFunctionTask {
        private DecompInterface decompiler;

        public SignatureTask() {
            this.decompiler = null;
        }

        private SignatureTask(DecompInterface decompiler) {
            this.decompiler = decompiler;
        }

        @Override
        public DecompileFunctionTask clone(int worker) throws DecompileException {
            DecompInterface newdecompiler = new DecompInterface();
            newdecompiler.setOptions(GenSignatures.this.options);
            newdecompiler.toggleSyntaxTree(false);
            newdecompiler.setSignatureSettings(GenSignatures.this.vectorFactory.getSettings());
            if (!newdecompiler.openProgram(GenSignatures.this.program)) {
                String errorMessage = newdecompiler.getLastMessage();
                throw new DecompileException("Decompiler", "Unable to initialize the DecompilerInterface: " + errorMessage);
            }
            if (worker == 0) {
                short major = newdecompiler.getMajorVersion();
                short minor = newdecompiler.getMinorVersion();
                int settings = newdecompiler.getSignatureSettings();
                GenSignatures.this.manager.setVersion(major, minor);
                GenSignatures.this.manager.setSettings(settings);
            }
            return new SignatureTask(newdecompiler);
        }

        @Override
        public void decompile(Function func, TaskMonitor monitor) {
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            if (func.isThunk()) {
                return;
            }
            Address entryPoint = func.getEntryPoint();
            if (!GenSignatures.this.hasBody(entryPoint)) {
                return;
            }
            FunctionDescription fdesc = GenSignatures.this.manager.containsDescription(func.getName(true), entryPoint.getOffset(), GenSignatures.this.exerec);
            if (fdesc != null && fdesc.getSignatureRecord() != null) {
                return;
            }
            SignatureResult sigres = this.decompiler.generateSignatures(func, GenSignatures.this.gencallgraph, GenSignatures.this.options.getDefaultTimeout(), monitor);
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            if (sigres == null) {
                String errmsg = this.decompiler.getLastMessage();
                if (errmsg != null && !errmsg.isEmpty()) {
                    Msg.error((Object)this, (Object)("Error generating signature for \"" + func.getName() + "\".  Error: " + errmsg));
                }
                return;
            }
            if (sigres.features.length == 0) {
                Msg.error((Object)this, (Object)("No features in signature for \"" + func.getName() + "\""));
                return;
            }
            int flags = GenSignatures.this.recoverAttributes(func);
            if (sigres.hasunimplemented) {
                flags |= FunctionTagBSimFilterType.HAS_UNIMPLEMENTED_MASK;
            }
            if (sigres.hasbaddata) {
                flags |= FunctionTagBSimFilterType.HAS_BADDATA_MASK;
            }
            List<Object> callrecs = GenSignatures.this.gencallgraph ? GenSignatures.this.collectCallsFromAddress(sigres.calllist) : new ArrayList();
            GenSignatures.this.writeToManager(func, sigres.features, callrecs, flags);
        }

        @Override
        public void initializeGlobal(Program prog) {
            GenSignatures.this.program = prog;
            GenSignatures.this.options = new DecompileOptions();
            GenSignatures.this.options.grabFromProgram(GenSignatures.this.program);
        }

        @Override
        public void shutdown() {
            this.decompiler.dispose();
        }
    }

    private static class CallRecord {
        public ExecutableRecord exerec;
        public String funcname;
        public long address;

        private CallRecord() {
        }
    }
}

