/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.ingest;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLQuery;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandler;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandlerAdapter;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class IterateRepository {
    protected abstract void process(Program var1, TaskMonitor var2) throws IOException, CancelledException;

    public void process(URL ghidraURL, final TaskMonitor monitor) throws Exception, CancelledException {
        if (!GhidraURL.isServerRepositoryURL((URL)ghidraURL) && !GhidraURL.isLocalProjectURL((URL)ghidraURL)) {
            throw new MalformedURLException("Unsupported repository URL: " + String.valueOf(ghidraURL));
        }
        GhidraURLQuery.queryUrl((URL)ghidraURL, null, (GhidraURLResultHandler)new GhidraURLResultHandlerAdapter(true){

            public void processResult(DomainFolder domainFolder, URL url, TaskMonitor m) throws IOException, CancelledException {
                int totalFiles = IterateRepository.this.getTotalFileCount(domainFolder);
                monitor.setMaximum((long)totalFiles);
                monitor.setShowProgressValue(true);
                IterateRepository.this.process(domainFolder, monitor);
            }

            public void processResult(DomainFile domainFile, URL url, TaskMonitor m) throws IOException, CancelledException {
                IterateRepository.this.process(domainFile, monitor);
            }
        }, (GhidraURLQuery.LinkFileControl)GhidraURLQuery.LinkFileControl.NO_FOLLOW, (TaskMonitor)monitor);
    }

    private void process(DomainFolder folder, TaskMonitor monitor) throws IOException, CancelledException {
        for (DomainFile domainFile : folder.getFiles()) {
            monitor.checkCancelled();
            this.process(domainFile, monitor);
        }
        for (DomainFile domainFile : folder.getFolders()) {
            monitor.checkCancelled();
            this.process((DomainFolder)domainFile, monitor);
        }
    }

    private int getTotalFileCount(DomainFolder folder) {
        int count = 0;
        count += folder.getFiles().length;
        for (DomainFolder subfolder : folder.getFolders()) {
            count += this.getTotalFileCount(subfolder);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(DomainFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (!"Program".equals(file.getContentType())) {
            return;
        }
        Program program = null;
        try {
            Msg.debug(IterateRepository.class, (Object)("Processing " + file.getPathname() + "..."));
            monitor.setMessage("Processing: " + file.getName());
            monitor.incrementProgress(1L);
            program = (Program)file.getReadOnlyDomainObject((Object)this, -1, monitor);
            this.process(program, monitor);
        }
        catch (VersionException e) {
            Msg.error(IterateRepository.class, (Object)("Failed to process file " + file.getPathname() + ": " + e.getMessage()));
        }
        finally {
            if (program != null) {
                program.release((Object)this);
            }
        }
    }
}

