/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ConstantPropagationAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = " Constant Reference Analyzer";
    static final String DESCRIPTION = " Constant Propagation Analyzer for constant references computed with multiple instructions.";
    protected static final String OPTION_NAME = "Function parameter/return Pointer analysis";
    protected static final String OPTION_DESCRIPTION = "Turn on to check if values passed as parameters or returned could be pointer references";
    protected static final boolean OPTION_DEFAULT_VALUE = true;
    protected static final String POINTER_PARAM_OPTION_NAME = "Require pointer param data type";
    protected static final String POINTER_PARAM_OPTION_DESCRIPTION = "Turn on to require values passed as parameters or returned to be a known pointer data type";
    protected static final boolean POINTER_PARAM_OPTION_DEFAULT_VALUE = false;
    protected static final String STORED_OPTION_NAME = "Stored Value Pointer analysis";
    protected static final String STORED_OPTION_DESCRIPTION = "Turn on to check if values stored into memory or the stack could be pointer references";
    protected static final boolean STORED_OPTION_DEFAULT_VALUE = true;
    protected static final String TRUST_WRITEMEM_OPTION_NAME = "Trust values read from writable memory";
    protected static final String TRUST_WRITEMEM_OPTION_DESCRIPTION = "Turn on to trust values read from writable memory";
    protected static final boolean TRUST_WRITEMEM_OPTION_DEFAULT_VALUE = true;
    protected static final String MAX_THREAD_COUNT_OPTION_NAME = "Max Threads";
    protected static final String MAX_THREAD_COUNT_OPTION_DESCRIPTION = "Maximum threads for constant propagation.  Too many threads causes thrashing in DB.";
    protected static final int MAX_THREAD_COUNT_OPTION_DEFAULT_VALUE = 2;
    protected static final String MIN_KNOWN_REFADDRESS_OPTION_NAME = "Min absolute reference";
    protected static final String MIN_KNOWN_REFADDRESS_OPTION_DESCRIPTION = "Minimum address for calcuated constant store/load references";
    protected static final int MIN_KNOWN_REFADDRESS_OPTION_DEFAULT_VALUE = 4;
    protected static final String MIN_SPECULATIVE_REFADDRESS_OPTION_NAME = "Speculative reference min";
    protected static final String MIN_SPECULATIVE_REFADDRESS_OPTION_DESCRIPTION = "Minimum speculative reference address for offsets and parameters";
    protected static final int MIN_SPECULATIVE_REFADDRESS_OPTION_DEFAULT_VALUE = 1024;
    protected static final String MAX_SPECULATIVE_REFADDRESS_OPTION_NAME = "Speculative reference max";
    protected static final String MAX_SPECULATIVE_REFADDRESS_OPTION_DESCRIPTION = "Prototype - Maxmimum speculative reference address offset from the end of memory for offsets and parameters";
    protected static final int MAX_SPECULATIVE_REFADDRESS_OPTION_DEFAULT_VALUE = 256;
    protected static final String CREATE_COMPLEX_DATA_FROM_POINTERS_OPTION_NAME = "Create Data from pointer";
    protected static final String CREATE_COMPLEX_DATA_FROM_POINTERS_OPTION_DESCRIPTION = "Create complex data types from pointers if the data type is known, currently from function parameters.";
    protected static final boolean CREATE_COMPLEX_DATA_FROM_POINTERS_OPTION_DEFAULT_VALUE = false;
    protected static final int NOTIFICATION_INTERVAL = 100;
    protected boolean checkParamRefsOption = true;
    protected boolean checkPointerParamRefsOption = false;
    protected boolean checkStoredRefsOption = true;
    protected boolean trustWriteMemOption = true;
    protected boolean createComplexDataFromPointers = false;
    protected int maxThreadCount = 2;
    protected long minStoreLoadRefAddress = 4L;
    protected long minSpeculativeRefAddress = 1024L;
    protected long maxSpeculativeRefAddress = 256L;
    protected boolean followConditional = false;
    static final HashSet<String> handledProcessors = new HashSet();
    protected String processorName = "Basic";

    public ConstantPropagationAnalyzer() {
        this("Basic");
    }

    public ConstantPropagationAnalyzer(String processorName) {
        super(processorName + NAME, processorName + DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        ConstantPropagationAnalyzer.claimProcessor(processorName);
        this.processorName = processorName;
        this.setPriority(AnalysisPriority.REFERENCE_ANALYSIS.before().before().before().before());
    }

    public ConstantPropagationAnalyzer(String processorName, AnalyzerType type) {
        super(processorName + NAME, processorName + DESCRIPTION, type);
    }

    public static void claimProcessor(String processorName) {
        handledProcessors.add(processorName);
    }

    public static boolean isClaimedProcessor(String processorName) {
        return handledProcessors.contains(processorName);
    }

    @Override
    public boolean canAnalyze(Program program) {
        boolean isHarvard = program.getLanguage().getDefaultSpace() != program.getLanguage().getDefaultDataSpace();
        this.checkPointerParamRefsOption = program.getDefaultPointerSize() <= 2 || isHarvard;
        this.checkStoredRefsOption = program.getDefaultPointerSize() > 2 && !isHarvard;
        long size = program.getAddressFactory().getDefaultAddressSpace().getSize();
        this.minSpeculativeRefAddress = size * 16L;
        this.maxSpeculativeRefAddress = size * 8L;
        boolean bl = this.checkParamRefsOption = !(program.getAddressFactory().getDefaultAddressSpace() instanceof SegmentedAddressSpace);
        if (this.processorName.equals("Basic")) {
            return !handledProcessors.contains(program.getLanguage().getProcessor().toString());
        }
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)this.processorName));
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressSet unanalyzedSet = new AddressSet(set);
        this.removeUninitializedBlocks(program, unanalyzedSet);
        try {
            HashSet<Address> locations = new HashSet<Address>();
            this.findLocationsRemoveFunctionBodies(program, unanalyzedSet, locations, monitor);
            int locationCount = locations.size();
            monitor.initialize((long)locationCount);
            if (locationCount != 0) {
                monitor.setMessage(this.getName());
                AddressSetView resultSet = this.runParallelAddressAnalysis(program, locations, null, this.maxThreadCount, monitor);
                unanalyzedSet.delete(resultSet);
            }
            if (!unanalyzedSet.isEmpty()) {
                this.analyzeSet(program, unanalyzedSet, monitor);
            }
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"caught exception", (Throwable)e);
            e.printStackTrace();
        }
        return true;
    }

    protected void removeUninitializedBlocks(Program program, AddressSet set) {
        MemoryBlock[] blocks;
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            if (block.isInitialized() || block.isMapped()) continue;
            set.deleteRange(block.getStart(), block.getEnd());
        }
    }

    protected void findLocationsRemoveFunctionBodies(Program program, AddressSet set, Set<Address> locations, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Finding function locations...");
        long total = set.getNumAddresses();
        monitor.initialize(total);
        AddressSet inBodySet = new AddressSet();
        Iterator fiter = program.getFunctionManager().getFunctionsOverlapping((AddressSetView)set);
        while (fiter.hasNext()) {
            monitor.checkCancelled();
            Function function = (Function)fiter.next();
            locations.add(function.getEntryPoint());
            inBodySet.add(function.getBody());
        }
        monitor.setProgress(total - inBodySet.getNumAddresses());
        set.delete((AddressSetView)inBodySet);
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator referenceDestinationIterator = referenceManager.getReferenceDestinationIterator((AddressSetView)set, true);
        AddressSet outOfBodySet = new AddressSet();
        block1: while (referenceDestinationIterator.hasNext()) {
            monitor.checkCancelled();
            Address address = referenceDestinationIterator.next();
            ReferenceIterator referencesTo = referenceManager.getReferencesTo(address);
            while (referencesTo.hasNext()) {
                Reference reference = referencesTo.next();
                if (!reference.getReferenceType().isCall()) continue;
                locations.add(address);
                outOfBodySet.add(address);
                continue block1;
            }
        }
        monitor.incrementProgress(outOfBodySet.getNumAddresses());
        set.delete((AddressSetView)outOfBodySet);
        outOfBodySet = new AddressSet();
        AddressRangeIterator addressRanges = set.getAddressRanges();
        while (addressRanges.hasNext()) {
            monitor.checkCancelled();
            AddressRange addressRange = (AddressRange)addressRanges.next();
            locations.add(addressRange.getMinAddress());
            outOfBodySet.add(addressRange.getMinAddress());
        }
        monitor.incrementProgress(outOfBodySet.getNumAddresses());
        set.delete((AddressSetView)outOfBodySet);
    }

    protected AddressSetView runAddressAnalysis(final Program program, Set<Address> locations, TaskMonitor monitor) throws CancelledException, InterruptedException, Exception {
        monitor.checkCancelled();
        final AddressSet analyzedSet = new AddressSet();
        if (locations.isEmpty()) {
            return analyzedSet;
        }
        GThreadPool pool = AutoAnalysisManager.getSharedAnalsysThreadPool();
        monitor.setMessage("Analyzing functions...");
        monitor.setMaximum((long)locations.size());
        QCallback<Address, AddressSetView> callback = new QCallback<Address, AddressSetView>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public AddressSetView process(Address loc, TaskMonitor taskMonitor) {
                AddressSet addressSet = analyzedSet;
                synchronized (addressSet) {
                    if (analyzedSet.contains(loc)) {
                        taskMonitor.incrementProgress(1L);
                        return EMPTY_ADDRESS_SET;
                    }
                }
                try {
                    AddressSetView result = ConstantPropagationAnalyzer.this.analyzeLocation(program, loc, null, taskMonitor);
                    AddressSet addressSet2 = analyzedSet;
                    synchronized (addressSet2) {
                        analyzedSet.add(result);
                    }
                    taskMonitor.incrementProgress(1L);
                    return result;
                }
                catch (CancelledException e) {
                    return null;
                }
            }
        };
        if (this.maxThreadCount > pool.getMaxThreadCount() || this.maxThreadCount < 1) {
            this.maxThreadCount = 1;
        }
        ConcurrentQ queue = new ConcurrentQBuilder().setThreadPool(pool).setMaxInProgress(this.maxThreadCount).setMonitor(monitor).build((QCallback)callback);
        queue.add(locations);
        queue.waitUntilDone();
        return analyzedSet;
    }

    public void analyzeSet(Program program, AddressSet todoSet, TaskMonitor monitor) throws CancelledException {
        long totalNumAddresses = todoSet.getNumAddresses();
        monitor.initialize(totalNumAddresses);
        Listing listing = program.getListing();
        int count = 0;
        while (!todoSet.isEmpty()) {
            Address start;
            AddressSetView resultSet;
            Address nextAddr;
            Instruction instr;
            monitor.checkCancelled();
            if (count++ % 100 == 0) {
                monitor.setProgress(totalNumAddresses - todoSet.getNumAddresses());
            }
            if ((instr = listing.getInstructionAt(nextAddr = todoSet.getMinAddress())) == null) {
                instr = listing.getInstructionAfter(nextAddr);
                if (instr == null) break;
                nextAddr = instr.getMinAddress();
                if (!todoSet.contains(nextAddr)) {
                    todoSet.deleteFromMin(nextAddr);
                    continue;
                }
            }
            if ((resultSet = this.analyzeLocation(program, start = instr.getMinAddress(), (AddressSetView)todoSet, monitor)) != null) {
                if (!start.equals((Object)todoSet.getMinAddress())) {
                    todoSet.deleteFromMin(start);
                }
                todoSet.delete(resultSet);
            }
            if (resultSet != null && !resultSet.isEmpty()) continue;
            todoSet.delete(start, start);
        }
    }

    @Override
    public AddressSetView analyzeLocation(Program program, Address start, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        if (program.getListing().getInstructionAt(start) == null) {
            return new AddressSet();
        }
        Address flowStart = start;
        AddressSetView flowSet = set;
        Function func = program.getFunctionManager().getFunctionContaining(start);
        if (func != null) {
            AddressSetView body = func.getBody();
            if (body.getNumAddresses() > 1L) {
                flowSet = body;
            }
            flowStart = func.getEntryPoint();
        }
        SymbolicPropogator symEval = new SymbolicPropogator(program, false);
        symEval.setParamRefCheck(this.checkParamRefsOption);
        symEval.setParamPointerRefCheck(this.checkPointerParamRefsOption);
        symEval.setReturnRefCheck(this.checkParamRefsOption);
        symEval.setStoredRefCheck(this.checkStoredRefsOption);
        return this.flowConstants(program, flowStart, flowSet, symEval, monitor);
    }

    public AddressSetView flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(monitor).setTrustWritableMemory(this.trustWriteMemOption).setMinSpeculativeOffset(this.minSpeculativeRefAddress).setMaxSpeculativeOffset(this.maxSpeculativeRefAddress).setMinStoreLoadOffset(this.minStoreLoadRefAddress).setCreateComplexDataFromPointers(this.createComplexDataFromPointers);
        return symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
    }

    public final void markDataAsConstant(Data data) {
        SettingsDefinition[] settings;
        for (SettingsDefinition setting : settings = data.getDataType().getSettingsDefinitions()) {
            if (!(setting instanceof MutabilitySettingsDefinition)) continue;
            MutabilitySettingsDefinition mutabilitySetting = (MutabilitySettingsDefinition)setting;
            mutabilitySetting.setChoice((Settings)data, 2);
        }
    }

    public final void createData(Program program, Address address, int size) {
        if (size < 1 || size > 8) {
            return;
        }
        if (!program.getListing().isUndefined(address, address)) {
            Data data = program.getListing().getDataAt(address);
            if (data == null) {
                return;
            }
            if (data.getDataType() instanceof Undefined) {
                if (data.getLength() >= size) {
                    return;
                }
                program.getListing().clearCodeUnits(address, address, false);
            } else {
                return;
            }
        }
        DataType dt = Undefined.getUndefinedDataType((int)size);
        try {
            program.getListing().createData(address, dt);
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
            // empty catch block
        }
    }

    @Override
    public boolean getDefaultEnablement(Program p) {
        return true;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME, (Object)this.checkParamRefsOption, null, OPTION_DESCRIPTION);
        options.registerOption(STORED_OPTION_NAME, (Object)this.checkStoredRefsOption, null, STORED_OPTION_DESCRIPTION);
        options.registerOption(TRUST_WRITEMEM_OPTION_NAME, (Object)this.trustWriteMemOption, null, TRUST_WRITEMEM_OPTION_DESCRIPTION);
        options.registerOption(CREATE_COMPLEX_DATA_FROM_POINTERS_OPTION_NAME, (Object)this.createComplexDataFromPointers, null, CREATE_COMPLEX_DATA_FROM_POINTERS_OPTION_DESCRIPTION);
        options.registerOption(POINTER_PARAM_OPTION_NAME, (Object)this.checkPointerParamRefsOption, null, POINTER_PARAM_OPTION_DESCRIPTION);
        options.registerOption(MAX_THREAD_COUNT_OPTION_NAME, (Object)this.maxThreadCount, null, MAX_THREAD_COUNT_OPTION_DESCRIPTION);
        options.registerOption(MIN_KNOWN_REFADDRESS_OPTION_NAME, (Object)this.minStoreLoadRefAddress, null, MIN_KNOWN_REFADDRESS_OPTION_DESCRIPTION);
        options.registerOption(MIN_SPECULATIVE_REFADDRESS_OPTION_NAME, (Object)this.minSpeculativeRefAddress, null, MIN_SPECULATIVE_REFADDRESS_OPTION_DESCRIPTION);
        options.registerOption(MAX_SPECULATIVE_REFADDRESS_OPTION_NAME, (Object)this.maxSpeculativeRefAddress, null, MAX_SPECULATIVE_REFADDRESS_OPTION_DESCRIPTION);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.checkParamRefsOption = options.getBoolean(OPTION_NAME, this.checkParamRefsOption);
        this.checkPointerParamRefsOption = options.getBoolean(POINTER_PARAM_OPTION_NAME, this.checkPointerParamRefsOption);
        this.checkStoredRefsOption = options.getBoolean(STORED_OPTION_NAME, this.checkStoredRefsOption);
        this.trustWriteMemOption = options.getBoolean(TRUST_WRITEMEM_OPTION_NAME, this.trustWriteMemOption);
        this.createComplexDataFromPointers = options.getBoolean(CREATE_COMPLEX_DATA_FROM_POINTERS_OPTION_NAME, this.createComplexDataFromPointers);
        this.maxThreadCount = options.getInt(MAX_THREAD_COUNT_OPTION_NAME, this.maxThreadCount);
        this.minStoreLoadRefAddress = options.getLong(MIN_KNOWN_REFADDRESS_OPTION_NAME, this.minStoreLoadRefAddress);
        this.minSpeculativeRefAddress = options.getLong(MIN_SPECULATIVE_REFADDRESS_OPTION_NAME, this.minSpeculativeRefAddress);
        this.maxSpeculativeRefAddress = options.getLong(MAX_SPECULATIVE_REFADDRESS_OPTION_NAME, this.maxSpeculativeRefAddress);
    }
}

