/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GnuVernaux
implements StructConverter {
    private int vna_hash;
    private short vna_flags;
    private short vna_other;
    private int vna_name;
    private int vna_next;

    GnuVernaux(BinaryReader reader) throws IOException {
        this.vna_hash = reader.readNextInt();
        this.vna_flags = reader.readNextShort();
        this.vna_other = reader.readNextShort();
        this.vna_name = reader.readNextInt();
        this.vna_next = reader.readNextInt();
    }

    public int getHash() {
        return this.vna_hash;
    }

    public short getFlags() {
        return this.vna_flags;
    }

    public short getOther() {
        return this.vna_other;
    }

    public int getName() {
        return this.vna_name;
    }

    public int getNext() {
        return this.vna_next;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("Elf_Verdef", 0);
        struct.add(DWORD, "vna_hash", "Hash value of dependency name");
        struct.add(WORD, "vna_flags", "Dependency specific information");
        struct.add(WORD, "vna_other", "Unused");
        struct.add(DWORD, "vna_name", "Dependency name string offset");
        struct.add(DWORD, "vna_next", "Offset in bytes to next vernaux entry");
        return struct;
    }
}

