/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.test.AbstractDockingTest;
import generic.jar.ResourceFile;
import generic.test.AbstractGTest;
import generic.test.AbstractGenericTest;
import generic.test.AbstractGuiTest;
import generic.test.TestUtils;
import ghidra.app.events.CloseProgramPluginEvent;
import ghidra.app.events.OpenProgramPluginEvent;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.app.plugin.core.script.GhidraScriptMgrPlugin;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.JavaScriptProvider;
import ghidra.app.services.ProgramManager;
import ghidra.base.project.GhidraProject;
import ghidra.framework.Application;
import ghidra.framework.ToolUtils;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.TestFrontEndTool;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolConnection;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.project.DefaultProjectManager;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.ProgramUtilities;
import ghidra.test.AbstractGhidraHeadedIntegrationTest;
import ghidra.test.AbstractGhidraHeadlessIntegrationTest;
import ghidra.test.ScriptTaskListener;
import ghidra.test.TestProgramManager;
import ghidra.test.TestTool;
import ghidra.util.Msg;
import ghidra.util.TaskUtilities;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jdom.Element;
import utilities.util.FileUtilities;

public class TestEnv {
    private static final int FIVE_MINUTES = 5;
    private static int toolID = 2;
    private static Set<TestEnv> instances = new HashSet<TestEnv>();
    private FrontEndTool frontEndTool;
    protected PluginTool tool;
    private static TestProgramManager programManager = new TestProgramManager();
    private GhidraProject gp;
    private List<PluginTool> extraTools = new ArrayList<PluginTool>();

    public TestEnv() throws IOException {
        this(5L, AbstractGhidraHeadlessIntegrationTest.PROJECT_NAME);
    }

    public TestEnv(String projectName) throws IOException {
        this(5L, projectName);
    }

    public TestEnv(long abortTimeout, String projectName) throws IOException {
        if (!Application.isInitialized()) {
            throw new AssertException("The TestEnv requires the system to be initialized before usage.  JUnit test should be an instance of GhidraHeadedIntegrationTest or GhidraHeadlessIntegrationTest");
        }
        this.cleanupOldInstances();
        this.gp = TestEnv.createGhidraTestProject(projectName);
        instances.add(this);
    }

    protected TestEnv(GhidraProject project) {
        if (!Application.isInitialized()) {
            throw new AssertException("The TestEnv requires the system to be initialized before usage.  JUnit test should be an instance of GhidraHeadedIntegrationTest or GhidraHeadlessIntegrationTest");
        }
        this.gp = Objects.requireNonNull(project);
    }

    private void cleanupOldInstances() {
        if (instances.isEmpty()) {
            return;
        }
        Msg.error((Object)this, (Object)"\n\tFound non-disposed() TestEnv instances.  Please examine this test!\n\n");
        HashSet<TestEnv> copy = new HashSet<TestEnv>(instances);
        copy.forEach(env -> env.dispose());
    }

    public PluginTool getTool() {
        return this.lazyTool();
    }

    public void closeTool() {
        if (this.tool == null) {
            Msg.info((Object)this, (Object)"Test Env tool does not exist; cannot close");
            return;
        }
        this.closeAllProgramsFor(this.tool);
        AbstractGuiTest.runSwing(() -> this.tool.setConfigChanged(false));
        AbstractGuiTest.runSwing(() -> this.tool.close(), (boolean)false);
        AbstractGuiTest.waitForSwing();
        this.tool = null;
    }

    private void closeAllProgramsFor(PluginTool theTool) {
        List<Program> programs = this.getOpenProgamsFor(theTool);
        programs.forEach(p -> this.close((Program)p));
    }

    private List<Program> getOpenProgamsFor(PluginTool theTool) {
        List<Program> toolPrograms = programManager.getOpenPrograms().stream().filter(p -> p.getConsumerList().contains(theTool)).collect(Collectors.toList());
        return toolPrograms;
    }

    public void closeTool(PluginTool toolToClose) {
        this.closeTool(toolToClose, true);
    }

    public void closeTool(PluginTool toolToClose, boolean ignoreChanges) {
        if (toolToClose == this.tool) {
            this.tool = null;
        }
        this.extraTools.remove(toolToClose);
        AbstractGuiTest.executeOnSwingWithoutBlocking(() -> {
            if (ignoreChanges) {
                toolToClose.setConfigChanged(false);
            }
            toolToClose.close();
        });
    }

    protected void disposeFrontEndTool() {
        if (this.frontEndTool == null) {
            return;
        }
        AbstractGuiTest.runSwing(() -> this.frontEndTool.close());
        this.frontEndTool = null;
        this.removeFrontEndFromSystem();
    }

    private void dipsoseTestTools() {
        AbstractGuiTest.runSwing(() -> {
            this.disposeSingleTool(this.tool);
            for (PluginTool pt : this.extraTools) {
                this.disposeSingleTool(pt);
            }
            this.extraTools.clear();
        });
    }

    private void disposeSingleTool(PluginTool pluginTool) {
        if (pluginTool == null) {
            return;
        }
        String toolName = pluginTool.getName();
        try {
            pluginTool.setConfigChanged(false);
            pluginTool.close();
            this.cleanupAutoAnalysisManagers(pluginTool);
        }
        catch (Throwable t) {
            Msg.error(TestEnv.class, (Object)("Unexpected exception closing tool: " + toolName), (Throwable)t);
        }
    }

    public void saveRestoreToolState() {
        AbstractGuiTest.runSwing(() -> {
            Element element = this.lazyTool().saveDataStateToXml(true);
            this.lazyTool().restoreDataStateFromXml(element);
        });
    }

    public <T extends Plugin> T getPlugin(Class<T> c) {
        return AbstractGhidraHeadlessIntegrationTest.getPlugin(this.lazyTool(), c);
    }

    public <T extends Plugin> T addPlugin(Class<T> c) throws PluginException {
        PluginTool defaultTool = this.lazyTool();
        defaultTool.addPlugin(c.getName());
        return AbstractGhidraHeadlessIntegrationTest.getPlugin(defaultTool, c);
    }

    public PluginTool showTool() {
        return AbstractGhidraHeadedIntegrationTest.showTool(this.lazyTool());
    }

    public PluginTool showTool(Program p) {
        this.open(p);
        PluginTool t = AbstractGhidraHeadedIntegrationTest.showTool(this.lazyTool());
        this.removeAllConsumersExceptTool(p, t);
        return t;
    }

    private void removeAllConsumersExceptTool(Program p, PluginTool t) {
        p.getConsumerList().forEach(c -> {
            if (c != t) {
                p.release(c);
            }
        });
    }

    @Deprecated
    public Window waitForWindow(String title, int timeoutMS) {
        return AbstractDockingTest.waitForWindow((String)title, (int)timeoutMS);
    }

    @Deprecated
    public <T extends DialogComponentProvider> T waitForDialogComponent(Class<T> ghidraClass, int maxTimeMS) {
        return (T)AbstractDockingTest.waitForDialogComponent(ghidraClass);
    }

    private static GhidraProject createGhidraTestProject(String projectName) throws IOException {
        TestEnv.deleteOldTestTools();
        TestEnv.deleteSavedFrontEndTool();
        String projectDirectoryName = AbstractGTest.getTestDirectoryPath();
        GhidraProject gp = GhidraProject.createProject(projectDirectoryName, projectName, true);
        TestEnv.installDefaultTool(gp);
        return gp;
    }

    private static void deleteOldTestTools() {
        String toolDirPath = ToolUtils.getApplicationToolDirPath();
        FileUtilities.deleteDir((File)new File(toolDirPath));
    }

    private static void deleteSavedFrontEndTool() {
        String frontEndFilename = (String)TestUtils.getInstanceField((String)"FRONT_END_FILE_NAME", FrontEndTool.class);
        File frontEndFile = new File(Application.getUserSettingsDirectory(), frontEndFilename);
        if (frontEndFile.exists()) {
            frontEndFile.delete();
        }
    }

    private static void installDefaultTool(GhidraProject gp) {
        Project project = gp.getProject();
        ToolChest toolChest = project.getLocalToolChest();
        ToolTemplate template = TestEnv.getToolTemplate("TestCodeBrowser");
        template.setName("CodeBrowser");
        AbstractGuiTest.runSwing(() -> toolChest.replaceToolTemplate(template));
    }

    private void initializeSimpleTool() {
        if (this.tool != null) {
            throw new AssertException("Tool already exists--you are doing something wrong!");
        }
        AbstractGuiTest.runSwing(() -> {
            Project project = this.gp.getProject();
            this.tool = new TestTool(project);
            try {
                this.tool.addPlugin(ProgramManagerPlugin.class.getName());
            }
            catch (PluginException e) {
                Msg.error(TestEnv.class, (Object)"Problem initializing test tool", (Throwable)e);
            }
        }, (boolean)true);
        this.getFrontEndTool();
    }

    private PluginTool lazyTool() {
        if (this.tool != null) {
            return this.tool;
        }
        this.initializeSimpleTool();
        return this.tool;
    }

    public FrontEndTool getFrontEndTool() {
        if (this.frontEndTool != null) {
            return this.frontEndTool;
        }
        AbstractGuiTest.runSwing(() -> {
            this.frontEndTool = new TestFrontEndTool((ProjectManager)this.gp.getProjectManager());
            this.frontEndTool.setActiveProject(this.getProject());
            this.setAutoSaveEnabled(this.frontEndTool, false);
            this.frontEndTool.setConfigChanged(false);
        });
        return this.frontEndTool;
    }

    public ComponentProvider getFrontEndProvider() {
        ComponentProvider provider = (ComponentProvider)TestUtils.invokeInstanceMethod((String)"getProvider", (Object)this.getFrontEndTool());
        return provider;
    }

    private void removeFrontEndFromSystem() {
        TestUtils.setInstanceField((String)"tool", AppInfo.class, null);
    }

    public FrontEndTool showFrontEndTool() {
        this.getFrontEndTool();
        AbstractGhidraHeadedIntegrationTest.showTool((PluginTool)this.frontEndTool);
        return this.frontEndTool;
    }

    public PluginTool createDefaultTool() {
        PluginTool newTool = this.launchDefaultToolByName("TestCodeBrowser");
        return newTool;
    }

    public PluginTool launchDefaultTool() {
        if (this.tool != null) {
            Msg.error((Object)this, (Object)"Tool already exists--you are doing something wrong!");
        }
        this.tool = this.launchDefaultToolByName("TestCodeBrowser");
        if (this.tool == null) {
            throw new NullPointerException("Unable to launch the default tool: TestCodeBrowser");
        }
        return this.tool;
    }

    protected PluginTool launchDefaultToolByName(String toolName) {
        return (PluginTool)AbstractGuiTest.runSwing(() -> {
            ToolTemplate toolTemplate = TestEnv.getToolTemplate(toolName);
            if (toolTemplate == null) {
                Msg.debug((Object)this, (Object)("Unable to find tool: " + toolName));
                return null;
            }
            boolean wasErrorGUIEnabled = AbstractDockingTest.isUseErrorGUI();
            AbstractDockingTest.setErrorGUIEnabled((boolean)false);
            FrontEndTool frontEndToolInstance = this.getFrontEndTool();
            Project project = frontEndToolInstance.getProject();
            ToolManager toolManager = project.getToolManager();
            Workspace workspace = toolManager.getActiveWorkspace();
            AbstractDockingTest.setErrorGUIEnabled((boolean)wasErrorGUIEnabled);
            return workspace.runTool(toolTemplate);
        });
    }

    private static ToolTemplate getToolTemplate(String toolName) {
        return (ToolTemplate)AbstractGuiTest.runSwing(() -> {
            ToolTemplate toolTemplate = ToolUtils.readToolTemplate((String)("defaultTools/" + toolName + ".tool"));
            if (toolTemplate == null) {
                Msg.debug(TestEnv.class, (Object)("Unable to find tool: " + toolName));
                return null;
            }
            return toolTemplate;
        });
    }

    public ScriptTaskListener runScript(File scriptFile) throws PluginException {
        GhidraScriptMgrPlugin scriptManagerPlugin = this.getPlugin(GhidraScriptMgrPlugin.class);
        if (scriptManagerPlugin == null) {
            this.lazyTool().addPlugin(GhidraScriptMgrPlugin.class.getName());
            scriptManagerPlugin = this.getPlugin(GhidraScriptMgrPlugin.class);
        }
        JavaScriptProvider scriptProvider = new JavaScriptProvider();
        PrintWriter errWriter = new PrintWriter(System.err);
        ResourceFile resourceFile = new ResourceFile(scriptFile);
        GhidraScript script = null;
        try {
            script = scriptProvider.getScriptInstance(resourceFile, errWriter);
        }
        catch (GhidraScriptLoadException e) {
            Msg.error(TestEnv.class, (Object)"Problem creating script", (Throwable)((Object)e));
        }
        if (script == null) {
            errWriter.flush();
            throw new RuntimeException("Failed to compile script " + scriptFile.getAbsolutePath());
        }
        String scriptName = scriptFile.getName();
        ScriptTaskListener listener = new ScriptTaskListener(scriptName);
        scriptManagerPlugin.runScript(scriptName, (TaskListener)listener);
        return listener;
    }

    public GhidraProject getGhidraProject() {
        return this.gp;
    }

    public void closeAndReopenProject() throws Exception {
        this.gp.setDeleteOnClose(false);
        Project project = this.gp.getProject();
        ProjectLocator projectLocator = project.getProjectLocator();
        this.gp.close();
        this.extraTools.clear();
        this.gp = GhidraProject.openProject(projectLocator.getProjectDir().getParentFile().getAbsolutePath(), projectLocator.getName(), true);
        this.gp.setDeleteOnClose(true);
        this.initializeSimpleTool();
    }

    public ProjectManager getProjectManager() {
        return this.gp.getProjectManager();
    }

    public Project getProject() {
        return this.gp.getProject();
    }

    public PluginTool restartTool() {
        this.closeTool();
        AbstractGuiTest.waitForSwing();
        this.tool = null;
        this.initializeSimpleTool();
        return this.tool;
    }

    public PluginTool launchAnotherDefaultTool() {
        PluginTool newTool = this.createDefaultTool();
        AbstractGuiTest.runSwing(() -> newTool.setToolName(newTool.getToolName() + toolID++));
        this.extraTools.add(newTool);
        return newTool;
    }

    public PluginTool[] getGhidraCreatedTools() {
        return this.gp.getProject().getToolManager().getRunningTools();
    }

    public ToolConnection connectTools(PluginTool producer, PluginTool consumer) {
        String[] events;
        ToolConnection tc = this.gp.getProject().getToolManager().getConnection(producer, consumer);
        for (String element : events = tc.getEvents()) {
            tc.connect(element);
        }
        return tc;
    }

    public void disconnectTools(PluginTool producer, PluginTool consumer) {
        String[] events;
        if (producer == null || consumer == null) {
            return;
        }
        ToolConnection tc = this.gp.getProject().getToolManager().getConnection(producer, consumer);
        for (String element : events = tc.getEvents()) {
            tc.disconnect(element);
        }
    }

    public DomainFile restoreProgram(String programName) throws FileNotFoundException {
        DomainFile df = programManager.addProgramToProject(this.getProject(), programName);
        return df;
    }

    public static ResourceFile findProvidedDataTypeArchive(String relativePathName) {
        String suffix;
        if (!((String)(relativePathName = ((String)relativePathName).replace('\\', '/'))).endsWith(suffix = ".gdt")) {
            relativePathName = (String)relativePathName + suffix;
        }
        for (ResourceFile file : Application.findFilesByExtensionInApplication((String)suffix)) {
            String path = file.getAbsolutePath().replace('\\', '/');
            if (!path.endsWith((String)relativePathName)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainFile restoreDataTypeArchive(String relativePathName, DomainFolder domainFolder) throws Exception {
        int lastIndex;
        File gdtFile;
        try {
            gdtFile = AbstractGenericTest.getTestDataFile((String)relativePathName);
        }
        catch (FileNotFoundException e) {
            gdtFile = TestEnv.findProvidedDataTypeArchive(relativePathName).getFile(true);
        }
        if (gdtFile == null || !gdtFile.exists()) {
            throw new RuntimeException("Data type archive not found: " + relativePathName);
        }
        String baseName = relativePathName;
        String suffix = ".gdt";
        if (relativePathName.toLowerCase().endsWith(suffix)) {
            baseName = baseName.substring(0, baseName.length() - suffix.length());
        }
        if ((lastIndex = baseName.lastIndexOf(47)) >= 0) {
            baseName = baseName.substring(lastIndex + 1);
        }
        if ((lastIndex = baseName.lastIndexOf(92)) >= 0) {
            baseName = baseName.substring(lastIndex + 1);
        }
        String name = baseName;
        DomainObject domainObject = null;
        DomainFile domainFile = null;
        try {
            TaskMonitor monitor = TaskMonitor.DUMMY;
            domainFile = domainFolder.createFile(name, gdtFile, monitor);
            domainObject = domainFile.getDomainObject((Object)this, true, false, monitor);
            if (domainObject.canSave()) {
                domainObject.save("Saving " + gdtFile.getName() + " GDT to project", monitor);
            }
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            if (domainObject != null) {
                domainObject.release((Object)this);
            }
        }
        return domainFile;
    }

    public void saveToCache(String progName, ProgramDB program, boolean replace, TaskMonitor monitor) throws Exception {
        programManager.saveToCache(progName, program, replace, monitor);
    }

    public boolean isProgramCached(String programName) {
        return programManager.isProgramCached(programName);
    }

    public void removeFromProgramCache(String programName) {
        programManager.removeFromProgramCache(programName);
    }

    public ProgramDB loadAnalyzedNotepad() {
        return this.getProgram("pe/w2krtm/NOTEPAD.EXE.analyzed.dont.edit");
    }

    public ProgramDB getProgram(String programName) {
        ProgramDB p = programManager.getProgram(programName);
        return p;
    }

    public PluginTool launchDefaultTool(Program program) {
        if (this.tool != null) {
            throw new AssertException("Tool already exists--you are doing something wrong!");
        }
        AbstractGuiTest.runSwing(() -> {
            this.tool = this.launchDefaultTool();
            ProgramManager pm = (ProgramManager)this.tool.getService(ProgramManager.class);
            pm.openProgram(program);
        });
        if (this.tool == null) {
            throw new NullPointerException("Unable to launch the default tool: DefaultTool");
        }
        AbstractGuiTest.waitForSwing();
        this.removeAllConsumersExceptTool(program, this.tool);
        if (program != null) {
            programManager.add(program);
        }
        return this.tool;
    }

    public PluginTool launchTool(String toolName) {
        return this.launchTool(toolName, null);
    }

    public PluginTool launchTool(String toolName, DomainFile domainFile) {
        AtomicReference ref = new AtomicReference();
        AbstractGuiTest.runSwing(() -> {
            PluginTool newTool = this.doLaunchTool(toolName);
            ref.set(newTool);
            if (newTool != null && domainFile != null) {
                newTool.acceptDomainFiles(new DomainFile[]{domainFile});
            }
        });
        PluginTool launchedTool = (PluginTool)ref.get();
        if (launchedTool == null) {
            throw new NullPointerException("Unable to launch the tool: " + toolName);
        }
        this.extraTools.add(launchedTool);
        return launchedTool;
    }

    public PluginTool launchToolWithURL(String toolName, URL ghidraUrl) {
        AtomicReference ref = new AtomicReference();
        AbstractGuiTest.runSwing(() -> {
            PluginTool newTool = this.doLaunchTool(toolName);
            ref.set(newTool);
            if (newTool != null) {
                newTool.accept(ghidraUrl);
            }
        });
        PluginTool launchedTool = (PluginTool)ref.get();
        if (launchedTool == null) {
            throw new NullPointerException("Unable to launch the tool: " + toolName);
        }
        this.extraTools.add(launchedTool);
        return launchedTool;
    }

    private PluginTool doLaunchTool(String toolName) {
        boolean wasErrorGUIEnabled = AbstractDockingTest.isUseErrorGUI();
        AbstractDockingTest.setErrorGUIEnabled((boolean)false);
        FrontEndTool frontEndToolInstance = this.getFrontEndTool();
        Project project = frontEndToolInstance.getProject();
        ToolServices toolServices = project.getToolServices();
        PluginTool newTool = toolServices.launchTool(toolName, null);
        if (newTool == null) {
            newTool = this.launchDefaultToolByName(toolName);
        }
        AbstractDockingTest.setErrorGUIEnabled((boolean)wasErrorGUIEnabled);
        return newTool;
    }

    public void setAutoSaveEnabled(boolean enabled) {
        FrontEndTool frontEndToolInstance = this.getFrontEndTool();
        this.setAutoSaveEnabled(frontEndToolInstance, enabled);
    }

    protected void setAutoSaveEnabled(FrontEndTool frontEndToolInstance, boolean enabled) {
        AbstractGuiTest.runSwing(() -> {
            ToolOptions options = frontEndToolInstance.getOptions("Tool");
            options.setBoolean("Automatically Save Tools", enabled);
        });
    }

    public Program loadResourceProgramAsBinary(String programName, Language language, CompilerSpec compilerSpec) throws LanguageNotFoundException, IOException, CancelledException, VersionException {
        File file = AbstractGenericTest.getTestDataFile((String)programName);
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Can not find test program: " + programName);
        }
        return this.gp.importProgram(file, language, compilerSpec);
    }

    public Program loadResourceProgramAsBinary(String programName, Processor processor) throws CancelledException, VersionException, IOException {
        Language language = DefaultLanguageService.getLanguageService().getDefaultLanguage(processor);
        CompilerSpec compilerSpec = language.getDefaultCompilerSpec();
        return this.loadResourceProgramAsBinary(programName, language, compilerSpec);
    }

    public void release(Program program) {
        programManager.release(program);
    }

    private void cleanupAutoAnalysisManagers(PluginTool t) {
        Map map = (Map)TestUtils.getInstanceField((String)"managerMap", AutoAnalysisManager.class);
        Collection managers = map.values();
        for (AutoAnalysisManager manager : managers) {
            Map toolMap = (Map)TestUtils.getInstanceField((String)"toolMap", (Object)manager);
            Collection values = toolMap.values();
            for (WeakSet toolSet : values) {
                for (PluginTool aaTool : toolSet) {
                    manager.removeTool(aaTool);
                }
            }
        }
    }

    public void open(Program program) {
        this.lazyTool().firePluginEvent((PluginEvent)new OpenProgramPluginEvent("Test", program));
        programManager.add(program);
    }

    public void close(Program p) {
        this.release(p);
        boolean ignoreChanges = true;
        this.lazyTool().firePluginEvent((PluginEvent)new CloseProgramPluginEvent("Test", p, ignoreChanges));
        this.extraTools.forEach(t -> t.firePluginEvent((PluginEvent)new CloseProgramPluginEvent("Test", p, ignoreChanges)));
    }

    public void dispose() {
        instances.remove(this);
        AbstractDockingTest.disposeErrorGUI();
        this.printOpenModalDialogs();
        try {
            this.disconnectConnectedTools();
        }
        catch (Throwable t) {
            Msg.error(TestEnv.class, (Object)"Problem disconnecting tools", (Throwable)t);
        }
        this.disposeAllTasks();
        this.markAllProgramsAsUnchanged();
        this.disposeTestTools();
        this.privateWaitForSwingRunnables();
        programManager.disposeOpenPrograms();
        if (this.gp.getProject() == null) {
            throw new IllegalStateException("The TestEnv's GhidraProject has already been closed!");
        }
        Project project = this.gp.getProject();
        String projectName = project.getName();
        try {
            AbstractGuiTest.runSwing(() -> this.gp.close());
        }
        catch (Throwable t) {
            Msg.error(TestEnv.class, (Object)"Problem disposing the test project", (Throwable)t);
        }
        this.privateWaitForSwingRunnables();
        this.disposeFrontEndTool();
        AbstractDockingTest.closeAllWindows((boolean)true);
        this.disposeAllSwingUpdateManagers();
        this.deleteTestProject(projectName);
    }

    private void deleteTestProject(String projectName) {
        boolean deletedProject = AbstractGhidraHeadlessIntegrationTest.deleteProject(AbstractGTest.getTestDirectoryPath(), projectName);
        if (!deletedProject) {
            Msg.error(TestEnv.class, (Object)"dispose() - Open programs after disposing project: ");
            Iterator iterator = ProgramUtilities.getSystemPrograms();
            while (iterator.hasNext()) {
                Program program = (Program)iterator.next();
                if (program.isClosed()) continue;
                System.err.println("->" + projectName + " " + program.getName());
                this.printProgramConsumers(program);
            }
            Msg.error(TestEnv.class, (Object)("Unable to delete project: " + projectName + " in directory: " + AbstractGTest.getTestDirectoryPath()), (Throwable)new RuntimeException());
        }
    }

    private void disposeAllTasks() {
        Map tasks = (Map)TestUtils.getInstanceField((String)"runningTasks", TaskUtilities.class);
        for (TaskMonitor tm : tasks.values()) {
            tm.cancel();
        }
        AbstractGTest.waitForConditionWithoutFailing(() -> !TaskUtilities.isExecutingTasks());
        this.privateWaitForSwingRunnables();
    }

    private void printOpenModalDialogs() {
        boolean hasModal = false;
        Set windows = AbstractGuiTest.getAllWindows();
        for (Window window : windows) {
            if (!(window instanceof Dialog) || !((Dialog)window).isModal() || !window.isShowing()) continue;
            hasModal = true;
            break;
        }
        if (!hasModal) {
            return;
        }
        String windowInfo = AbstractDockingTest.getOpenWindowsAsString();
        if (!windowInfo.isEmpty()) {
            Msg.error(TestEnv.class, (Object)("Open modal dialogs - all windows: " + windowInfo));
        }
    }

    private void disposeTestTools() {
        AbstractGuiTest.runSwing(() -> {
            try {
                this.dipsoseTestTools();
            }
            catch (Throwable t) {
                Msg.error(TestEnv.class, (Object)"Problem disposing the test tool", (Throwable)t);
            }
        }, (boolean)false);
        this.privateWaitForSwingRunnables();
    }

    private void privateWaitForSwingRunnables() {
        AbstractGuiTest.privatewaitForSwing_SwingSafe();
    }

    private void disposeAllSwingUpdateManagers() {
        WeakSet s = (WeakSet)TestUtils.getInstanceField((String)"instances", SwingUpdateManager.class);
        AbstractGuiTest.runSwing(() -> s.clear());
    }

    private void markAllProgramsAsUnchanged() {
        programManager.markAllProgramsAsUnchanged();
    }

    private void disconnectConnectedTools() {
        if (this.extraTools.isEmpty()) {
            return;
        }
        PluginTool[] tools = new PluginTool[this.extraTools.size()];
        this.extraTools.toArray(tools);
        for (PluginTool otherTool : tools) {
            this.disconnectTools(this.tool, otherTool);
            this.disconnectTools(otherTool, this.tool);
        }
        for (int i = 0; i < tools.length; ++i) {
            PluginTool tool1 = tools[i];
            for (int j = 0; j < tools.length; ++j) {
                if (i == j) continue;
                PluginTool tool2 = tools[j];
                this.disconnectTools(tool1, tool2);
                this.disconnectTools(tool2, tool1);
            }
        }
    }

    protected void printProgramConsumers(Program program) {
        List consumerList = (List)AbstractGenericTest.getInstanceField((String)"consumers", (Object)program);
        System.err.println("\tConsumers for: " + program.getName());
        for (Object name : consumerList) {
            System.err.println("\t->" + String.valueOf(name));
        }
    }

    public void resetDefaultTools() {
        ToolChest tc = this.gp.getProject().getLocalToolChest();
        if (tc.getToolCount() > 0) {
            ToolTemplate[] templates;
            for (ToolTemplate element : templates = tc.getToolTemplates()) {
                tc.remove(element.getName());
            }
        }
        DefaultProjectManager pm = this.gp.getProjectManager();
        pm.addDefaultTools(tc);
        TestEnv.installDefaultTool(this.gp);
    }
}

