/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.decode;

import ghidra.pcode.emu.jit.JitConfiguration;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.decode.DecodedStride;
import ghidra.pcode.emu.jit.decode.DecoderForOneStride;
import ghidra.pcode.emu.jit.decode.JitPassageDecoder;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import org.apache.commons.collections4.MapUtils;

class DecoderForOnePassage {
    private final JitPassageDecoder decoder;
    private final JitPassage.AddrCtx seed;
    private final int maxOps;
    private final int maxInstrs;
    private final int maxStrides;
    final Map<PcodeOp, JitPassage.RIntBranch> internalBranches = new HashMap<PcodeOp, JitPassage.RIntBranch>();
    final SequencedMap<PcodeOp, JitPassage.RExtBranch> externalBranches = new LinkedHashMap<PcodeOp, JitPassage.RExtBranch>();
    final Map<PcodeOp, JitPassage.PBranch> otherBranches = new HashMap<PcodeOp, JitPassage.PBranch>();
    final Map<JitPassage.AddrCtx, PcodeOp> firstOps = new HashMap<JitPassage.AddrCtx, PcodeOp>();
    final List<DecodedStride> strides = new ArrayList<DecodedStride>();
    private int opCount = 0;
    private int instructionCount = 0;

    DecoderForOnePassage(JitPassageDecoder decoder, JitPassage.AddrCtx seed, int maxOps) {
        this.decoder = decoder;
        this.seed = seed;
        this.maxOps = maxOps;
        JitConfiguration config = decoder.thread.getMachine().getConfiguration();
        this.maxInstrs = config.maxPassageInstructions();
        this.maxStrides = config.maxPassageStrides();
        JitPassage.EntryPcodeOp entryOp = new JitPassage.EntryPcodeOp(seed);
        this.externalBranches.put(entryOp, new JitPassage.RExtBranch(entryOp, seed, JitPassage.Reachability.WITHOUT_CTXMOD));
    }

    void decodePassage() {
        Map.Entry<PcodeOp, JitPassage.RExtBranch> nextEnt;
        while (this.opCount < this.maxOps && this.instructionCount < this.maxInstrs && this.strides.size() < this.maxStrides && (nextEnt = this.externalBranches.pollFirstEntry()) != null) {
            JitPassage.RExtBranch next = nextEnt.getValue();
            JitPassage.AddrCtx start = next.to();
            if (this.decoder.thread.hasEntry(start)) {
                this.otherBranches.put(next.from(), next);
                continue;
            }
            if (!next.reach().canReachWithoutCtxMod()) {
                this.otherBranches.put(next.from(), next);
                continue;
            }
            this.decodeStride(start);
            PcodeOp to = Objects.requireNonNull(this.firstOps.get(start));
            this.internalBranches.put(next.from(), next.toIntBranch(to));
        }
    }

    void flowTo(JitPassage.RExtBranch eb) {
        if (!eb.reach().canReachWithoutCtxMod()) {
            this.otherBranches.put(eb.from(), eb);
            return;
        }
        PcodeOp to = this.firstOps.get(eb.to());
        if (to != null) {
            this.internalBranches.put(eb.from(), eb.toIntBranch(to));
            return;
        }
        this.externalBranches.put(eb.from(), eb);
    }

    private void decodeStride(JitPassage.AddrCtx start) {
        DecodedStride stride = new DecoderForOneStride(this.decoder, this, start).decode();
        this.opCount += stride.ops().size();
        this.instructionCount += stride.instructions().size();
        this.strides.add(stride);
    }

    JitPassage finish() {
        this.strides.sort(Comparator.comparing(DecodedStride::start));
        List<PcodeOp> code = this.strides.stream().flatMap(b -> b.ops().stream()).toList();
        List<Instruction> instructions = this.strides.stream().flatMap(b -> b.instructions().stream()).toList();
        Map<PcodeOp, JitPassage.PBranch> branches = this.otherBranches;
        branches.putAll(this.internalBranches);
        for (JitPassage.RExtBranch eb : this.externalBranches.values()) {
            PcodeOp to;
            if (!eb.reach().canReachWithoutCtxMod()) {
                branches.put(eb.from(), eb);
            }
            if ((to = this.firstOps.get(eb.to())) != null) {
                branches.put(eb.from(), eb.toIntBranch(to));
                continue;
            }
            branches.put(eb.from(), eb);
        }
        return new JitPassage(this.decoder.thread.getLanguage(), this.seed, code, this.decoder.library, instructions, branches, MapUtils.invertMap(this.firstOps));
    }

    PcodeUseropLibrary<Object> library() {
        return this.decoder.library;
    }
}

