/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.selection;

import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jungrapht.visualization.selection.AbstractMutableSelectedState;
import org.jungrapht.visualization.selection.MutableSelectedStateSink;

public class MultiMutableSelectedState<T>
extends AbstractMutableSelectedState<T>
implements MutableSelectedStateSink<T> {
    protected Set<T> selected = new LinkedHashSet<T>();

    @Override
    public boolean select(T element) {
        return this.select(element, true);
    }

    @Override
    public boolean select(T element, boolean fireEvents) {
        if (this.selected.add(element)) {
            if (fireEvents) {
                this.fireItemStateChanged(new ItemEvent(this, 701, Collections.singleton(element), 1));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deselect(T t, boolean fireEvents) {
        if (this.selected.remove(t)) {
            if (fireEvents) {
                this.fireItemStateChanged(new ItemEvent(this, 701, Collections.singleton(t), 2));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deselect(T element) {
        return this.deselect(element, true);
    }

    @Override
    public boolean select(Collection<T> elements, boolean fireEvents) {
        if (this.selected.addAll(elements)) {
            if (fireEvents) {
                this.fireItemStateChanged(new ItemEvent(this, 701, elements, 1));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean select(Collection<T> elements) {
        return this.select(elements, true);
    }

    @Override
    public boolean deselect(Collection<T> elements, boolean fireEvents) {
        if (this.selected.removeAll(elements)) {
            if (fireEvents) {
                this.fireItemStateChanged(new ItemEvent(this, 701, elements, 2));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deselect(Collection<T> elements) {
        return this.deselect(elements, true);
    }

    @Override
    public void clear(boolean fireEvents) {
        ArrayList<T> unpicks = new ArrayList<T>(this.selected);
        this.deselect((Collection<T>)unpicks, fireEvents);
        this.selected.clear();
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    @Override
    public Set<T> getSelected() {
        return Collections.unmodifiableSet(this.selected);
    }

    @Override
    public boolean isSelected(T t) {
        return this.selected.contains(t);
    }

    public T[] getSelectedObjects() {
        ArrayList<T> list = new ArrayList<T>(this.selected);
        return list.toArray();
    }
}

