/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateEditor
extends PropertyEditorSupport {
    public static DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
    private static final int NUMBER_OF_COLUMNS = 20;
    private Date date;
    private JTextField textField;
    private DateFormat dateFormat = DEFAULT_DATE_FORMAT;

    public void setDateFormat(DateFormat format) {
        this.dateFormat = format;
        if (this.textField != null) {
            this.textField.setText(this.format(this.date));
        }
    }

    public synchronized String format(Date d) {
        return this.dateFormat.format(d);
    }

    @Override
    public Component getCustomEditor() {
        return new DatePanel();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Object getValue() {
        return this.date;
    }

    @Override
    public void setValue(Object value) {
        if (this.date != null && this.date.equals(value)) {
            return;
        }
        this.date = (Date)value;
        if (this.textField != null) {
            this.textField.setText(this.format(this.date));
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            Date newDate = this.dateFormat.parse(text);
            this.setValue(newDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse text as date: " + text);
        }
    }

    private class DatePanel
    extends JPanel {
        private JButton browseButton;

        DatePanel() {
            BoxLayout bl = new BoxLayout(this, 0);
            this.setLayout(bl);
            DateEditor.this.textField = new JTextField(20);
            DateEditor.this.textField.setText(DateEditor.this.date != null ? DateEditor.this.format(DateEditor.this.date) : "");
            DateEditor.this.textField.setEditable(false);
            this.add(DateEditor.this.textField);
        }
    }
}

