/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.ActionContext;
import docking.action.ActionContextProvider;
import docking.theme.gui.FontValueEditor;
import docking.theme.gui.GThemeValuesCache;
import docking.theme.gui.ThemeFontTableModel;
import docking.theme.gui.ThemeTable;
import docking.theme.gui.ThemeTableContext;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import generic.theme.FontValue;
import generic.theme.ThemeManager;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;

public class ThemeFontTable
extends JPanel
implements ActionContextProvider,
ThemeTable {
    private ThemeFontTableModel fontTableModel;
    private FontValueEditor fontEditor = new FontValueEditor(this::fontValueChanged);
    private GTable table;
    private GFilterTable<FontValue> filterTable;
    private ThemeManager themeManager;

    public ThemeFontTable(ThemeManager themeManager, GThemeValuesCache valuesProvider) {
        super(new BorderLayout());
        this.themeManager = themeManager;
        this.fontTableModel = new ThemeFontTableModel(valuesProvider);
        this.filterTable = new GFilterTable<FontValue>(this.fontTableModel);
        this.table = this.filterTable.getTable();
        this.table.setSelectionMode(0);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FontValue fontValue = ThemeFontTable.this.filterTable.getSelectedRowObject();
                    if (fontValue != null) {
                        ThemeFontTable.this.fontEditor.editValue(fontValue);
                    }
                    e.consume();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FontValue value = ThemeFontTable.this.filterTable.getItemAt(e.getPoint());
                    int col = ThemeFontTable.this.filterTable.getColumn(e.getPoint());
                    TableColumn column = ThemeFontTable.this.table.getColumnModel().getColumn(col);
                    Object identifier = column.getIdentifier();
                    if ("Current Font".equals(identifier) || "Id".equals(identifier)) {
                        ThemeFontTable.this.fontEditor.editValue(value);
                    }
                }
            }
        });
        this.add(this.filterTable, "Center");
    }

    @Override
    public void setShowSystemValues(boolean show) {
        this.fontTableModel.setShowSystemValues(show);
        this.reloadAll();
    }

    @Override
    public boolean isShowingSystemValues() {
        return this.fontTableModel.isShowingSystemValues();
    }

    void fontValueChanged(PropertyChangeEvent event) {
        Swing.runLater(() -> {
            FontValue newValue = (FontValue)event.getNewValue();
            this.themeManager.setFont(newValue);
        });
    }

    public void reloadAll() {
        this.fontTableModel.reloadAll();
    }

    public void reloadCurrent() {
        this.fontTableModel.reloadCurrent();
    }

    @Override
    public ActionContext getActionContext(MouseEvent e) {
        if (e != null && e.getSource() == this.table) {
            FontValue currentValue = this.filterTable.getSelectedRowObject();
            if (currentValue == null) {
                return null;
            }
            String id = currentValue.getId();
            FontValue themeValue = this.fontTableModel.getThemeValue(id);
            return new ThemeTableContext(currentValue, themeValue, this);
        }
        return null;
    }
}

