/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.DockingUtils;
import docking.widgets.DropDownTextField;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.StringColumnConstraint;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constrainteditor.DataLoadingConstraintEditor;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class AutocompletingStringConstraintEditor
extends DataLoadingConstraintEditor<String> {
    protected DropDownTextField<String> textField;
    private AutocompleteDataModel autocompleter = new AutocompleteDataModel();

    public AutocompletingStringConstraintEditor(StringColumnConstraint constraint, ColumnData<String> columnDataSource) {
        super(constraint, columnDataSource);
    }

    @Override
    protected Component buildDelegateInlineEditor() {
        JPanel panel = new JPanel(new BorderLayout());
        this.textField = new DropDownTextField<String>(this.autocompleter, 100);
        this.textField.setIgnoreEnterKeyPress(true);
        this.textField.getDocument().addUndoableEditListener(e -> this.valueChanged());
        DockingUtils.installUndoRedo(this.textField);
        panel.add(this.textField, "North");
        this.textField.addActionListener(e -> this.textField.closeDropDownWindow());
        return panel;
    }

    @Override
    protected boolean checkEditorValueValidity() {
        return this.getConstraint().isValidPatternString(this.textField.getText().trim());
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        String status = AutocompletingStringConstraintEditor.formatStatus(isValid ? "&nbsp;" : "Please enter a valid string to match!", true);
        this.statusLabel.setText(status);
    }

    @Override
    protected void resetEditor() {
        this.textField.setText("");
        this.autocompleter.clear();
    }

    @Override
    protected ColumnConstraint<String> getValueFromComponent() {
        String newPatternString = this.textField.getText().trim();
        return this.getConstraint().copy(newPatternString);
    }

    @Override
    public void handleColumnDataValue(String value) {
        this.autocompleter.collect(value);
    }

    @Override
    public void columnDataLoadComplete() {
    }

    @Override
    public void columnDataLoadCancelled() {
        this.autocompleter.loadCancelled();
    }

    @Override
    public void clearColumnData() {
        this.autocompleter.clear();
    }

    @Override
    protected void doUpdateEditorComponent() {
        if (this.hasEditorComponents()) {
            this.textField.setText(this.getConstraint().getPatternString());
            this.textField.setCaretPosition(0);
        }
    }

    private StringColumnConstraint getConstraint() {
        return (StringColumnConstraint)this.currentConstraint;
    }

    private class AutocompleteDataModel
    implements DropDownTextFieldDataModel<String> {
        private final Set<String> dataSet = new HashSet<String>();
        private StringColumnConstraint lastConstraint;

        private AutocompleteDataModel() {
        }

        @Override
        public List<String> getMatchingData(String searchText) {
            if (!this.isValidPatternString(searchText)) {
                return Collections.emptyList();
            }
            if (StringUtils.isBlank((CharSequence)searchText)) {
                return Collections.emptyList();
            }
            searchText = searchText.trim();
            this.lastConstraint = (StringColumnConstraint)AutocompletingStringConstraintEditor.this.currentConstraint.parseConstraintValue(searchText, AutocompletingStringConstraintEditor.this.columnDataSource.getTableDataSource());
            Collator collator = Collator.getInstance();
            collator.setStrength(1);
            return this.dataSet.stream().filter(k -> this.lastConstraint.accepts((String)k, (TableFilterContext)null)).sorted((k1, k2) -> collator.compare((String)k1, (String)k2)).collect(Collectors.toList());
        }

        private boolean isValidPatternString(String searchText) {
            StringColumnConstraint stringConstraint = (StringColumnConstraint)AutocompletingStringConstraintEditor.this.currentConstraint;
            return stringConstraint.isValidPatternString(searchText);
        }

        @Override
        public int getIndexOfFirstMatchingEntry(List<String> data, String text) {
            return 0;
        }

        @Override
        public ListCellRenderer<String> getListRenderer() {
            return new AutocompleteListCellRenderer(this);
        }

        @Override
        public String getDescription(String value) {
            return null;
        }

        @Override
        public String getDisplayText(String value) {
            return value;
        }

        public void collect(String value) {
            if (value == null) {
                return;
            }
            this.dataSet.add(value);
        }

        public void loadCancelled() {
        }

        public void clear() {
            this.dataSet.clear();
        }
    }

    private class AutocompleteListCellRenderer
    extends GListCellRenderer<String> {
        private final AutocompleteDataModel model;

        public AutocompleteListCellRenderer(AutocompleteDataModel autocompleteDataModel) {
            this.model = autocompleteDataModel;
            this.setHTMLRenderingEnabled(true);
        }

        private String formatListValue(String value, boolean isSelected) {
            Matcher matcher = this.model.lastConstraint.getHighlightMatcher(value);
            GColor color = isSelected ? GThemeDefaults.Colors.Palette.YELLOW : GThemeDefaults.Colors.Palette.MAGENTA;
            StringBuilder sb = new StringBuilder("<html>");
            int start = 0;
            while (matcher.find()) {
                String group = matcher.group(1);
                int nextStart = matcher.start();
                String previousText = value.substring(start, nextStart);
                start = matcher.end();
                sb.append(HTMLUtilities.escapeHTML((String)previousText));
                String quoted = Matcher.quoteReplacement(group);
                String escaped = HTMLUtilities.escapeHTML((String)quoted);
                String replacement = HTMLUtilities.colorString((Color)color, (String)HTMLUtilities.bold((String)escaped));
                sb.append(replacement);
            }
            String trailing = value.substring(start, value.length());
            sb.append(HTMLUtilities.escapeHTML((String)trailing));
            return sb.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String valueString = this.formatListValue(value, isSelected);
            this.setText(valueString);
            return this;
        }
    }
}

