/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.EndInstructionValue;
import java.util.Map;
import java.util.Set;

public class EndInstructionValueSolver
extends AbstractExpressionSolver<EndInstructionValue> {
    public EndInstructionValueSolver() {
        super(EndInstructionValue.class);
    }

    @Override
    public AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, EndInstructionValue exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        throw new AssertionError((Object)"INTERNAL: Should never be asked to solve for inst_next");
    }

    @Override
    public MaskedLong getValue(EndInstructionValue iv, Map<String, Long> vals, AssemblyResolvedPatterns cur) throws NeedsBackfillException {
        Long instNext = vals.get("inst_next");
        if (instNext == null) {
            throw new NeedsBackfillException("inst_next");
        }
        return MaskedLong.fromLong(instNext);
    }

    @Override
    public int getInstructionLength(EndInstructionValue iv) {
        return 0;
    }

    @Override
    public MaskedLong valueForResolution(EndInstructionValue exp, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        Long instNext = vals.get("inst_next");
        if (instNext == null) {
            return MaskedLong.UNKS;
        }
        return MaskedLong.fromLong(instNext);
    }
}

