/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.languages.sleigh;

import ghidra.app.plugin.languages.sleigh.SubtableEntryVisitor;
import ghidra.app.plugin.languages.sleigh.VisitorResults;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.DecisionNode;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import java.util.Iterator;

class SleighSubtableTraversal
implements VisitorResults {
    protected final SubtableSymbol sub;

    public SleighSubtableTraversal(SubtableSymbol sub) {
        this.sub = sub;
    }

    public int traverse(SubtableEntryVisitor visitor) {
        int result = this.traverse(this.sub.getDecisionNode(), visitor);
        if (result == 0) {
            return 1;
        }
        return result;
    }

    protected int traverse(DecisionNode node, SubtableEntryVisitor visitor) {
        Iterator<DisjointPattern> pit = node.getPatterns().iterator();
        Iterator<Constructor> cit = node.getConstructors().iterator();
        while (pit.hasNext()) {
            int result = visitor.visit(pit.next(), cit.next());
            if (result == 0) continue;
            return result;
        }
        for (DecisionNode child : node.getChildren()) {
            int result = this.traverse(child, visitor);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

