/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;

public class ConstTpl {
    private const_type type;
    private AddrSpace spaceid;
    private int handle_index;
    private long value_real;
    private v_field select;

    public String toString() {
        return switch (this.type.ordinal()) {
            case 0 -> "ConstTpl[real=0x%x]".formatted(this.value_real);
            case 1 -> "ConstTpl[handle=%d,sel=%s]".formatted(new Object[]{this.handle_index, this.select});
            case 7 -> "ConstTpl[space=%s]".formatted(this.spaceid);
            default -> "ConstTpl[type=%s,real=0x%x,space=%s,handle=%d,sel=%s]".formatted(new Object[]{this.type, this.value_real, this.spaceid, this.handle_index, this.select});
        };
    }

    public ConstTpl() {
        this.type = const_type.real;
        this.value_real = 0L;
    }

    public ConstTpl(ConstTpl op2) {
        this.type = op2.type;
        this.spaceid = op2.spaceid;
        this.handle_index = op2.handle_index;
        this.value_real = op2.value_real;
        this.select = op2.select;
    }

    public ConstTpl(const_type tp) {
        this.type = tp;
    }

    public ConstTpl(const_type tp, long val) {
        this.type = tp;
        this.value_real = val;
    }

    public ConstTpl(const_type tp, int ht, v_field vf) {
        this.type = const_type.handle;
        this.handle_index = ht;
        this.select = vf;
    }

    public ConstTpl(const_type tp, int ht, v_field vf, long plus) {
        this.type = const_type.handle;
        this.handle_index = ht;
        this.select = vf;
        this.value_real = plus;
    }

    public ConstTpl(AddrSpace sid) {
        this.type = const_type.spaceid;
        this.spaceid = sid;
    }

    public long getReal() {
        return this.value_real;
    }

    public AddrSpace getSpace() {
        return this.spaceid;
    }

    public int getHandleIndex() {
        return this.handle_index;
    }

    public const_type getType() {
        return this.type;
    }

    public v_field getSelect() {
        return this.select;
    }

    public boolean isZero() {
        return this.type == const_type.real && this.value_real == 0L;
    }

    public boolean isConstSpace() {
        if (this.type == const_type.spaceid) {
            return this.spaceid.getType() == spacetype.IPTR_CONSTANT;
        }
        return false;
    }

    public boolean isUniqueSpace() {
        if (this.type == const_type.spaceid) {
            return this.spaceid.getType() == spacetype.IPTR_INTERNAL;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConstTpl)) {
            return false;
        }
        ConstTpl op2 = (ConstTpl)obj;
        if (this.type != op2.type) {
            return false;
        }
        switch (this.type.ordinal()) {
            case 0: {
                return this.value_real == op2.value_real;
            }
            case 1: {
                if (this.handle_index != op2.handle_index) {
                    return false;
                }
                if (this.select == op2.select) break;
                return false;
            }
            case 7: {
                return this.spaceid == op2.spaceid;
            }
        }
        return true;
    }

    public int compareTo(ConstTpl op2) {
        if (this.type != op2.type) {
            return this.type.ordinal() - op2.type.ordinal();
        }
        switch (this.type.ordinal()) {
            case 0: {
                long diff = this.value_real - op2.value_real;
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
            case 1: {
                if (this.handle_index != op2.handle_index) {
                    return this.handle_index - op2.handle_index;
                }
                return this.select.compareTo(op2.select);
            }
            case 7: {
                return this.spaceid.compareTo(op2.spaceid);
            }
        }
        return 0;
    }

    private void copyIntoMe(ConstTpl other) {
        this.type = other.type;
        this.spaceid = other.spaceid;
        this.handle_index = other.handle_index;
        this.value_real = other.value_real;
        this.select = other.select;
    }

    public void transfer(VectorSTL<HandleTpl> params) {
        if (this.type != const_type.handle) {
            return;
        }
        HandleTpl newhandle = (HandleTpl)params.get(this.handle_index);
        switch (this.select.ordinal()) {
            case 0: {
                this.copyIntoMe(newhandle.getSpace());
                break;
            }
            case 1: {
                this.copyIntoMe(newhandle.getPtrOffset());
                break;
            }
            case 2: {
                this.copyIntoMe(newhandle.getSize());
                break;
            }
            case 3: {
                long tmp = this.value_real;
                this.copyIntoMe(newhandle.getPtrOffset());
                if (this.type == const_type.real) {
                    this.value_real += tmp & 0xFFFFL;
                    break;
                }
                if (this.type == const_type.handle && this.select == v_field.v_offset) {
                    this.select = v_field.v_offset_plus;
                    this.value_real = tmp;
                    break;
                }
                throw new LowlevelError("Cannot truncate macro input in this way");
            }
        }
    }

    public void changeHandleIndex(VectorSTL<Integer> handmap) {
        if (this.type == const_type.handle) {
            this.handle_index = (Integer)handmap.get(this.handle_index);
        }
    }

    public void encode(Encoder encoder) throws IOException {
        switch (this.type.ordinal()) {
            case 0: {
                encoder.openElement(SlaFormat.ELEM_CONST_REAL);
                encoder.writeUnsignedInteger(SlaFormat.ATTRIB_VAL, this.value_real);
                encoder.closeElement(SlaFormat.ELEM_CONST_REAL);
                break;
            }
            case 1: {
                encoder.openElement(SlaFormat.ELEM_CONST_HANDLE);
                encoder.writeSignedInteger(SlaFormat.ATTRIB_VAL, this.handle_index);
                encoder.writeSignedInteger(SlaFormat.ATTRIB_S, this.select.ordinal());
                if (this.select == v_field.v_offset_plus) {
                    encoder.writeUnsignedInteger(SlaFormat.ATTRIB_PLUS, this.value_real);
                }
                encoder.closeElement(SlaFormat.ELEM_CONST_HANDLE);
                break;
            }
            case 2: {
                encoder.openElement(SlaFormat.ELEM_CONST_START);
                encoder.closeElement(SlaFormat.ELEM_CONST_START);
                break;
            }
            case 3: {
                encoder.openElement(SlaFormat.ELEM_CONST_NEXT);
                encoder.closeElement(SlaFormat.ELEM_CONST_NEXT);
                break;
            }
            case 4: {
                encoder.openElement(SlaFormat.ELEM_CONST_NEXT2);
                encoder.closeElement(SlaFormat.ELEM_CONST_NEXT2);
                break;
            }
            case 5: {
                encoder.openElement(SlaFormat.ELEM_CONST_CURSPACE);
                encoder.closeElement(SlaFormat.ELEM_CONST_CURSPACE);
                break;
            }
            case 6: {
                encoder.openElement(SlaFormat.ELEM_CONST_CURSPACE_SIZE);
                encoder.closeElement(SlaFormat.ELEM_CONST_CURSPACE_SIZE);
                break;
            }
            case 7: {
                encoder.openElement(SlaFormat.ELEM_CONST_SPACEID);
                encoder.writeSpace(SlaFormat.ATTRIB_SPACE, this.spaceid.getIndex(), this.spaceid.getName());
                encoder.closeElement(SlaFormat.ELEM_CONST_SPACEID);
                break;
            }
            case 8: {
                encoder.openElement(SlaFormat.ELEM_CONST_RELATIVE);
                encoder.writeUnsignedInteger(SlaFormat.ATTRIB_VAL, this.value_real);
                encoder.closeElement(SlaFormat.ELEM_CONST_RELATIVE);
                break;
            }
            case 9: {
                encoder.openElement(SlaFormat.ELEM_CONST_FLOWREF);
                encoder.closeElement(SlaFormat.ELEM_CONST_FLOWREF);
                break;
            }
            case 10: {
                encoder.openElement(SlaFormat.ELEM_CONST_FLOWREF_SIZE);
                encoder.closeElement(SlaFormat.ELEM_CONST_FLOWREF_SIZE);
                break;
            }
            case 11: {
                encoder.openElement(SlaFormat.ELEM_CONST_FLOWDEST);
                encoder.closeElement(SlaFormat.ELEM_CONST_FLOWDEST);
                break;
            }
            case 12: {
                encoder.openElement(SlaFormat.ELEM_CONST_FLOWDEST_SIZE);
                encoder.closeElement(SlaFormat.ELEM_CONST_FLOWDEST_SIZE);
            }
        }
    }

    public static enum const_type {
        real,
        handle,
        j_start,
        j_next,
        j_next2,
        j_curspace,
        j_curspace_size,
        spaceid,
        j_relative,
        j_flowref,
        j_flowref_size,
        j_flowdest,
        j_flowdest_size;

    }

    public static enum v_field {
        v_space,
        v_offset,
        v_size,
        v_offset_plus;

    }
}

