/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.function.FunctionTagAdapter;
import ghidra.program.database.function.FunctionTagDB;
import ghidra.program.database.function.FunctionTagMappingAdapter;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Lock;
import ghidra.util.datastruct.Counter;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LazyMap;

public class FunctionTagManagerDB
implements FunctionTagManager,
ErrorHandler {
    private ProgramDB program;
    private FunctionTagAdapter functionTagAdapter;
    private FunctionTagMappingAdapter functionTagMappingAdapter;
    private DBObjectCache<FunctionTagDB> cache;
    private Map<FunctionTag, Counter> tagCountCache;
    protected final Lock lock;

    FunctionTagManagerDB(DBHandle handle, OpenMode openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        this.lock = lock;
        this.functionTagAdapter = FunctionTagAdapter.getAdapter(handle, openMode, monitor);
        this.functionTagMappingAdapter = FunctionTagMappingAdapter.getAdapter(handle, openMode, monitor);
        this.cache = new DBObjectCache(100);
    }

    public void setProgram(Program program) {
        this.program = (ProgramDB)program;
    }

    public void dbError(IOException e) {
        this.program.dbError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionTag getFunctionTag(String name) {
        this.lock.acquire();
        try {
            DBRecord rec = this.functionTagAdapter.getRecord(name);
            if (rec != null) {
                FunctionTag functionTag = this.getFunctionTagFromCache(rec);
                return functionTag;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionTag getFunctionTag(long id) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.cache.get(id);
            if (tag != null) {
                FunctionTag functionTag = tag;
                return functionTag;
            }
            DBRecord rec = this.functionTagAdapter.getRecord(id);
            if (rec != null) {
                FunctionTagDB functionTagDB = new FunctionTagDB(this, this.cache, rec);
                return functionTagDB;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTagAssigned(String name) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.getFunctionTag(name);
            if (tag == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.functionTagMappingAdapter.isTagAssigned(tag.getId());
            return bl;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionTag createFunctionTag(String name, String comment) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.getFunctionTag(name);
            if (tag != null) {
                FunctionTag functionTag = tag;
                return functionTag;
            }
            DBRecord record = this.functionTagAdapter.createTagRecord(name, comment);
            tag = this.getFunctionTagFromCache(record);
            this.fireTagCreatedNotification(ProgramEvent.FUNCTION_TAG_CREATED, tag);
            FunctionTag functionTag = tag;
            return functionTag;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTagApplied(long functionId, long tagId) {
        this.lock.acquire();
        try {
            boolean bl = this.functionTagMappingAdapter.getRecord(functionId, tagId) != null;
            return bl;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyFunctionTag(long functionId, long tagId) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.getFunctionTag(tagId);
            if (tag == null) {
                return;
            }
            this.functionTagMappingAdapter.createFunctionTagRecord(functionId, tagId);
            this.incrementCountCache(tag);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void incrementCountCache(FunctionTag tag) {
        if (this.tagCountCache != null) {
            this.tagCountCache.get(tag).increment();
        }
    }

    private void decrementCountCache(FunctionTag tag) {
        if (this.tagCountCache != null) {
            this.tagCountCache.get(tag).decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFunctionTag(long functionId, long tagId) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.getFunctionTag(tagId);
            if (tag == null) {
                boolean bl = false;
                return bl;
            }
            if (this.functionTagMappingAdapter.removeFunctionTagRecord(functionId, tagId)) {
                this.decrementCountCache(tag);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    void updateFunctionTag(FunctionTagDB tag, String oldValue, String newValue) throws IOException {
        this.functionTagAdapter.updateRecord(tag.getRecord());
        this.fireTagChangedNotification(ProgramEvent.FUNCTION_TAG_CHANGED, tag, oldValue, newValue);
        this.invalidateFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends FunctionTag> getAllFunctionTags() {
        this.lock.acquire();
        try {
            ArrayList<FunctionTag> tags = new ArrayList<FunctionTag>();
            RecordIterator records = this.functionTagAdapter.getRecords();
            while (records.hasNext()) {
                DBRecord record = records.next();
                tags.add(this.getFunctionTagFromCache(record));
            }
            ArrayList<FunctionTag> arrayList = tags;
            return arrayList;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return Collections.emptyList();
    }

    public DBRecord getTagRecord(long id) throws IOException {
        return this.functionTagAdapter.getRecord(id);
    }

    private void fireTagChangedNotification(ProgramEvent eventType, FunctionTag tag, String oldValue, String newValue) {
        this.program.tagChanged(tag, eventType, oldValue, newValue);
    }

    private void fireTagCreatedNotification(ProgramEvent eventType, FunctionTag tag) {
        this.program.tagCreated(tag, eventType);
    }

    private void fireTagDeletedNotification(ProgramEvent eventType, FunctionTag tag) {
        this.program.tagChanged(tag, eventType, tag, null);
    }

    private FunctionTag getFunctionTagFromCache(DBRecord tagRecord) {
        FunctionTagDB tag = this.cache.get(tagRecord);
        if (tag == null) {
            tag = new FunctionTagDB(this, this.cache, tagRecord);
        }
        return tag;
    }

    void doDeleteTag(FunctionTag tag) throws IOException {
        this.functionTagMappingAdapter.removeFunctionTagRecord(tag.getId());
        this.functionTagAdapter.removeTagRecord(tag.getId());
        this.cache.delete(tag.getId());
        this.fireTagDeletedNotification(ProgramEvent.FUNCTION_TAG_DELETED, tag);
        this.invalidateFunctions();
    }

    private void invalidateFunctions() {
        FunctionManagerDB functionManager = this.program.getFunctionManager();
        functionManager.functionTagsChanged();
    }

    Set<FunctionTag> getFunctionTagsByFunctionID(long functionId) throws IOException {
        HashSet<FunctionTag> tags = new HashSet<FunctionTag>();
        RecordIterator functionRecords = this.functionTagMappingAdapter.getRecordsByFunctionID(functionId);
        while (functionRecords.hasNext()) {
            DBRecord mappingRecord = functionRecords.next();
            DBRecord tagRecord = this.functionTagAdapter.getRecord(mappingRecord.getLongValue(1));
            tags.add(this.getFunctionTagFromCache(tagRecord));
        }
        return tags;
    }

    void invalidateCache() {
        this.cache.invalidate();
        this.tagCountCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUseCount(FunctionTag tag) {
        this.lock.acquire();
        try {
            if (this.tagCountCache == null) {
                this.buildTagCountCache();
            }
            Counter counter = this.tagCountCache.get(tag);
            int n = counter.count();
            return n;
        }
        catch (IOException e) {
            this.dbError(e);
            int n = 0;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    private void buildTagCountCache() throws IOException {
        LazyMap map = LazyMap.lazyMap(new HashMap(), () -> new Counter());
        RecordIterator records = this.functionTagMappingAdapter.getRecords();
        while (records.hasNext()) {
            DBRecord mappingRecord = records.next();
            long tagId = mappingRecord.getLongValue(1);
            FunctionTag tag = this.getFunctionTag(tagId);
            ((Counter)map.get(tag)).increment();
        }
        this.tagCountCache = map;
    }
}

