/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.GhidraClassDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;

public class ClassSymbol
extends SymbolDB {
    private GhidraClassDB ghidraClass;

    ClassSymbol(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, DBRecord record) {
        super(symbolMgr, cache, Address.NO_ADDRESS, record);
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.CLASS;
    }

    @Override
    public GhidraClass getObject() {
        this.lock.acquire();
        try {
            if (!this.checkIsValid()) {
                GhidraClass ghidraClass = null;
                return ghidraClass;
            }
            if (this.ghidraClass == null) {
                this.ghidraClass = new GhidraClassDB(this, this.symbolMgr.getProgram().getNamespaceManager());
            }
            GhidraClassDB ghidraClassDB = this.ghidraClass;
            return ghidraClassDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isExternal() {
        Symbol parentSymbol = this.getParentSymbol();
        return parentSymbol != null ? parentSymbol.isExternal() : false;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return super.isValidParent(parent) && SymbolType.CLASS.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }
}

