/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetCollection;
import ghidra.program.model.address.AddressSetView;
import java.util.ArrayList;
import java.util.List;

public class SynchronizedAddressSetCollection
implements AddressSetCollection {
    private List<AddressSetView> addressSetList = new ArrayList<AddressSetView>();
    private Object sync;

    public SynchronizedAddressSetCollection(Object sync, AddressSetView ... addressSetViews) {
        this.sync = sync;
        for (AddressSetView addressSetView : addressSetViews) {
            if (addressSetView == null || addressSetView.isEmpty()) continue;
            this.addressSetList.add(addressSetView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(AddressSetView addrSet) {
        Object object = this.sync;
        synchronized (object) {
            for (AddressSetView addressSet : this.addressSetList) {
                if (!addressSet.intersects(addrSet)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(Address start, Address end) {
        Object object = this.sync;
        synchronized (object) {
            for (AddressSetView addressSet : this.addressSetList) {
                if (!addressSet.intersects(start, end)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Address address) {
        Object object = this.sync;
        synchronized (object) {
            for (AddressSetView addressSet : this.addressSetList) {
                if (!addressSet.contains(address)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFewerRangesThan(int rangeThreshold) {
        Object object = this.sync;
        synchronized (object) {
            int n = 0;
            for (AddressSetView addressSet : this.addressSetList) {
                if ((n += addressSet.getNumAddressRanges()) < rangeThreshold) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSet getCombinedAddressSet() {
        Object object = this.sync;
        synchronized (object) {
            AddressSet set = new AddressSet();
            for (AddressSetView addressSet : this.addressSetList) {
                set.add(addressSet);
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address findFirstAddressInCommon(AddressSetView set) {
        Object object = this.sync;
        synchronized (object) {
            Address firstCommonAddress = null;
            for (AddressSetView addressSet : this.addressSetList) {
                Address possibleFirst = addressSet.findFirstAddressInCommon(set);
                if (possibleFirst == null || firstCommonAddress != null && possibleFirst.compareTo(firstCommonAddress) >= 0) continue;
                firstCommonAddress = possibleFirst;
            }
            return firstCommonAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.sync;
        synchronized (object) {
            for (AddressSetView addressSet : this.addressSetList) {
                if (addressSet.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getMinAddress() {
        Address min = null;
        Object object = this.sync;
        synchronized (object) {
            for (AddressSetView addressSet : this.addressSetList) {
                Address setMin = addressSet.getMinAddress();
                if (setMin == null || min != null && setMin.compareTo(min) >= 0) continue;
                min = setMin;
            }
            return min;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getMaxAddress() {
        Address max = null;
        Object object = this.sync;
        synchronized (object) {
            for (AddressSetView addressSet : this.addressSetList) {
                Address setMax = addressSet.getMaxAddress();
                if (setMax == null || max != null && setMax.compareTo(max) <= 0) continue;
                max = setMax;
            }
            return max;
        }
    }
}

