/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import help.GHelpMsg;
import help.HelpBuildUtils;
import help.validator.location.DirectoryHelpModuleLocation;
import help.validator.location.HelpModuleLocation;
import help.validator.model.AnchorDefinition;
import help.validator.model.HREF;
import help.validator.model.HelpFile;
import help.validator.model.IMG;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class HelpTopic
implements Comparable<HelpTopic> {
    private final HelpModuleLocation help;
    private final Path topicDir;
    private final Path relativePath;
    private Map<Path, HelpFile> helpFiles;

    public static HelpTopic fromHTMLFile(Path topicFile) {
        Path topic = topicFile.getParent();
        Path topicsDir = topic.getParent();
        Path helpDir = topicsDir.getParent();
        DirectoryHelpModuleLocation loc = new DirectoryHelpModuleLocation(helpDir.toFile());
        HelpTopic helpTopic = new HelpTopic(loc, topicFile);
        return helpTopic;
    }

    public HelpTopic(HelpModuleLocation help, Path topicDir) {
        this.help = help;
        this.topicDir = topicDir;
        Path helpDir = help.getHelpLocation();
        Path relativeTopicPath = helpDir.relativize(topicDir);
        this.relativePath = HelpBuildUtils.relativeToWorkingDir(relativeTopicPath);
    }

    public Path getTopicDir() {
        return this.topicDir;
    }

    private void lazyLoad() {
        if (this.helpFiles != null) {
            return;
        }
        this.helpFiles = new LinkedHashMap<Path, HelpFile>();
        this.loadHelpFiles(this.topicDir);
    }

    private void loadHelpFiles(Path dir) {
        FileSystem fs = dir.getFileSystem();
        final PathMatcher matcher = fs.getPathMatcher("glob:**/*.{[Hh][Tt][Mm],[Hh][Tt][Mm][Ll]}");
        final Path dirDefaultFS = HelpBuildUtils.relativeToWorkingDir(dir);
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file)) {
                        HelpTopic.this.mapHelpFile(dirDefaultFS, file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            GHelpMsg.error("Error loading help files: " + String.valueOf(dir.toUri()), e);
        }
    }

    private void mapHelpFile(Path dirDefaultFS, Path file) {
        Path fileDefaultFS = HelpBuildUtils.relativeToWorkingDir(file);
        Path relFilePath = dirDefaultFS.relativize(fileDefaultFS);
        relFilePath = this.relativePath.resolve(relFilePath);
        this.helpFiles.put(relFilePath, new HelpFile(this.help, file));
    }

    void addHelpFile(Path relPath, HelpFile helpFile) {
        this.lazyLoad();
        this.helpFiles.put(relPath, helpFile);
    }

    public Collection<HREF> getAllHREFs() {
        if (this.topicDir.getFileSystem() != FileSystems.getDefault()) {
            return Collections.emptyList();
        }
        this.lazyLoad();
        ArrayList<HREF> list = new ArrayList<HREF>();
        for (HelpFile helpFile : this.helpFiles.values()) {
            list.addAll(helpFile.getAllHREFs());
        }
        return list;
    }

    public Collection<IMG> getAllIMGs() {
        if (this.topicDir.getFileSystem() != FileSystems.getDefault()) {
            return Collections.emptyList();
        }
        this.lazyLoad();
        ArrayList<IMG> list = new ArrayList<IMG>();
        for (HelpFile helpFile : this.helpFiles.values()) {
            list.addAll(helpFile.getAllIMGs());
        }
        return list;
    }

    public Collection<AnchorDefinition> getAllAnchorDefinitions() {
        this.lazyLoad();
        ArrayList<AnchorDefinition> list = new ArrayList<AnchorDefinition>();
        for (HelpFile helpFile : this.helpFiles.values()) {
            list.addAll(helpFile.getAllAnchorDefinitions());
        }
        return list;
    }

    public Collection<HelpFile> getHelpFiles() {
        this.lazyLoad();
        return this.helpFiles.values();
    }

    Path getRelativePath() {
        return this.relativePath;
    }

    public HelpModuleLocation getHelpDirectory() {
        return this.help;
    }

    public String getName() {
        return this.topicDir.getFileName().toString();
    }

    @Override
    public int compareTo(HelpTopic o) {
        return this.topicDir.compareTo(o.topicDir);
    }

    public String toString() {
        return this.topicDir.toString();
    }
}

