/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph;

import datagraph.DataGraphPlugin;
import datagraph.data.graph.DegController;
import datagraph.data.graph.DegVertex;
import datagraph.data.graph.panel.DataVertexPanel;
import datagraph.data.graph.panel.model.row.DataRowObject;
import datagraph.graph.explore.EgVertex;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.util.HelpLocation;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import resources.Icons;

public class DataDegVertex
extends DegVertex {
    private Data data;
    private DataVertexPanel dataVertexPanel;
    private DockingAction deleteAction;
    private long dataTypeHash;

    public DataDegVertex(DegController controller, Data data, DegVertex source, boolean compactFormat) {
        super(controller, source);
        this.data = data;
        this.dataVertexPanel = new DataVertexPanel(controller, this, compactFormat);
        this.createActions();
        this.dataVertexPanel.updateHeader();
        this.dataVertexPanel.updateShape();
        if (source == null) {
            this.dataVertexPanel.setIsRoot(true);
        }
        this.dataTypeHash = this.hash(data.getDataType());
    }

    @Override
    public String getTitle() {
        return this.dataVertexPanel.getTitle();
    }

    @Override
    public DegVertex.DegVertexStatus refreshGraph(boolean checkDataType) {
        long newHash;
        Address address = this.data.getAddress();
        Data newData = this.data.getProgram().getListing().getDataAt(address);
        if (newData == null) {
            return DegVertex.DegVertexStatus.MISSING;
        }
        if (this.data != newData) {
            this.data = newData;
            this.dataVertexPanel.setData(newData);
            return DegVertex.DegVertexStatus.CHANGED;
        }
        if (checkDataType && (newHash = this.hash(this.data.getDataType())) != this.dataTypeHash) {
            this.dataTypeHash = newHash;
            this.dataVertexPanel.setData(this.data);
            return DegVertex.DegVertexStatus.CHANGED;
        }
        return DegVertex.DegVertexStatus.VALID;
    }

    public List<DataRowObject> getRowObjects() {
        return this.dataVertexPanel.getRowObjects();
    }

    @Override
    public void clearUserChangedLocation() {
        super.clearUserChangedLocation();
        this.controller.relayoutGraph();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public void setSource(EgVertex source) {
        super.setSource(source);
        this.dataVertexPanel.setIsRoot(source == null);
        this.deleteAction.setEnabled(source != null);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataDegVertex other = (DataDegVertex)obj;
        return this.data.equals((Object)other.data);
    }

    public JComponent getComponent() {
        return this.dataVertexPanel;
    }

    public String toString() {
        return "Data @ " + this.data.getAddress().toString();
    }

    @Override
    public Address getAddress() {
        return this.data.getAddress();
    }

    @Override
    public CodeUnit getCodeUnit() {
        return this.data;
    }

    @Override
    protected void addAction(DockingAction action) {
        this.dataVertexPanel.addAction(action);
    }

    @Override
    public DockingActionIf getAction(String name) {
        return this.dataVertexPanel.getAction(name);
    }

    @Override
    public int getOutgoingEdgeOffsetFromCenter(EgVertex v) {
        return this.dataVertexPanel.getOutgoingEdgeOffsetFromCenter(v);
    }

    @Override
    public int getIncomingEdgeOffsetFromCenter(EgVertex vertex) {
        return this.dataVertexPanel.getIncommingEdgeOffsetFromCenter(vertex);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.dataVertexPanel.setSelected(selected);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.dataVertexPanel.setFocused(focused);
    }

    @Override
    public void dispose() {
        this.dataVertexPanel.dispose();
        this.dataVertexPanel = null;
    }

    public Shape getCompactShape() {
        Shape shape = this.dataVertexPanel.getShape();
        return shape;
    }

    public Data getData() {
        return this.data;
    }

    public Dimension getSize() {
        return this.dataVertexPanel.getSize();
    }

    public void setSizeByUser(Dimension dimension) {
        this.dataVertexPanel.setSizeByUser(dimension);
    }

    public void addOutgoingEdgeAnchor(DegVertex end, int[] componentPath) {
        this.dataVertexPanel.addOutgoingEdge(end, componentPath);
    }

    public void addIncomingEdgeAnchor(DegVertex start, Address address) {
        this.dataVertexPanel.addIncommingEdge(start, address);
    }

    @Override
    public int compare(DegVertex v1, DegVertex v2) {
        return this.dataVertexPanel.comparePaths(v1, v2);
    }

    private void createActions() {
        String owner = DataGraphPlugin.class.getSimpleName();
        if (this.dataVertexPanel.isExpandable()) {
            DockingAction openAllAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Expand All", owner).toolBarIcon(Icons.EXPAND_ALL_ICON)).description("Recursively open all data in this vertex.")).helpLocation(new HelpLocation("DataGraphPlugin", "Expand_All"))).onAction(c -> this.dataVertexPanel.expandAll())).build();
            this.addAction(openAllAction);
            DockingAction closeAllAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Collapse All", owner).toolBarIcon(Icons.COLLAPSE_ALL_ICON)).description("Close all data in this vertex.")).helpLocation(new HelpLocation("DataGraphPlugin", "Collapse_All"))).onAction(c -> this.dataVertexPanel.collapseAll())).build();
            this.addAction(closeAllAction);
        }
        this.deleteAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Close Vertex", owner).toolBarIcon(Icons.CLOSE_ICON)).description("Removes this vertex and any of its descendents from the graph.")).helpLocation(new HelpLocation("DataGraphPlugin", "Delete_Vertex"))).enabled(this.source != null)).onAction(c -> this.controller.deleteVertices(Set.of(this)))).build();
        this.addAction(this.deleteAction);
    }

    @Override
    public String getTooltip(MouseEvent e) {
        return this.dataVertexPanel.getToolTipText(e);
    }

    @Override
    protected Point2D getStartingEdgePoint(EgVertex end) {
        Point2D startLocation = this.getLocation();
        int yOffset = this.getOutgoingEdgeOffsetFromCenter(end);
        double x = startLocation.getX() + (double)(this.getSize().width / 2);
        double y = startLocation.getY() + (double)yOffset;
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D getEndingEdgePoint(EgVertex start) {
        Point2D endLocation = this.getLocation();
        int yOffset = this.getIncomingEdgeOffsetFromCenter(start);
        double x = endLocation.getX() - (double)(this.getSize().width / 2);
        double y = endLocation.getY() + (double)yOffset;
        return new Point2D.Double(x, y);
    }

    public void setCompactFormat(boolean b) {
        this.dataVertexPanel.setCompactFormat(b);
    }

    public void expand(int row) {
        this.dataVertexPanel.expand(row);
    }

    public void openPointerReference(int row) {
        this.dataVertexPanel.openPointerReference(row);
    }

    public boolean isOnExpandableRow() {
        return this.dataVertexPanel.isSelectedRowExpandable();
    }

    public void expandSelectedRowRecursively() {
        this.dataVertexPanel.expandSelectedRowRecursively();
    }

    @Override
    protected boolean containsAddress(Address address) {
        return this.data.contains(address);
    }

    private long hash(DataType dataType) {
        long hash = dataType.getLength() * 31 + dataType.getName().hashCode();
        if (dataType instanceof Composite) {
            Composite composite = (Composite)dataType;
            for (DataTypeComponent dataTypeComponent : composite.getDefinedComponents()) {
                hash = 31L * hash + this.hash(dataTypeComponent.getDataType());
            }
        }
        return hash;
    }
}

