/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.dtb.FdtHeader;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DtTableEntry
implements StructConverter {
    private int dt_size;
    private int dt_offset;
    private int id;
    private int rev;
    private int[] custom;
    private FdtHeader _fdtHeader;

    public DtTableEntry(BinaryReader reader) throws IOException {
        if (!reader.isBigEndian()) {
            throw new IOException("DTB is always big endian.");
        }
        this.dt_size = reader.readNextInt();
        this.dt_offset = reader.readNextInt();
        this.id = reader.readNextInt();
        this.rev = reader.readNextInt();
        this.custom = reader.readNextIntArray(4);
        BinaryReader clonedReader = reader.clone((long)this.dt_offset);
        if (clonedReader.peekNextInt() == -804389139) {
            this._fdtHeader = new FdtHeader(clonedReader);
        }
    }

    public int getDtSize() {
        return this.dt_size;
    }

    public int getDtOffset() {
        return this.dt_offset;
    }

    public int getId() {
        return this.id;
    }

    public int getRev() {
        return this.rev;
    }

    public int[] getCustom() {
        return this.custom;
    }

    public FdtHeader getFdtHeader() {
        return this._fdtHeader;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

