/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.omf51;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryHeaderRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordFactory;
import ghidra.file.formats.omf51.Omf51ArchiveFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Omf51ArchiveFileSystemFactory
implements GFileSystemFactoryByteProvider<Omf51ArchiveFileSystem>,
GFileSystemProbeByteProvider {
    public Omf51ArchiveFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        Omf51ArchiveFileSystem fs = new Omf51ArchiveFileSystem(targetFSRL, byteProvider);
        try {
            fs.mount(monitor);
        }
        catch (OmfException e) {
            throw new IOException(e);
        }
        return fs;
    }

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        if (byteProvider.length() < 11L) {
            return false;
        }
        try {
            Omf51RecordFactory factory = new Omf51RecordFactory(byteProvider);
            return factory.readNextRecord() instanceof Omf51LibraryHeaderRecord;
        }
        catch (OmfException | IOException e) {
            return false;
        }
    }
}

