/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AbstractStmt;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.RoutineStmt;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import java.util.Objects;

class ResultStmt
extends AbstractStmt {
    private final RValInternal result;

    protected ResultStmt(StructuredSleigh ctx, StructuredSleigh.RVal result) {
        super(ctx);
        this.result = (RValInternal)result;
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        RoutineStmt routine = Objects.requireNonNull(this.nearest(RoutineStmt.class));
        if (!this.ctx.isAssignable(routine.retType, this.result.getType())) {
            this.ctx.emitResultTypeMismatch(routine, this.result);
        }
        StringTree st = new StringTree();
        st.append("__op_output");
        st.append(" = ");
        st.append(this.result.generate(null));
        st.append(";\n");
        st.append(routine.lReturn.genGoto(fall));
        return st;
    }
}

