/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphAbstractGraphMousePlugin;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class VisualGraphZoomingPickingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends VisualGraphAbstractGraphMousePlugin<V, E> {
    public VisualGraphZoomingPickingGraphMousePlugin() {
        super(1024);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
        if (e.getClickCount() != 2) {
            return;
        }
        if (!this.checkForVertex(e)) {
            return;
        }
        this.isHandlingMouseEvents = true;
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        GraphViewer viewer = this.getGraphViewer(e);
        VisualGraphViewUpdater updater = viewer.getViewUpdater();
        Double currentScale = GraphViewerUtils.getGraphScale(viewer);
        if (currentScale.intValue() == 1) {
            updater.fitGraphToViewerNow(viewer);
        } else {
            updater.setGraphScale(1.0);
        }
        updater.moveVertexToCenterWithoutAnimation(this.selectedVertex);
        e.consume();
        this.resetState();
    }
}

