/*
 * Decompiled with CFR 0.152.
 */
package datagraph.graph.explore;

import datagraph.graph.explore.EgEdge;
import datagraph.graph.explore.EgGraphLayout;
import datagraph.graph.explore.EgVertex;
import ghidra.graph.graphs.DefaultVisualGraph;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public abstract class AbstractExplorationGraph<V extends EgVertex, E extends EgEdge<V>>
extends DefaultVisualGraph<V, E> {
    private V root;
    private EgGraphLayout<V, E> layout;

    public AbstractExplorationGraph(V root) {
        this.root = root;
        this.addVertex((VisualVertex)root);
    }

    public V getRoot() {
        return this.root;
    }

    public void setLayout(EgGraphLayout<V, E> layout) {
        this.layout = layout;
    }

    public VisualGraphLayout<V, E> getLayout() {
        return this.layout;
    }

    public Set<V> getDescendants(V source) {
        HashSet descendents = new HashSet();
        this.getDescendants(source, descendents);
        return descendents;
    }

    public void setRoot(V newRoot) {
        this.getVertices().forEach(v -> v.setSource(null));
        ((EgVertex)((Object)newRoot)).setSource((EgVertex)((Object)newRoot));
        LinkedList<V> vertexQueue = new LinkedList<V>();
        vertexQueue.add(newRoot);
        this.assignSource(vertexQueue);
        ((EgVertex)((Object)newRoot)).setSource(null);
        this.root = newRoot;
    }

    private void getDescendants(V source, Set<V> descendents) {
        for (EgEdge e : this.getOutEdges(source)) {
            EgVertex end = (EgVertex)e.getEnd();
            if (!source.equals((Object)end.source)) continue;
            descendents.add((V)((Object)end));
            this.getDescendants(end, descendents);
        }
        for (EgEdge e : this.getInEdges(source)) {
            EgVertex start = (EgVertex)e.getStart();
            if (!source.equals((Object)start.source)) continue;
            descendents.add((V)((Object)start));
            this.getDescendants(start, descendents);
        }
    }

    private void assignSource(Queue<V> vertexQueue) {
        while (!vertexQueue.isEmpty()) {
            EgVertex remove = (EgVertex)((Object)vertexQueue.remove());
            this.processEdges(remove, vertexQueue);
        }
    }

    private void processEdges(V v, Queue<V> vertexQueue) {
        Collection outEdges = this.getOutEdges(v);
        for (EgEdge edge : outEdges) {
            EgVertex next = (EgVertex)edge.getEnd();
            if (next.getSourceVertex() != null) continue;
            next.setSource((EgVertex)((Object)v));
            vertexQueue.add((V)((Object)next));
        }
        Collection inEdges = this.getInEdges(v);
        for (EgEdge e : inEdges) {
            EgVertex previous = (EgVertex)e.getStart();
            if (previous.getSourceVertex() != null) continue;
            previous.setSource((EgVertex)((Object)v));
            vertexQueue.add((V)((Object)previous));
        }
    }
}

