/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.quadtree;

import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.quadtree.ForceObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node<T> {
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    public static final double DEFAULT_THETA = 0.5;
    protected ForceObject<T> forceObject;
    Node NW;
    Node NE;
    Node SE;
    Node SW;
    protected double theta = 0.5;
    protected Rectangle area;
    static String marginIncrement = "   ";

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private Node(Builder<T> builder) {
        this(builder.area, builder.theta);
    }

    private Node(double x, double y, double width, double height, double theta) {
        this(new Rectangle(x, y, width, height), theta);
    }

    private Node(Rectangle r, double theta) {
        this.area = r;
        this.theta = theta;
    }

    public ForceObject<T> getForceObject() {
        return this.forceObject;
    }

    public boolean isLeaf() {
        return this.NW == null && this.NE == null && this.SE == null && this.SW == null;
    }

    public Node getNW() {
        return this.NW;
    }

    public Node getNE() {
        return this.NE;
    }

    public Node getSE() {
        return this.SE;
    }

    public Node getSW() {
        return this.SW;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void insert(ForceObject<T> element) {
        if (log.isTraceEnabled()) {
            log.trace("insert {} into {}", element, (Object)this);
        }
        if (!this.getBounds().contains(element.p.x, element.p.y)) {
            log.trace("{} outside of spatial bounds {}", (Object)element.p, (Object)this.getBounds());
            this.area = this.area.union(element.p.x, element.p.y);
        }
        if (this.forceObject == null) {
            this.forceObject = element;
            return;
        }
        if (this.isLeaf()) {
            if (this.forceObject.p.equals(element.p)) {
                this.forceObject = this.forceObject.add(element);
            } else {
                this.split();
                this.insertForceObject(this.forceObject);
                this.insertForceObject(element);
                this.forceObject = this.forceObject.add(element);
            }
        } else {
            if (this.forceObject == element) {
                log.error("can't insert {} into {}", element, this.forceObject);
            }
            this.forceObject = this.forceObject.add(element);
            this.insertForceObject(element);
        }
    }

    private void insertForceObject(ForceObject forceObject) {
        if (this.NW.area.contains(forceObject.p)) {
            this.NW.insert(forceObject);
        } else if (this.NE.area.contains(forceObject.p)) {
            this.NE.insert(forceObject);
        } else if (this.SE.area.contains(forceObject.p)) {
            this.SE.insert(forceObject);
        } else if (this.SW.area.contains(forceObject.p)) {
            this.SW.insert(forceObject);
        }
    }

    public Rectangle getBounds() {
        return this.area;
    }

    public void clear() {
        this.forceObject = null;
        this.SE = null;
        this.SW = null;
        this.NE = null;
        this.NW = null;
    }

    protected void split() {
        if (log.isTraceEnabled()) {
            log.trace("splitting {}", (Object)this);
        }
        double width = this.area.width / 2.0;
        double height = this.area.height / 2.0;
        double x = this.area.x;
        double y = this.area.y;
        this.NE = new Node<T>(x + width, y, width, height, this.theta);
        this.NW = new Node<T>(x, y, width, height, this.theta);
        this.SW = new Node<T>(x, y + height, width, height, this.theta);
        this.SE = new Node<T>(x + width, y + height, width, height, this.theta);
    }

    public void applyForcesTo(ForceObject<T> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Cannot apply forces to a null ForceObject");
        }
        if (this.forceObject == null || visitor.getElement().equals(this.forceObject.getElement())) {
            return;
        }
        if (this.isLeaf()) {
            visitor.addForceFrom(this.forceObject);
        } else {
            double s = this.area.width;
            double d = this.forceObject.p.distance(visitor.p);
            if (s / d < this.theta) {
                visitor.addForceFrom(this.forceObject);
            } else {
                this.NW.applyForcesTo(visitor);
                this.NE.applyForcesTo(visitor);
                this.SW.applyForcesTo(visitor);
                this.SE.applyForcesTo(visitor);
            }
        }
    }

    static String asString(Rectangle r) {
        return "[" + (int)r.x + "," + (int)r.y + "," + (int)r.width + "," + (int)r.height + "]";
    }

    static <T> String asString(String label, Node<T> node, String margin) {
        StringBuilder s = new StringBuilder();
        s.append("\n");
        s.append(margin);
        s.append(label);
        s.append("bounds=");
        s.append(Node.asString(node.getBounds()));
        ForceObject<T> forceObject = node.getForceObject();
        if (forceObject != null) {
            s.append(", forceObject:=");
            s.append(forceObject.toString());
        }
        if (node.NW != null) {
            s.append(Node.asString("NW:", node.NW, margin + marginIncrement));
        }
        if (node.NE != null) {
            s.append(Node.asString("NE:", node.NE, margin + marginIncrement));
        }
        if (node.SW != null) {
            s.append(Node.asString("SW:", node.SW, margin + marginIncrement));
        }
        if (node.SE != null) {
            s.append(Node.asString("SE:", node.SE, margin + marginIncrement));
        }
        return s.toString();
    }

    public String toString() {
        return Node.asString("", this, "");
    }

    public static class Builder<T> {
        protected double theta = 0.5;
        protected Rectangle area;

        public Builder<T> withArea(double x, double y, double width, double height) {
            return this.withArea(new Rectangle(x, y, width, height));
        }

        public Builder<T> withArea(Rectangle area) {
            this.area = area;
            return this;
        }

        public Builder<T> withTheta(double theta) {
            this.theta = theta;
            return this;
        }

        public Node<T> build() {
            return new Node(this);
        }
    }
}

