/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ComponentProvider;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.compositeeditor.ComponentContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;

public class ComponentProgramActionContext
extends ProgramActionContext
implements ComponentContext {
    private DataTypeComponent component;
    private Composite composite;

    public ComponentProgramActionContext(CompositeEditorProvider<?, ?> compositeEditorProvider, Program program, DataTypeComponent component) {
        super((ComponentProvider)compositeEditorProvider, program);
        this.component = component;
        DataType parent = component.getParent();
        if (!(parent instanceof Composite)) {
            throw new IllegalArgumentException("Only Composite components allowed");
        }
        this.composite = (Composite)parent;
        if (parent.getDataTypeManager() == null) {
            throw new IllegalArgumentException("Component's parent must have a DataTypeManager");
        }
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.program.getDataTypeManager();
    }

    @Override
    public Composite getCompositeDataType() {
        return this.composite;
    }

    @Override
    public DataTypeComponent getDataTypeComponent() {
        return this.component;
    }
}

