/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.macro.entry;

import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFStringAttribute;
import ghidra.app.util.bin.format.dwarf.macro.DWARFMacroHeader;
import ghidra.app.util.bin.format.dwarf.macro.DWARFMacroOpcode;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroInfoEntry;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DWARFMacroDefine
extends DWARFMacroInfoEntry {
    private static final Pattern PARSEMACROREGEX = Pattern.compile("([^( ]+)|([^( ]+) (.+)|([^( ]+)\\(([^)]+)\\) (.*)");

    public static MacroInfo parseMacro(String macroString) {
        Matcher m = PARSEMACROREGEX.matcher(macroString);
        if (!m.matches() || m.group(1) != null) {
            return new MacroInfo(macroString, macroString, List.of(), false, "");
        }
        if (m.group(2) != null) {
            return new MacroInfo(macroString, m.group(2), List.of(), false, m.group(3));
        }
        if (m.group(5) != null) {
            return new MacroInfo(macroString, m.group(4), Arrays.asList(m.group(5).split(",")), true, m.group(6));
        }
        throw new AssertException();
    }

    public DWARFMacroDefine(int lineNumber, String defineString, DWARFMacroHeader parent) {
        super(DWARFMacroOpcode.DW_MACRO_define, parent);
        this.operandValues[0] = new DWARFNumericAttribute(lineNumber, this.operandDef(0));
        this.operandValues[1] = new DWARFStringAttribute(defineString, this.operandDef(1));
    }

    public DWARFMacroDefine(DWARFMacroInfoEntry other) {
        super(other);
    }

    public int getLineNumber() throws IOException {
        return this.getOperand(0, DWARFNumericAttribute.class).getUnsignedIntExact();
    }

    public String getMacro() throws IOException {
        return this.getOperand(1, DWARFStringAttribute.class).getValue(this.macroHeader.getCompilationUnit());
    }

    public MacroInfo getMacroInfo() throws IOException {
        return DWARFMacroDefine.parseMacro(this.getMacro());
    }

    @Override
    public String toString() {
        try {
            return "%s: line: %d, %s".formatted(this.getName(), this.getLineNumber(), this.getMacroInfo());
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public record MacroInfo(String macro, String symbolName, List<String> parameters, boolean isFunctionLike, String definition) {
        @Override
        public String toString() {
            if (this.macro.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder("Macro Symbol: ");
            sb.append(this.symbolName);
            sb.append(" ");
            if (this.isFunctionLike) {
                sb.append("(function-like) ");
                sb.append("parameters[%d]: ".formatted(this.parameters.size()));
                for (int i = 0; i < this.parameters.size(); ++i) {
                    sb.append(this.parameters.get(i));
                    if (i == this.parameters.size() - 1) continue;
                    sb.append(",");
                }
                sb.append(" ");
            } else {
                sb.append("(object-like) ");
            }
            sb.append("definition: ");
            sb.append(this.definition.isEmpty() ? "-none-" : "\"%s\"".formatted(this.definition));
            return sb.toString();
        }
    }
}

