/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.TwoLevelHint;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TwoLevelHintsCommand
extends LoadCommand {
    private long offset;
    private long nhints;
    private List<TwoLevelHint> hints = new ArrayList<TwoLevelHint>();

    TwoLevelHintsCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.offset = reader.readNextUnsignedInt();
        this.nhints = this.checkCount(reader.readNextUnsignedInt());
        long index = reader.getPointerIndex();
        reader.setPointerIndex(this.offset);
        for (long i = 0L; i < this.nhints; ++i) {
            this.hints.add(new TwoLevelHint(reader));
        }
        reader.setPointerIndex(index);
    }

    public List<TwoLevelHint> getHints() {
        return this.hints;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getNumberOfHints() {
        return this.nhints;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "offset", null);
        struct.add(DWORD, "nhints", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "twolevel_hints_command";
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            Address hintStartAddress;
            ProgramFragment fragment = this.createFragment(api, baseAddress, parentModule);
            Address addr = baseAddress.getNewAddress(this.getStartIndex());
            api.createData(addr, this.toDataType());
            Address hintAddress = hintStartAddress = baseAddress.add(this.getOffset());
            for (TwoLevelHint hint : this.hints) {
                if (monitor.isCancelled()) {
                    return;
                }
                DataType hintDT = hint.toDataType();
                api.createData(hintAddress, hintDT);
                api.setPlateComment(hintAddress, "Sub-image Index: 0x" + Integer.toHexString(hint.getSubImageIndex()) + "\n      TOC Index: 0x" + Integer.toHexString(hint.getTableOfContentsIndex()));
                hintAddress = hintAddress.add((long)hintDT.getLength());
            }
            fragment.move(hintStartAddress, hintAddress.subtract(1L));
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }
}

