/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class DebugCOFFLineNumber {
    public static final int IMAGE_SIZEOF_LINENUMBER = 6;
    private int symbolTableIndex;
    private int virtualAddress;
    private int lineNumber;

    public DebugCOFFLineNumber(BinaryReader reader, int index) throws IOException {
        this.symbolTableIndex = reader.readInt(index);
        this.virtualAddress = reader.readInt(index);
        this.lineNumber = Short.toUnsignedInt(reader.readShort(index += 4));
    }

    public int getSymbolTableIndex() {
        return this.symbolTableIndex;
    }

    public int getVirtualAddress() {
        return this.virtualAddress;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

