/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.AttributeId;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlMessageLog;
import ghidra.xml.XmlPullParser;
import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;

public class DecompileDebugDataTypeManager {
    TaskMonitor monitor;
    Program prog;
    Map<DataTypeKey, DataType> dataTypeMap;
    DataTypeManager programDataManager;
    BuiltInDataTypeManager builtInMngr = BuiltInDataTypeManager.getDataTypeManager();
    private String idHolder;
    public static DataTypeConflictHandler dtConflictHandler = new DataTypeConflictHandler(){

        public DataTypeConflictHandler.ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
        }

        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return true;
        }

        public DataTypeConflictHandler getSubsequentHandler() {
            return DEFAULT_HANDLER;
        }
    };

    public DecompileDebugDataTypeManager(TaskMonitor monitor, Program prog) {
        this.monitor = monitor;
        this.prog = prog;
        this.dataTypeMap = new TreeMap<DataTypeKey, DataType>();
        this.programDataManager = this.prog.getListing().getDataTypeManager();
    }

    public DataType parseDataTypeTag(XmlPullParser parser, XmlMessageLog log) {
        String tagName = parser.peek().getName();
        DataType retrieved = null;
        switch (tagName) {
            case "type": {
                retrieved = this.parseType(parser, log);
                break;
            }
            case "typeref": {
                retrieved = this.parseRefType(parser, log);
                break;
            }
            case "def": {
                retrieved = this.parseDef(parser, log);
                break;
            }
            case "void": {
                XmlElement voidElement = parser.start(new String[]{"void"});
                parser.end(voidElement);
                return new VoidDataType();
            }
            default: {
                log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + tagName);
                parser.discardSubTree();
            }
        }
        return retrieved;
    }

    private DataType parseType(XmlPullParser parser, XmlMessageLog log) {
        DataType retrieved = null;
        String metatype = parser.peek().getAttribute("metatype");
        if (metatype == null) {
            retrieved = this.retreiveBaseType(parser, log);
            return retrieved;
        }
        switch (metatype) {
            case "ptr": {
                retrieved = this.parsePointer(parser, log);
                break;
            }
            case "ptrrel": {
                retrieved = this.parsePointerRelative(parser, log);
                break;
            }
            case "array": {
                retrieved = this.parseArray(parser, log);
                break;
            }
            case "struct": {
                retrieved = this.parseStruct(parser, log);
                break;
            }
            case "union": {
                retrieved = this.parseUnion(parser, log);
                break;
            }
            case "enum_int": 
            case "enum_uint": {
                retrieved = this.parseEnum(parser, log);
                break;
            }
            default: {
                retrieved = this.retreiveBaseType(parser, log);
            }
        }
        return retrieved;
    }

    private DataType parseDef(XmlPullParser parser, XmlMessageLog log) {
        XmlElement defElement = parser.start(new String[]{"def"});
        DataTypeKey key = new DataTypeKey(defElement);
        if (!this.dataTypeMap.containsKey(key)) {
            DataType typeDefedType = this.parseDataTypeTag(parser, log);
            TypedefDataType generatedTypeDef = new TypedefDataType(new CategoryPath(String.valueOf(CategoryPath.ROOT) + key.name()), key.name(), typeDefedType, this.programDataManager);
            DataType resolvedDT = this.resolveAndMapDataType(key, (DataType)generatedTypeDef);
            parser.end(defElement);
            return resolvedDT;
        }
        return this.dataTypeMap.get(key);
    }

    private DataType parseEnum(XmlPullParser parser, XmlMessageLog log) {
        XmlElement enumElement = parser.start(new String[]{"type"});
        DataTypeKey key = new DataTypeKey(enumElement);
        int length = SpecXmlUtils.decodeInt((String)enumElement.getAttribute(AttributeId.ATTRIB_SIZE.name()));
        Enum enumDT = null;
        if (!this.dataTypeMap.containsKey(key)) {
            enumDT = new EnumDataType(new CategoryPath(String.valueOf(CategoryPath.ROOT) + key.name()), key.name(), length, this.programDataManager);
            enumDT = (Enum)this.resolveAndMapDataType(key, (DataType)enumDT);
        } else {
            enumDT = (Enum)this.dataTypeMap.get(key);
        }
        while (parser.peek().getName().equals(AttributeId.ATTRIB_VAL.name())) {
            XmlElement valElement = parser.start(new String[]{AttributeId.ATTRIB_VAL.name()});
            enumDT.add(valElement.getAttribute(AttributeId.ATTRIB_NAME.name()), (long)SpecXmlUtils.decodeInt((String)valElement.getAttribute(AttributeId.ATTRIB_VALUE.name())), "");
            parser.end(valElement);
        }
        parser.end(enumElement);
        return enumDT;
    }

    private DataType parseUnion(XmlPullParser parser, XmlMessageLog log) {
        XmlElement unionElement = parser.start(new String[]{"type"});
        DataTypeKey key = new DataTypeKey(unionElement);
        int size = SpecXmlUtils.decodeInt((String)unionElement.getAttribute(AttributeId.ATTRIB_SIZE.name()));
        Union unionDT = null;
        if (!this.dataTypeMap.containsKey(key)) {
            unionDT = new UnionDataType(new CategoryPath(String.valueOf(CategoryPath.ROOT) + key.name()), key.name(), this.programDataManager);
            unionDT = (Union)this.resolveAndMapDataType(key, (DataType)unionDT);
        } else {
            unionDT = (Union)this.dataTypeMap.get(key);
        }
        if (unionElement.hasAttribute(AttributeId.ATTRIB_INCOMPLETE.name()) || size == 0) {
            parser.end(unionElement);
            return unionDT;
        }
        while (parser.peek().getName().equals("field")) {
            XmlElement fieldElement = parser.start(new String[]{"field"});
            DataType fieldDT = this.parseDataTypeTag(parser, log);
            unionDT.add(fieldDT, fieldDT.getLength(), key.name(), "");
            parser.end(fieldElement);
        }
        parser.end(unionElement);
        return unionDT;
    }

    private DataType parseArray(XmlPullParser parser, XmlMessageLog log) {
        XmlElement arrayElement = parser.start(new String[]{"type"});
        int arraySize = SpecXmlUtils.decodeInt((String)arrayElement.getAttribute(AttributeId.ATTRIB_ARRAYSIZE.name()));
        DataType baseType = this.parseDataTypeTag(parser, log);
        ArrayDataType arrayDT = new ArrayDataType(baseType, arraySize, baseType.getLength(), this.programDataManager);
        DataType resolved = this.resolveAndMapDataType(new DataTypeKey(baseType.getName() + "array", this.idHolder), (DataType)arrayDT);
        parser.end(arrayElement);
        return resolved;
    }

    private DataType parsePointer(XmlPullParser parser, XmlMessageLog log) {
        XmlElement pointerElement = parser.start(new String[]{"type"});
        int size = SpecXmlUtils.decodeInt((String)pointerElement.getAttribute(AttributeId.ATTRIB_SIZE.name()));
        DataType baseType = this.parseDataTypeTag(parser, log);
        PointerDataType pointerDT = new PointerDataType(baseType, size, this.programDataManager);
        DataType resolved = this.resolveAndMapDataType(new DataTypeKey(baseType.getName() + "ptr", this.idHolder), (DataType)pointerDT);
        parser.end(pointerElement);
        return resolved;
    }

    private DataType parsePointerRelative(XmlPullParser parser, XmlMessageLog log) {
        XmlElement pointerRelElement = parser.start(new String[]{"type"});
        int size = SpecXmlUtils.decodeInt((String)pointerRelElement.getAttribute(AttributeId.ATTRIB_SIZE.name()));
        Long offset = SpecXmlUtils.decodeLong((String)pointerRelElement.getAttribute(AttributeId.ATTRIB_OFF.name()));
        DataType baseType = this.parseDataTypeTag(parser, log);
        PointerTypedef relPointerDT = new PointerTypedef(baseType.getName(), baseType, size, this.programDataManager, offset.longValue());
        DataType resolved = this.resolveAndMapDataType(new DataTypeKey(baseType.getName() + "relptr", this.idHolder), (DataType)relPointerDT);
        parser.end(pointerRelElement);
        return resolved;
    }

    private DataType parseStruct(XmlPullParser parser, XmlMessageLog log) {
        XmlElement structElement = parser.start(new String[]{"type"});
        DataTypeKey key = new DataTypeKey(structElement);
        int size = SpecXmlUtils.decodeInt((String)structElement.getAttribute(AttributeId.ATTRIB_SIZE.name()));
        Structure createdStruct = null;
        if (!this.dataTypeMap.containsKey(key)) {
            StructureDataType newStruct = new StructureDataType(key.name(), size, this.programDataManager);
            createdStruct = (Structure)this.resolveAndMapDataType(key, (DataType)newStruct);
        } else {
            createdStruct = (Structure)this.dataTypeMap.get(key);
        }
        if (structElement.hasAttribute(AttributeId.ATTRIB_INCOMPLETE.name()) || size == 0) {
            parser.end(structElement);
            return createdStruct;
        }
        while (parser.peek().getName().equals("field")) {
            XmlElement fieldElement = parser.start(new String[]{"field"});
            int fieldOffset = SpecXmlUtils.decodeInt((String)fieldElement.getAttribute(AttributeId.ATTRIB_OFFSET.name()));
            DataType fieldDT = this.parseDataTypeTag(parser, log);
            createdStruct.replaceAtOffset(fieldOffset, fieldDT, fieldDT.getLength(), fieldElement.getAttribute(AttributeId.ATTRIB_NAME.name()), "");
            parser.end(fieldElement);
        }
        parser.end(structElement);
        return createdStruct;
    }

    private DataType parseRefType(XmlPullParser parser, XmlMessageLog log) {
        XmlElement typeRefElement = parser.start(new String[]{"typeref"});
        DataTypeKey key = new DataTypeKey(typeRefElement);
        DataType dt = this.dataTypeMap.get(key);
        if (dt == null) {
            log.appendMsg("Data Type referenced without first being created.");
        }
        parser.end(typeRefElement);
        return dt;
    }

    private DataType retreiveBaseType(XmlPullParser parser, XmlMessageLog log) {
        XmlElement typeElement = parser.start(new String[]{"type"});
        DataType retrieved = null;
        DataTypeKey key = new DataTypeKey(typeElement);
        this.idHolder = key.id();
        if (this.dataTypeMap.containsKey(key)) {
            retrieved = this.dataTypeMap.get(key);
        } else {
            retrieved = this.builtInMngr.getDataType(CategoryPath.ROOT, key.name().toLowerCase());
            if (retrieved != null) {
                retrieved = this.resolveAndMapDataType(key, retrieved);
            } else {
                log.appendMsg("Type tag " + key.name() + " didn't resolve");
            }
        }
        parser.end(typeElement);
        return retrieved;
    }

    private DataType resolveAndMapDataType(DataTypeKey key, DataType generatedTypeDef) {
        DataType resolvedDT = this.programDataManager.resolve(generatedTypeDef, dtConflictHandler);
        this.dataTypeMap.put(key, resolvedDT);
        return resolvedDT;
    }

    record DataTypeKey(String name, String id, BigInteger val) implements Comparable<DataTypeKey>
    {
        public DataTypeKey(XmlElement typeRefElement) {
            this(typeRefElement.getAttribute(AttributeId.ATTRIB_NAME.name()), typeRefElement.getAttribute(AttributeId.ATTRIB_ID.name()));
        }

        public DataTypeKey(String name, String id) {
            this(name, id, id.startsWith("0x") ? new BigInteger(id.substring(2), 16) : new BigInteger(id, 10));
        }

        @Override
        public int compareTo(DataTypeKey other) {
            int nameCompare = this.name.compareTo(other.name);
            if (nameCompare != 0) {
                return nameCompare;
            }
            return (int)(this.val.longValue() - other.val.longValue());
        }
    }
}

