/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.PseudoDisassembler;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.OpBehaviorFactory;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ProgramContextImpl;
import ghidra.program.util.VarnodeContext;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections4.map.LRUMap;

public class SymbolicPropogator {
    private static final int _POINTER_MIN_BOUNDS = 256;
    private static long[] maskSize = new long[]{255L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    protected List<AddressSpace> memorySpaces;
    private boolean defaultSpacesAreTheSame = false;
    protected ContextEvaluator evaluator = null;
    protected Program program;
    protected ProgramContext programContext;
    protected ProgramContext spaceContext;
    protected ProgramContext savedProgramContext;
    protected ProgramContext savedSpaceContext;
    protected boolean canceled = false;
    protected boolean readExecutableAddress;
    protected VarnodeContext context;
    protected AddressSet visitedBody;
    protected boolean hitCodeFlow = false;
    private boolean debug = false;
    private boolean recordStartEndState = false;
    private long pointerMask;
    private int pointerSize;
    private DataType pointerSizedDT = null;
    protected static final int MAX_EXACT_INSTRUCTIONS = 100;
    private static final int NOT_CONTINUING_CURRRENTLY = -1;
    private static final int MAX_EXTRA_INSTRUCTION_FLOW = 16;
    private static int LRU_SIZE = 4096;
    Map<Address, Address[]> instructionFlowsCache = new LRUMap(LRU_SIZE);
    Map<Address, PcodeOp[]> pcodeCache = new LRUMap(LRU_SIZE);
    Map<Address, Instruction> instructionAtCache = new LRUMap(LRU_SIZE);
    Map<Address, Instruction> instructionContainingCache = new LRUMap(LRU_SIZE);
    Map<Address, Function> functionAtCache = new LRUMap(LRU_SIZE);
    HashMap<Long, InjectPayload> injectPayloadCache = new HashMap();
    protected int lastFullHashCode = 0;
    protected int lastInstrCode = -1;
    protected int sameInstrCount = 0;
    private boolean checkForParamRefs = true;
    private boolean checkForParamPointerRefs = true;
    private boolean checkForReturnRefs = true;
    private boolean checkForStoredRefs = true;

    public SymbolicPropogator(Program program) {
        this(program, true);
    }

    public SymbolicPropogator(Program program, boolean recordStartEndState) {
        this.program = program;
        this.recordStartEndState = recordStartEndState;
        Language language = program.getLanguage();
        this.programContext = new ProgramContextImpl(language);
        this.spaceContext = new ProgramContextImpl(language);
        this.setPointerMask(program);
        this.context = new VarnodeContext(program, this.programContext, this.spaceContext, recordStartEndState);
        this.context.setDebug(this.debug);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.context.setDebug(debug);
    }

    private void setPointerMask(Program program) {
        int ptrSize = program.getDefaultPointerSize();
        if (ptrSize > 8) {
            ptrSize = 8;
        }
        this.pointerSize = ptrSize;
        this.pointerMask = maskSize[ptrSize];
        this.pointerSizedDT = IntegerDataType.getUnsignedDataType((int)this.pointerSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSet flowConstants(Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, boolean saveContext, TaskMonitor monitor) throws CancelledException {
        Register[] regWithVals;
        this.evaluator = eval;
        this.initValidAddressSpaces();
        this.savedProgramContext = this.programContext;
        this.savedSpaceContext = this.spaceContext;
        if (!saveContext) {
            this.context = this.saveOffCurrentContext(startAddr);
        }
        this.context.flowToAddress(Address.NO_ADDRESS, startAddr);
        for (Register regWithVal : regWithVals = this.program.getProgramContext().getRegistersWithValues()) {
            RegisterValue regVal = this.program.getProgramContext().getRegisterValue(regWithVal, startAddr);
            if (regVal == null || !regVal.hasValue()) continue;
            Register reg = regVal.getRegister();
            this.context.putValue(this.context.getRegisterVarnode(reg), this.context.createConstantVarnode(regVal.getUnsignedValue().longValue(), reg.getMinimumByteSize()), false);
        }
        this.context.propogateResults(false);
        AddressSet bodyDone = null;
        try {
            bodyDone = this.flowConstants(startAddr, restrictSet, eval, this.context, monitor);
        }
        finally {
            this.programContext = this.savedProgramContext;
            this.spaceContext = this.savedSpaceContext;
        }
        this.readExecutableAddress = this.context.readExecutableCode();
        return bodyDone;
    }

    private void initValidAddressSpaces() {
        AddressSpace defaultDataSpace = this.program.getLanguage().getDefaultDataSpace();
        AddressSpace defaultSpace = this.program.getLanguage().getDefaultSpace();
        this.defaultSpacesAreTheSame = defaultSpace.equals((Object)defaultDataSpace);
        AddressSpace defaultAddrSpace = this.program.getAddressFactory().getDefaultAddressSpace();
        this.memorySpaces = new ArrayList<AddressSpace>();
        for (AddressSpace space : this.program.getAddressFactory().getAddressSpaces()) {
            OverlayAddressSpace ovSpace;
            AddressSpace baseSpace;
            if (!space.isLoadedMemorySpace() || (!space.isOverlaySpace() ? !space.equals((Object)defaultDataSpace) && !space.equals((Object)defaultSpace) : !(baseSpace = (ovSpace = (OverlayAddressSpace)space).getPhysicalSpace()).equals((Object)defaultDataSpace) && !baseSpace.equals((Object)defaultSpace))) continue;
            if (space.equals((Object)defaultAddrSpace)) {
                this.memorySpaces.add(0, space);
                continue;
            }
            this.memorySpaces.add(space);
        }
    }

    protected VarnodeContext saveOffCurrentContext(Address startAddr) {
        Language language = this.program.getLanguage();
        ProgramContextImpl newValueContext = new ProgramContextImpl(language);
        ProgramContextImpl newSpaceContext = new ProgramContextImpl(language);
        VarnodeContext newContext = new VarnodeContext(this.program, (ProgramContext)newValueContext, (ProgramContext)newSpaceContext, this.recordStartEndState);
        newContext.setDebug(this.debug);
        this.programContext = newValueContext;
        this.spaceContext = newSpaceContext;
        return newContext;
    }

    public Value getRegisterValue(Address toAddr, Register reg) {
        Varnode val = this.context.getRegisterVarnodeValue(reg, Address.NO_ADDRESS, toAddr, true);
        if (val == null) {
            return null;
        }
        if (this.context.isConstant(val)) {
            return new Value(this, val.getOffset());
        }
        AddressSpace space = val.getAddress().getAddressSpace();
        if (space.getName().startsWith("track_")) {
            return new Value(this, val.getOffset());
        }
        Register relativeReg = this.program.getRegister(space.getName());
        if (relativeReg != null) {
            return new Value(this, relativeReg, val.getOffset());
        }
        return null;
    }

    public Value getEndRegisterValue(Address toAddr, Register reg) {
        Varnode val = this.context.getEndRegisterVarnodeValue(reg, Address.NO_ADDRESS, toAddr, true);
        if (val == null) {
            return null;
        }
        if (this.context.isConstant(val)) {
            return new Value(this, val.getOffset());
        }
        AddressSpace space = val.getAddress().getAddressSpace();
        if (space.getName().startsWith("track_")) {
            return new Value(this, val.getOffset());
        }
        Register relativeReg = this.program.getRegister(space.getName());
        if (relativeReg != null) {
            return new Value(this, relativeReg, val.getOffset());
        }
        return null;
    }

    public String getRegisterValueRepresentation(Address addr, Register reg) {
        Varnode val = this.context.getRegisterVarnodeValue(reg, Address.NO_ADDRESS, addr, true);
        if (val == null) {
            return "-";
        }
        if (val.isConstant()) {
            return this.context.getRegisterValue(reg, Address.NO_ADDRESS, addr).toString();
        }
        AddressSpace space = val.getAddress().getAddressSpace();
        if (space.getName().startsWith("track_")) {
            return String.valueOf(reg) + "+" + BigInteger.valueOf(val.getOffset()).toString(16);
        }
        if (this.context.isSymbol(val)) {
            return val.getAddress().getAddressSpace().getName() + " + " + val.getOffset();
        }
        return "-";
    }

    public void setRegister(Address addr, Register stackReg) {
        this.context.flowToAddress(Address.NO_ADDRESS, addr);
        int spaceID = this.context.getAddressSpace(stackReg.getName(), stackReg.getBitLength());
        Varnode vnode = this.context.createVarnode(0L, spaceID, stackReg.getBitLength() / 8);
        this.context.putValue(this.context.getRegisterVarnode(stackReg), vnode, false);
        this.context.propogateResults(false);
        this.context.flowEnd(addr);
    }

    public AddressSet flowConstants(Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, VarnodeContext vContext, TaskMonitor monitor) throws CancelledException {
        return this.flowConstants(Address.NO_ADDRESS, startAddr, restrictSet, eval, vContext, monitor);
    }

    public AddressSet flowConstants(Address fromAddr, Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, VarnodeContext vContext, TaskMonitor monitor) throws CancelledException {
        this.visitedBody = new AddressSet();
        AddressSet conflicts = new AddressSet();
        Stack<SavedFlowState> contextStack = new Stack<SavedFlowState>();
        contextStack.push(new SavedFlowState(vContext, null, fromAddr, startAddr, -1));
        this.canceled = false;
        boolean callCouldCauseBadStackDepth = this.program.getCompilerSpec().getDefaultCallingConvention().getExtrapop() == 32768;
        HashMap visitedMap = new HashMap();
        block0: while (!contextStack.isEmpty()) {
            HashSet<Address> visitSet;
            monitor.checkCancelled();
            if (this.canceled) {
                this.visitedBody.add((AddressSetView)conflicts);
                return this.visitedBody;
            }
            SavedFlowState nextFlow = (SavedFlowState)contextStack.pop();
            boolean justPopped = true;
            Address nextAddr = nextFlow.destination;
            Address flowFromAddr = nextFlow.source;
            FlowType flowType = nextFlow.flowType;
            int pcodeStartIndex = nextFlow.pcodeIndex;
            int continueAfterHittingFlow = nextFlow.continueAfterHittingFlow;
            nextFlow.restoreState();
            if (flowType != null) {
                Function func;
                if (flowType.isCall()) {
                    AddressSet savedBody = this.visitedBody;
                    Function func2 = this.getFunctionAt(nextAddr);
                    this.flowConstants(nextFlow.source, nextAddr, func2.getBody(), eval, vContext, monitor);
                    this.visitedBody = savedBody;
                    continue;
                }
                if (flowType.isJump() && !flowType.isConditional() && (func = this.getFunctionAt(nextAddr)) != null && !func.getBody().contains(startAddr)) {
                    vContext.flowStart(nextAddr);
                    this.handleFunctionSideEffects(this.getInstructionAt(flowFromAddr), nextAddr, monitor);
                    continue;
                }
            }
            if ((visitSet = (HashSet<Address>)visitedMap.get(nextAddr)) != null) {
                if (visitSet.contains(flowFromAddr)) continue;
                if (continueAfterHittingFlow == -1) {
                    continueAfterHittingFlow = 0;
                }
            } else {
                visitSet = new HashSet<Address>();
                visitedMap.put(nextAddr, visitSet);
                if (continueAfterHittingFlow == -1 && this.visitedBody.contains(nextAddr)) {
                    continueAfterHittingFlow = 0;
                }
            }
            visitSet.add(flowFromAddr);
            vContext.flowToAddress(fromAddr, nextAddr);
            this.lastFullHashCode = 0;
            this.lastInstrCode = -1;
            this.sameInstrCount = 0;
            Address maxAddr = null;
            while (nextAddr != null) {
                Instruction instr;
                monitor.checkCancelled();
                vContext.flowStart(nextAddr);
                if (!this.visitedBody.contains(nextAddr)) {
                    continueAfterHittingFlow = -1;
                }
                if (restrictSet != null && !restrictSet.contains(nextAddr) || (instr = this.getInstructionAt(nextAddr)) == null) continue block0;
                FlowType originalFlowType = instr.getFlowType();
                if (this.checkSameInstructionRun(instr)) continue block0;
                Address minInstrAddress = instr.getMinAddress();
                maxAddr = instr.getMaxAddress();
                if (instr.getPrototype().hasDelaySlots()) {
                    maxAddr = minInstrAddress.add((long)(instr.getDefaultFallThroughOffset() - 1));
                }
                vContext.setCurrentInstruction(instr);
                if (this.evaluator != null && this.evaluator.evaluateContextBefore(vContext, instr)) {
                    this.visitedBody.add((AddressSetView)conflicts);
                    return this.visitedBody;
                }
                boolean continueCurrentTrace = this.applyPcode(contextStack, vContext, instr, pcodeStartIndex, continueAfterHittingFlow, monitor);
                pcodeStartIndex = 0;
                if (this.evaluator != null && this.evaluator.evaluateContext(vContext, instr)) {
                    this.visitedBody.add((AddressSetView)conflicts);
                    return this.visitedBody;
                }
                FlowType instrFlow = instr.getFlowType();
                if (!originalFlowType.equals((Object)instrFlow) && instrFlow.isCall()) {
                    Address[] targets;
                    for (Address target : targets = this.getInstructionFlows(instr)) {
                        this.handleFunctionSideEffects(instr, target, monitor);
                    }
                }
                if (this.visitedBody.contains(minInstrAddress) && !justPopped) {
                    continueAfterHittingFlow = continueAfterHittingFlow > -1 ? ++continueAfterHittingFlow : 0;
                    if (continueAfterHittingFlow >= 16 || instrFlow.isCall()) continue block0;
                }
                this.visitedBody.addRange(minInstrAddress, maxAddr);
                justPopped = false;
                vContext.flowEnd(minInstrAddress);
                boolean simpleFlow = this.isSimpleFallThrough(instrFlow);
                this.hitCodeFlow |= !simpleFlow;
                Address fallThru = instr.getFallThrough();
                nextAddr = null;
                if (!continueCurrentTrace) continue;
                nextAddr = fallThru;
            }
        }
        this.visitedBody.add((AddressSetView)conflicts);
        return this.visitedBody;
    }

    private boolean isSimpleFallThrough(FlowType instrFlow) {
        return !instrFlow.isCall() && !instrFlow.isJump() && !instrFlow.isTerminal() && instrFlow.hasFallthrough();
    }

    private boolean checkSameInstructionRun(Instruction instr) {
        if (this.lastInstrCode == instr.getPrototype().hashCode()) {
            if (this.lastFullHashCode == 0) {
                this.lastFullHashCode = -1;
            } else {
                int instrByteHashCode = -1;
                try {
                    byte[] bytes = instr.getParsedBytes();
                    instrByteHashCode = Arrays.hashCode(bytes);
                }
                catch (MemoryAccessException e) {
                    instrByteHashCode = instr.toString().hashCode();
                }
                if (this.lastFullHashCode == -1) {
                    this.lastFullHashCode = instrByteHashCode;
                }
                if (this.lastFullHashCode == instrByteHashCode) {
                    ++this.sameInstrCount;
                    if (this.sameInstrCount > 100) {
                        return true;
                    }
                } else {
                    this.lastFullHashCode = 0;
                    this.sameInstrCount = 0;
                }
            }
        } else {
            this.sameInstrCount = 0;
            this.lastFullHashCode = 0;
        }
        this.lastInstrCode = instr.getPrototype().hashCode();
        return false;
    }

    public PcodeOp[] getInstructionPcode(Instruction instruction) {
        PcodeOp[] ops = this.pcodeCache.get(instruction.getMinAddress());
        if (ops == null) {
            ops = instruction.getPcode(true);
            this.pcodeCache.put(instruction.getMinAddress(), ops);
        }
        return ops;
    }

    public Instruction getInstructionAt(Address addr) {
        Instruction instr = this.instructionAtCache.get(addr);
        if (instr != null) {
            return instr;
        }
        if (this.instructionAtCache.containsKey(addr)) {
            return null;
        }
        instr = this.program.getListing().getInstructionAt(addr);
        this.cacheInstruction(addr, instr);
        return instr;
    }

    public Function getFunctionAt(Address addr) {
        Function func = this.functionAtCache.get(addr);
        if (func != null) {
            return func;
        }
        if (this.functionAtCache.containsKey(addr)) {
            return null;
        }
        func = this.program.getFunctionManager().getFunctionAt(addr);
        this.functionAtCache.put(addr, func);
        return func;
    }

    private void cacheInstruction(Address addr, Instruction instr) {
        this.instructionAtCache.put(addr, instr);
        if (instr != null) {
            this.instructionContainingCache.put(instr.getMaxAddress(), instr);
            this.getInstructionPcode(instr);
        }
    }

    public Instruction getInstructionContaining(Address addr) {
        Instruction instr = this.getInstructionAt(addr);
        if (instr != null) {
            return instr;
        }
        instr = this.instructionContainingCache.get(addr);
        if (instr != null) {
            return instr;
        }
        if (this.instructionContainingCache.containsKey(addr)) {
            return null;
        }
        instr = this.program.getListing().getInstructionContaining(addr);
        this.instructionContainingCache.put(addr, instr);
        return instr;
    }

    private Address[] getInstructionFlows(Instruction instruction) {
        Address addr = instruction.getMinAddress();
        Address[] flows = this.instructionFlowsCache.get(addr);
        if (flows != null) {
            return flows;
        }
        flows = instruction.getFlows();
        this.instructionFlowsCache.put(addr, flows);
        return flows;
    }

    private boolean applyPcode(Stack<SavedFlowState> contextStack, VarnodeContext vContext, Instruction instruction, int startIndex, int continueAfterHittingFlow, TaskMonitor monitor) {
        Address nextAddr = null;
        if (instruction == null) {
            return false;
        }
        PcodeOp[] ops = this.getInstructionPcode(instruction);
        if (ops.length <= 0) {
            return true;
        }
        Address minInstrAddress = instruction.getMinAddress();
        if (this.debug) {
            Msg.info((Object)this, (Object)(String.valueOf(minInstrAddress) + "   " + String.valueOf(instruction) + "   " + startIndex));
        }
        HashSet<Address> previousInjectionTarget = new HashSet<Address>();
        int mustClearAllUntil_PcodeIndex = -1;
        boolean mustClearAll = false;
        boolean injected = false;
        int ptype = 0;
        block43: for (int pcodeIndex = startIndex; pcodeIndex < ops.length; ++pcodeIndex) {
            mustClearAll = pcodeIndex < mustClearAllUntil_PcodeIndex;
            PcodeOp pcodeOp = ops[pcodeIndex];
            ptype = pcodeOp.getOpcode();
            Varnode out = pcodeOp.getOutput();
            Varnode[] in = pcodeOp.getInputs();
            Varnode result = null;
            boolean suspectOffset = false;
            if (this.debug) {
                Msg.info((Object)this, (Object)("   " + String.valueOf(pcodeOp)));
            }
            try {
                switch (ptype) {
                    case 1: {
                        AddressSpace addressSpace;
                        if (in[0].isAddress() && (!(addressSpace = in[0].getAddress().getAddressSpace()).hasMappedRegisters() || this.program.getRegister(in[0]) == null)) {
                            this.makeReference(vContext, instruction, -1, in[0], null, RefType.READ, ptype, true, monitor);
                        }
                        vContext.copy(out, in[0], mustClearAll, this.evaluator);
                        break;
                    }
                    case 67: {
                        Varnode vval = this.context.getValue(in[2], this.evaluator);
                        if (this.context.isSymbolicSpace(vval.getSpace())) {
                            vval = vContext.createVarnode(vval.getOffset(), vval.getSpace(), out.getSize());
                        }
                        vContext.putValue(out, vval, mustClearAll);
                        break;
                    }
                    case 2: {
                        Varnode vt;
                        Varnode memVal = null;
                        Varnode val1 = vContext.getValue(in[0], this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], this.evaluator);
                        if (val1 != null && val2 != null) {
                            suspectOffset = vContext.isSuspectConstant(val2);
                            vt = vContext.getVarnode(in[0], val2, out.getSize(), this.evaluator);
                            if (vt != null) {
                                this.addLoadStoreReference(vContext, instruction, ptype, vt, in[0], in[1], RefType.READ, !suspectOffset, monitor);
                                memVal = vContext.getValue(vt, this.evaluator);
                            }
                        }
                        vContext.putValue(out, memVal, mustClearAll);
                        break;
                    }
                    case 3: {
                        Varnode offs = null;
                        offs = vContext.getValue(in[1], true, this.evaluator);
                        if (offs != null) {
                            suspectOffset = vContext.isSuspectConstant(offs);
                            out = this.getStoredLocation(vContext, in[0], offs, in[2]);
                        }
                        this.addLoadStoreReference(vContext, instruction, ptype, out, in[0], in[1], RefType.WRITE, !suspectOffset, monitor);
                        Varnode val3 = vContext.getValue(in[2], null);
                        if (val3 != null && !injected) {
                            this.addStoredReferences(vContext, instruction, out, val3, monitor);
                        }
                        vContext.putValue(out, val3, mustClearAll);
                        break;
                    }
                    case 6: {
                        Reference[] flowRefs;
                        Varnode vt;
                        Varnode val1 = vContext.getValue(in[0], this.evaluator);
                        if (val1 != null) {
                            suspectOffset = vContext.isSuspectConstant(val1);
                            vt = this.getConstantOrExternal(vContext, minInstrAddress, val1);
                            if (vt != null) {
                                this.makeReference(vContext, instruction, -1, vt, null, (RefType)instruction.getFlowType(), ptype, !suspectOffset, monitor);
                            }
                        }
                        vContext.propogateResults(true);
                        for (Reference flowRef : flowRefs = instruction.getReferencesFrom()) {
                            RefType referenceType = flowRef.getReferenceType();
                            if (!referenceType.isComputed() || !referenceType.isJump()) continue;
                            contextStack.push(new SavedFlowState(vContext, FlowType.UNCONDITIONAL_JUMP, flowRef.getFromAddress(), flowRef.getToAddress(), continueAfterHittingFlow));
                        }
                        if (this.evaluator == null || !this.evaluator.evaluateDestination(vContext, instruction)) continue block43;
                        this.canceled = true;
                        return false;
                    }
                    case 7: 
                    case 8: {
                        PcodeOp[] injectionPcode;
                        Address target = null;
                        Function func = null;
                        Varnode val1 = in[0];
                        if (ptype == 8) {
                            if ((val1 = vContext.getValue(val1, this.evaluator)) != null) {
                                Reference[] refs;
                                if (vContext.isConstant(val1)) {
                                    suspectOffset = vContext.isSuspectConstant(val1);
                                    target = instruction.getAddress().getNewTruncatedAddress(val1.getOffset(), true);
                                } else if (val1.isAddress()) {
                                    target = this.resolveFunctionReference(val1.getAddress());
                                } else if (vContext.isExternalSpace(val1.getSpace())) {
                                    target = val1.getAddress();
                                }
                                if (!(target == null || (refs = instruction.getReferencesFrom()).length > 0 && refs[0].getToAddress().equals((Object)target))) {
                                    target = this.makeReference(vContext, instruction, -1, target.getAddressSpace().getSpaceID(), target.getAddressableWordOffset(), val1.getSize(), null, (RefType)instruction.getFlowType(), ptype, !suspectOffset, false, monitor);
                                }
                            }
                        } else {
                            target = val1.getAddress();
                        }
                        Program prog = instruction.getProgram();
                        if (target != null) {
                            Reference firstRef;
                            Reference[] refs;
                            if (target.isMemoryAddress()) {
                                vContext.propogateResults(false);
                            }
                            if ((func = this.getFunctionAt(target)) == null && ptype == 8 && (refs = instruction.getReferencesFrom()) != null && refs.length > 0 && ((firstRef = refs[0]).getReferenceType().isData() || firstRef.getReferenceType().isIndirect())) {
                                target = firstRef.getToAddress();
                                func = this.getFunctionAt(target);
                            }
                            if (!previousInjectionTarget.contains(target) && (injectionPcode = this.checkForCallFixup(prog, func, instruction)) != null && injectionPcode.length > 0) {
                                previousInjectionTarget.add(target);
                                ops = this.injectPcode(ops, pcodeIndex, injectionPcode);
                                pcodeIndex = -1;
                                injected = true;
                                continue block43;
                            }
                        }
                        if (func != null && func.isInline()) {
                            contextStack.push(new SavedFlowState(vContext, RefType.FALL_THROUGH, minInstrAddress, func.getEntryPoint(), pcodeIndex + 1, continueAfterHittingFlow));
                            contextStack.push(new SavedFlowState(vContext, RefType.UNCONDITIONAL_CALL, minInstrAddress, func.getEntryPoint(), continueAfterHittingFlow));
                            return false;
                        }
                        this.handleFunctionSideEffects(instruction, target, monitor);
                        injectionPcode = this.checkForUponReturnCallMechanismInjection(prog, func, target, instruction);
                        if (injectionPcode == null || injectionPcode.length <= 0) continue block43;
                        ops = this.injectPcode(ops, pcodeIndex, injectionPcode);
                        pcodeIndex = -1;
                        injected = true;
                        continue block43;
                    }
                    case 9: {
                        PcodeOp[] callOtherPcode = this.doCallOtherPcodeInjection(instruction, in, out);
                        if (callOtherPcode != null) {
                            ops = this.injectPcode(ops, pcodeIndex, callOtherPcode);
                            pcodeIndex = -1;
                            injected = true;
                            break;
                        }
                        if (out == null) continue block43;
                        vContext.putValue(out, vContext.createBadVarnode(), mustClearAll);
                        break;
                    }
                    case 4: {
                        if (in[0].isConstant()) {
                            int sequenceOffset = (int)in[0].getOffset();
                            if (sequenceOffset < 0) {
                                pcodeIndex = ops.length;
                                break;
                            }
                            pcodeIndex += sequenceOffset - 1;
                            ptype = 0;
                            break;
                        }
                        if (!in[0].isAddress()) {
                            throw new AssertException("Not a valid Address on instruction at " + String.valueOf(instruction.getAddress()));
                        }
                        vContext.propogateResults(true);
                        nextAddr = minInstrAddress.getAddressSpace().getOverlayAddress(in[0].getAddress());
                        contextStack.push(new SavedFlowState(vContext, RefType.UNCONDITIONAL_JUMP, minInstrAddress, nextAddr, continueAfterHittingFlow));
                        return false;
                    }
                    case 5: {
                        boolean conditionMet;
                        Varnode vt = null;
                        boolean internalBranch = in[0].isConstant();
                        if (internalBranch) {
                            int sequenceOffset = (int)in[0].getOffset();
                            if (pcodeIndex + sequenceOffset >= ops.length) {
                                vContext.propogateResults(false);
                            }
                        } else if (in[0].isAddress()) {
                            vt = in[0];
                            vContext.propogateResults(false);
                        }
                        Varnode condition = vContext.getValue(in[1], null);
                        Long longVal1 = condition != null ? vContext.getConstant(condition, null) : Long.valueOf(0L);
                        boolean followFalse = this.evaluator.followFalseConditionalBranches();
                        boolean bl = conditionMet = longVal1 != null && longVal1 != 0L;
                        if (conditionMet) {
                            if (internalBranch) {
                                int sequenceOffset = (int)in[0].getOffset();
                                if (sequenceOffset > 0) {
                                    if (followFalse) {
                                        contextStack.push(new SavedFlowState(vContext, RefType.FALL_THROUGH, minInstrAddress, minInstrAddress, pcodeIndex + 1, continueAfterHittingFlow));
                                    }
                                    pcodeIndex += sequenceOffset - 1;
                                    break;
                                }
                                if (followFalse) continue block43;
                                pcodeIndex = ops.length;
                                break;
                            }
                            if (followFalse) {
                                contextStack.push(new SavedFlowState(vContext, RefType.FALL_THROUGH, minInstrAddress, minInstrAddress, pcodeIndex + 1, continueAfterHittingFlow));
                            }
                            nextAddr = minInstrAddress.getAddressSpace().getOverlayAddress(in[0].getAddress());
                            contextStack.push(new SavedFlowState(vContext, RefType.CONDITIONAL_JUMP, minInstrAddress, nextAddr, continueAfterHittingFlow));
                            pcodeIndex = ops.length;
                            return false;
                        }
                        if (internalBranch) {
                            int sequenceOffset = (int)in[0].getOffset();
                            if (sequenceOffset > 0) {
                                int internalIndex = pcodeIndex + sequenceOffset;
                                if (!followFalse) continue block43;
                                contextStack.push(new SavedFlowState(vContext, RefType.FALL_THROUGH, minInstrAddress, minInstrAddress, internalIndex, continueAfterHittingFlow));
                                break;
                            }
                            if (followFalse) continue block43;
                            pcodeIndex = ops.length;
                            break;
                        }
                        if (!followFalse) continue block43;
                        nextAddr = minInstrAddress.getAddressSpace().getOverlayAddress(in[0].getAddress());
                        contextStack.push(new SavedFlowState(vContext, RefType.CONDITIONAL_JUMP, minInstrAddress, nextAddr, continueAfterHittingFlow));
                        break;
                    }
                    case 10: {
                        Varnode val1 = vContext.getValue(in[0], this.evaluator);
                        if (val1 != null && this.evaluator != null && this.evaluator.evaluateReturn(val1, vContext, instruction)) {
                            this.canceled = true;
                            return false;
                        }
                        this.addReturnReferences(instruction, vContext, monitor);
                        break;
                    }
                    case 17: {
                        if (in[0].isAddress()) {
                            this.makeReference(vContext, instruction, -1, in[0], null, RefType.READ, ptype, true, monitor);
                        }
                        Varnode val1 = vContext.extendValue(out, in, false, this.evaluator);
                        vContext.putValue(out, val1, mustClearAll);
                        break;
                    }
                    case 18: {
                        if (in[0].isAddress()) {
                            this.makeReference(vContext, instruction, -1, in[0], null, RefType.READ, ptype, true, monitor);
                        }
                        Varnode val1 = vContext.extendValue(out, in, true, this.evaluator);
                        vContext.putValue(out, val1, mustClearAll);
                        break;
                    }
                    case 19: {
                        Long v;
                        Varnode val2;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        if (val1 == null) {
                            val1 = vContext.createBadVarnode();
                        }
                        if ((val2 = vContext.getValue(in[1], false, this.evaluator)) == null) {
                            val2 = vContext.createBadVarnode();
                        }
                        if (val1.equals((Object)val2) && (v = vContext.getConstant(val1, this.evaluator)) != null) {
                            val1 = val2 = vContext.createConstantVarnode(v, val1.getSize());
                        }
                        result = vContext.add(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 20: {
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.subtract(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: {
                        long lresult;
                        BinaryOpBehavior binaryBehavior = (BinaryOpBehavior)OpBehaviorFactory.getOpBehavior((int)ptype);
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = binaryBehavior.evaluateBinary(out.getSize(), in[0].getSize(), longVal1.longValue(), longVal2.longValue());
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 24: {
                        long lresult;
                        UnaryOpBehavior unaryBehavior = (UnaryOpBehavior)OpBehaviorFactory.getOpBehavior((int)ptype);
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        if (longVal1 != null) {
                            lresult = unaryBehavior.evaluateUnary(out.getSize(), in[0].getSize(), longVal1.longValue());
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 25: {
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        if (longVal1 != null) {
                            result = vContext.createConstantVarnode((long)(longVal1 ^ 0xFFFFFFFFFFFFFFFFL), val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 26: {
                        long lresult;
                        Long longVal2;
                        Long longVal1;
                        Varnode val2;
                        Varnode val1;
                        if (in[0].isRegister() && in[0].equals((Object)in[1])) {
                            result = vContext.createConstantVarnode(0L, out.getSize());
                        } else {
                            val1 = vContext.getValue(in[0], false, this.evaluator);
                            val2 = vContext.getValue(in[1], false, this.evaluator);
                            longVal1 = vContext.getConstant(val1, this.evaluator);
                            longVal2 = vContext.getConstant(val2, this.evaluator);
                            if (longVal1 != null && longVal2 != null) {
                                lresult = longVal1 ^ longVal2;
                                result = vContext.createConstantVarnode(lresult, val1.getSize());
                            }
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 27: {
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.and(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 28: {
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.or(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 29: {
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.left(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 30: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 >> (int)longVal2.longValue();
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 31: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], true, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 >>> (int)longVal2.longValue();
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 32: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], true, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], true, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 * longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 33: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null & longVal2 != null && longVal2 != 0L) {
                            lresult = longVal1 / longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 34: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], true, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], true, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null && longVal2 != 0L) {
                            lresult = longVal1 / longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 35: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null && longVal2 != 0L) {
                            lresult = longVal1 % longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 36: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], true, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], true, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null && longVal2 != 0L) {
                            lresult = longVal1 % longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 63: {
                        long lresult;
                        Long longVal1;
                        Varnode val1 = vContext.getValue(in[0], true, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], true, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (val1 != null && longVal2 != null) {
                            long subbyte = 8L * longVal2;
                            if (vContext.isSymbol(val1) & subbyte == 0L && out.getSize() == instruction.getAddress().getPointerSize()) {
                                result = val1;
                            } else if (out.getSize() <= 8 && (longVal1 = vContext.getConstant(val1, this.evaluator)) != null) {
                                lresult = longVal1 >> (int)subbyte & maskSize[out.getSize()];
                                result = vContext.createConstantVarnode(lresult, out.getSize());
                            }
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 15: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = Long.compareUnsigned(longVal1, longVal2) < 0 ? 1L : 0L;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 13: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], true, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], true, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 < longVal2 ? 1L : 0L;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 16: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = Long.compareUnsigned(longVal1, longVal2) <= 0 ? 1L : 0L;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 14: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], true, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], true, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 <= longVal2 ? 1L : 0L;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 11: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 == longVal2 ? 1L : 0L;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 12: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 != longVal2 ? 1L : 0L;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 37: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        if (longVal1 != null) {
                            lresult = longVal1 == 0L ? 1 : 0;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 38: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 ^ longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 39: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 & longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 40: {
                        long lresult;
                        Varnode val1 = vContext.getValue(in[0], false, this.evaluator);
                        Varnode val2 = vContext.getValue(in[1], false, this.evaluator);
                        Long longVal1 = vContext.getConstant(val1, this.evaluator);
                        Long longVal2 = vContext.getConstant(val2, this.evaluator);
                        if (longVal1 != null && longVal2 != null) {
                            lresult = longVal1 | longVal2;
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    default: {
                        if (out == null) continue block43;
                        vContext.putValue(out, null, false);
                    }
                }
                continue;
            }
            catch (AddressOutOfBoundsException e) {
                if (out == null) continue;
                vContext.putValue(out, null, false);
            }
        }
        vContext.propogateResults(true);
        return true;
    }

    private Varnode getConstantOrExternal(VarnodeContext vContext, Address minInstrAddress, Varnode val1) {
        Varnode vt;
        if (!this.context.isExternalSpace(val1.getSpace())) {
            Long lval = vContext.getConstant(val1, this.evaluator);
            if (lval == null) {
                return null;
            }
            vt = vContext.getVarnode(minInstrAddress.getAddressSpace().getSpaceID(), lval, 0);
        } else {
            vt = val1;
        }
        return vt;
    }

    private Varnode getStoredLocation(VarnodeContext vContext, Varnode space, Varnode offset, Varnode size) {
        Varnode out = null;
        if (offset == null) {
            return null;
        }
        out = vContext.getVarnode(space, offset, size.getSize(), this.evaluator);
        return out;
    }

    private void handleFunctionSideEffects(Instruction instruction, Address target, TaskMonitor monitor) {
        Varnode outStack;
        Address fallThruAddr;
        Function targetFunc = null;
        if (target != null) {
            targetFunc = this.getFunctionAt(target);
        }
        if ((fallThruAddr = instruction.getFallThrough()) == null || target == null || target.getOffset() != fallThruAddr.getOffset()) {
            Varnode[] killedVarnodes;
            Varnode[] returnVarnodes;
            if (this.checkForParamRefs && this.evaluator != null && this.evaluator.evaluateReference(this.context, instruction, 0, target == null ? Address.NO_ADDRESS : target, 0, null, (RefType)RefType.UNCONDITIONAL_CALL)) {
                this.addParamReferences(targetFunc, target, instruction, this.context, monitor);
            }
            if ((returnVarnodes = this.context.getReturnVarnode(targetFunc)) != null) {
                for (Varnode varnode : returnVarnodes) {
                    this.context.putValue(varnode, this.context.createBadVarnode(), false);
                }
            }
            if ((killedVarnodes = this.context.getKilledVarnodes(targetFunc)) != null) {
                for (Varnode varnode : killedVarnodes) {
                    this.context.putValue(varnode, this.context.createBadVarnode(), false);
                }
            }
        }
        if (targetFunc != null && targetFunc.isInline()) {
            return;
        }
        if (targetFunc != null && targetFunc.hasNoReturn()) {
            this.context.propogateResults(false);
        }
        if (!((outStack = this.context.getStackVarnode()) == null || targetFunc != null && targetFunc.isInline())) {
            int purge = this.getFunctionPurge(this.program, targetFunc);
            purge = this.addStackOverride(this.program, instruction.getMinAddress(), purge);
            if (purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) {
                Varnode curVal = null;
                if (fallThruAddr != null) {
                    Address[] knownFlowToAddresses;
                    for (Address knownFlowToAddresse : knownFlowToAddresses = this.context.getKnownFlowToAddresses(fallThruAddr)) {
                        curVal = this.context.getRegisterVarnodeValue(this.context.getStackRegister(), knownFlowToAddresse, fallThruAddr, false);
                        if (curVal != null) break;
                    }
                }
                if (curVal != null) {
                    this.context.putValue(outStack, curVal, false);
                } else if (instruction.getLength() != 1) {
                    this.context.putValue(outStack, null, false);
                }
            } else if (purge != 0) {
                Varnode purgeVar = this.context.createConstantVarnode(purge, outStack.getSize());
                Varnode val1 = this.context.getValue(outStack, true, this.evaluator);
                Varnode val2 = null;
                if (val1 != null) {
                    val2 = this.context.add(val1, purgeVar, this.evaluator);
                }
                this.context.putValue(outStack, val2, false);
            }
        }
    }

    private boolean isBranch(PcodeOp pcodeOp) {
        if (pcodeOp.isAssignment()) {
            return false;
        }
        int opcode = pcodeOp.getOpcode();
        return opcode != 3 && opcode != 2;
    }

    private Address resolveFunctionReference(Address addr) {
        Address extAddr = null;
        for (Reference ref : this.program.getReferenceManager().getReferencesFrom(addr)) {
            if (ref.isExternalReference()) {
                extAddr = ref.getToAddress();
                continue;
            }
            if (!ref.isMemoryReference() || !ref.getReferenceType().isCall()) continue;
            return ref.getToAddress();
        }
        return extAddr;
    }

    private PcodeOp[] checkForCallFixup(Program prog, Function func, Instruction instr) {
        if (func == null) {
            return null;
        }
        String callFixupName = func.getCallFixup();
        if (callFixupName == null) {
            return null;
        }
        PcodeInjectLibrary snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(1, callFixupName);
        if (payload == null) {
            return null;
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = func.getEntryPoint();
        try {
            return payload.getPcode(prog, con);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)e.getMessage());
            return null;
        }
    }

    private PcodeOp[] checkForUponReturnCallMechanismInjection(Program prog, Function func, Address target, Instruction instr) {
        PrototypeModel callingConvention = null;
        if (func != null) {
            callingConvention = func.getCallingConvention();
        }
        if (callingConvention == null) {
            callingConvention = prog.getCompilerSpec().getDefaultCallingConvention();
        }
        String injectionName = callingConvention.getName() + "@@inject_uponreturn";
        PcodeInjectLibrary snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(3, injectionName);
        if (payload == null) {
            return null;
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = target;
        try {
            return payload.getPcode(prog, con);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)e.getMessage());
            return null;
        }
    }

    private PcodeOp[] injectPcode(PcodeOp[] currentPcode, int pcodeIndex, PcodeOp[] replacePcode) {
        int opsRemaining = currentPcode.length - pcodeIndex - 1;
        if (opsRemaining == 0) {
            currentPcode = replacePcode;
        } else {
            PcodeOp[] replacePcodeExpanded = new PcodeOp[replacePcode.length + opsRemaining];
            System.arraycopy(replacePcode, 0, replacePcodeExpanded, 0, replacePcode.length);
            System.arraycopy(currentPcode, pcodeIndex + 1, replacePcodeExpanded, replacePcode.length, opsRemaining);
            currentPcode = replacePcodeExpanded;
        }
        return currentPcode;
    }

    private PcodeOp[] doCallOtherPcodeInjection(Instruction instr, Varnode[] ins, Varnode out) {
        PcodeInjectLibrary snippetLibrary;
        Program prog = instr.getProgram();
        InjectPayload payload = this.findPcodeInjection(prog, snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary(), ins[0].getOffset());
        if (payload == null) {
            return null;
        }
        ArrayList<Varnode> inputs = new ArrayList<Varnode>();
        for (int i = 1; i < ins.length; ++i) {
            Varnode vval = this.context.getValue(ins[i], this.evaluator);
            if (vval == null || !this.context.isConstant(vval)) {
                return this.checkSegmentCallOther(payload, instr, ins, out);
            }
            inputs.add(vval);
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = null;
        con.inputlist = inputs;
        con.output = new ArrayList();
        if (out != null) {
            con.output.add(out);
        }
        try {
            return payload.getPcode(prog, con);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)e.getMessage());
            return null;
        }
    }

    private PcodeOp[] checkSegmentCallOther(InjectPayload payload, Instruction instr, Varnode[] ins, Varnode out) {
        if (!payload.getName().equals("segment_pcode")) {
            return null;
        }
        if (ins.length != 3) {
            return null;
        }
        Varnode vval = this.context.getValue(ins[2], this.evaluator);
        if (vval == null) {
            return null;
        }
        if (!this.context.isSymbolicSpace(vval.getSpace())) {
            return null;
        }
        if (!this.context.isRegister(ins[1])) {
            return null;
        }
        PcodeOp[] newop = new PcodeOp[]{new PcodeOp(instr.getAddress(), 1, 67, ins, out)};
        return newop;
    }

    private InjectPayload findPcodeInjection(Program prog, PcodeInjectLibrary snippetLibrary, long callOtherIndex) {
        InjectPayload payload = this.injectPayloadCache.get(callOtherIndex);
        if (payload != null) {
            return payload;
        }
        if (this.injectPayloadCache.containsKey(callOtherIndex)) {
            return null;
        }
        String opName = prog.getLanguage().getUserDefinedOpName((int)callOtherIndex);
        payload = "segment".equals(opName) ? snippetLibrary.getPayload(4, "segment_pcode") : snippetLibrary.getPayload(2, opName);
        this.injectPayloadCache.put(callOtherIndex, payload);
        return payload;
    }

    private int getFunctionPurge(Program prog, Function function) {
        if (function == null) {
            return this.getDefaultStackDepthChange(prog, null, Integer.MAX_VALUE);
        }
        PrototypeModel conv = function.getCallingConvention();
        if (function.isStackPurgeSizeValid()) {
            int depth = function.getStackPurgeSize();
            return this.getDefaultStackDepthChange(prog, conv, depth);
        }
        return this.getDefaultStackDepthChange(prog, conv, Integer.MAX_VALUE);
    }

    private int getDefaultStackDepthChange(Program prog, PrototypeModel model, int depth) {
        if (model == null) {
            model = prog.getCompilerSpec().getDefaultCallingConvention();
        }
        if (model == null) {
            return Integer.MAX_VALUE;
        }
        int callStackMod = model.getExtrapop();
        int callStackShift = model.getStackshift();
        if (callStackMod != 32768) {
            return callStackShift;
        }
        if (depth == Integer.MAX_VALUE || depth == 0x7FFFFFFE) {
            return Integer.MAX_VALUE;
        }
        return callStackShift + depth;
    }

    private int addStackOverride(Program prog, Address addr, int purge) {
        Integer stackDepthChange = CallDepthChangeInfo.getStackDepthChange(prog, addr);
        if (stackDepthChange == null) {
            return purge;
        }
        int extrapop = CallDepthChangeInfo.getStackDepthChange(prog, addr);
        if (purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) {
            return extrapop;
        }
        return purge + extrapop;
    }

    private void addParamReferences(Function func, Address callTarget, Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor) {
        boolean trustSignature;
        if (!this.checkForParamRefs) {
            return;
        }
        PrototypeModel conv = this.program.getCompilerSpec().getDefaultCallingConvention();
        int extraParamIndex = -1;
        Parameter[] params = new Parameter[]{};
        SourceType signatureSource = SourceType.DEFAULT;
        if (func != null) {
            PrototypeModel thisConv;
            PrototypeModel funcConv = func.getCallingConvention();
            if (funcConv != null) {
                conv = funcConv;
            }
            params = func.getParameters();
            Namespace parentNamespace = func.getParentNamespace();
            if (parentNamespace != null && parentNamespace instanceof GhidraClass && conv != (thisConv = this.program.getCompilerSpec().getCallingConvention("__thiscall"))) {
                extraParamIndex = params.length;
            }
            signatureSource = func.getSignatureSource();
        } else if (this.checkForParamPointerRefs) {
            return;
        }
        long callOffset = callTarget == null ? -1L : callTarget.getOffset();
        boolean signatureAssigned = signatureSource != SourceType.DEFAULT;
        boolean bl = trustSignature = signatureAssigned || params.length > 0;
        if (trustSignature && !func.hasVarArgs()) {
            VariableStorage var;
            for (Parameter param : params) {
                Parameter p = param;
                DataType dataType = p.getDataType();
                if (!(dataType instanceof Pointer || dataType instanceof TypeDef && ((TypeDef)dataType).isPointer())) {
                    if (this.checkForParamPointerRefs) continue;
                    if (dataType instanceof TypeDef) {
                        TypeDef tdef = (TypeDef)dataType;
                        dataType = tdef.getBaseDataType();
                    }
                    if (!Undefined.isUndefined((DataType)dataType) && !(dataType instanceof IntegerDataType)) continue;
                }
                this.createVariableStorageReference(instruction, varnodeContext, monitor, conv, p.getVariableStorage(), dataType, callOffset);
            }
            if (extraParamIndex != -1 && !(var = conv.getArgLocation(extraParamIndex, null, this.pointerSizedDT, this.program)).isStackStorage()) {
                this.createVariableStorageReference(instruction, varnodeContext, monitor, conv, var, null, callOffset);
            }
        } else if (!this.checkForParamPointerRefs) {
            for (int pi = 0; pi < 8; ++pi) {
                VariableStorage var = conv.getArgLocation(pi, null, this.pointerSizedDT, this.program);
                if (var.isStackStorage()) continue;
                this.createVariableStorageReference(instruction, varnodeContext, monitor, conv, var, null, callOffset);
            }
        }
    }

    private void addReturnReferences(Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor) {
        if (!this.checkForReturnRefs) {
            return;
        }
        Function func = this.program.getFunctionManager().getFunctionContaining(instruction.getMinAddress());
        VariableStorage returnLoc = this.getReturnLocationStorage(func);
        if (returnLoc == null) {
            return;
        }
        this.createVariableStorageReference(instruction, varnodeContext, monitor, null, returnLoc, null, 0L);
    }

    private void addLoadStoreReference(VarnodeContext vContext, Instruction instruction, int pcodeType, Varnode refLocation, Varnode targetSpaceID, Varnode assigningVarnode, RefType reftype, boolean knownReference, TaskMonitor monitor) {
        if (refLocation == null) {
            return;
        }
        int opIndex = this.findOperandWithVarnodeAssignment(instruction, assigningVarnode);
        if (instruction.getFlowType().isCall()) {
            this.makeReference(vContext, instruction, opIndex, refLocation, null, reftype, pcodeType, knownReference, monitor);
        } else {
            int spaceID = refLocation.getSpace();
            if (vContext.isSymbolicSpace(spaceID)) {
                Address constant;
                Address newTarget;
                long offset = refLocation.getOffset();
                if (this.evaluator != null && !vContext.isStackSymbolicSpace(refLocation) && this.evaluator != null && (newTarget = this.evaluator.evaluateConstant(vContext, instruction, pcodeType, constant = this.program.getAddressFactory().getAddress((int)targetSpaceID.getOffset(), offset), 0, null, reftype)) != null) {
                    this.makeReference(vContext, instruction, -1, newTarget.getAddressSpace().getSpaceID(), newTarget.getOffset(), 0, null, RefType.DATA, pcodeType, false, false, monitor);
                    return;
                }
            }
            this.makeReference(vContext, instruction, opIndex, refLocation, null, reftype, pcodeType, knownReference, monitor);
        }
    }

    private int findOperandWithVarnodeAssignment(Instruction instruction, Varnode assigningVarnode) {
        if (!assigningVarnode.isUnique()) {
            return -1;
        }
        for (int opIndex = 0; opIndex < instruction.getNumOperands(); ++opIndex) {
            PcodeOp[] pcode = instruction.getPcode(opIndex);
            for (int j = pcode.length - 1; j >= 0; --j) {
                if (!assigningVarnode.equals((Object)pcode[j].getOutput())) continue;
                return opIndex;
            }
        }
        return -1;
    }

    private boolean checkPossibleOffsetAddr(long offset) {
        long maxAddrOffset = this.pointerMask;
        return (offset < 0L || offset >= 256L) && Math.abs(maxAddrOffset - offset) >= 256L;
    }

    private void addStoredReferences(VarnodeContext vContext, Instruction instruction, Varnode storageLocation, Varnode valueToStore, TaskMonitor monitor) {
        if (!this.checkForStoredRefs) {
            return;
        }
        if (storageLocation != null && storageLocation.isRegister()) {
            return;
        }
        if (!vContext.isConstant(valueToStore)) {
            return;
        }
        long valueOffset = valueToStore.getOffset();
        this.makeReference(vContext, instruction, -1, -1L, valueOffset, 0, null, RefType.DATA, 3, false, false, monitor);
    }

    private void createVariableStorageReference(Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor, PrototypeModel conv, VariableStorage storage, DataType dataType, long callOffset) {
        Address lastSetAddr;
        BigInteger bval;
        if (storage.isStackStorage()) {
            if (conv == null) {
                return;
            }
            Varnode sVnode = storage.getFirstVarnode();
            Varnode stackVarnode = varnodeContext.getStackVarnode();
            Varnode stackVal = varnodeContext.getValue(stackVarnode, null);
            if (stackVal == null) {
                return;
            }
            Varnode realSPVarnode = varnodeContext.createVarnode(stackVal.getOffset() + sVnode.getOffset(), stackVal.getSpace(), sVnode.getAddress().getAddressSpace().getPointerSize());
            Varnode value = null;
            value = varnodeContext.getValue(realSPVarnode, this.evaluator);
            if (value == null) {
                return;
            }
            if (!varnodeContext.isConstant(value)) {
                return;
            }
            bval = BigInteger.valueOf(value.getOffset());
            lastSetAddr = varnodeContext.getLastSetLocation(realSPVarnode, bval);
        } else if (storage.isRegisterStorage()) {
            RegisterValue lastRval;
            Register reg = storage.getRegister();
            RegisterValue rval = varnodeContext.getRegisterValue(reg);
            if (rval == null || !rval.hasValue()) {
                return;
            }
            reg = rval.getRegister();
            lastSetAddr = varnodeContext.getLastSetLocation(reg, bval = rval.getUnsignedValue());
            if (!(lastSetAddr == null || !instruction.getPrototype().hasDelaySlots() || (lastRval = varnodeContext.getRegisterValue(reg, lastSetAddr)) != null && lastRval.hasAnyValue() && lastRval.equals((Object)rval))) {
                lastSetAddr = instruction.getMaxAddress();
            }
        } else {
            return;
        }
        this.makeVariableStorageReference(storage, instruction, varnodeContext, monitor, callOffset, dataType, lastSetAddr, bval);
    }

    private void makeVariableStorageReference(VariableStorage storage, Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor, long callOffset, DataType dataType, Address lastSetAddr, BigInteger bval) {
        Instruction instr;
        Object value;
        TypeDef typedef;
        if (lastSetAddr == null) {
            lastSetAddr = instruction.getMaxAddress();
        }
        if (bval == null) {
            return;
        }
        long val = bval.longValue();
        if (val == callOffset) {
            return;
        }
        if (lastSetAddr == null) {
            return;
        }
        int knownSpaceID = -1;
        boolean knownReference = false;
        if (dataType != null && dataType instanceof TypeDef && (typedef = (TypeDef)dataType).isPointer() && (value = this.getPointerDataTypeValue(dataType, lastSetAddr, bval)) instanceof Address) {
            Address addrVal = (Address)value;
            val = addrVal.getAddressableWordOffset();
            knownSpaceID = addrVal.getAddressSpace().getSpaceID();
            knownReference = true;
        }
        if (!(instr = instruction).contains(lastSetAddr)) {
            instr = this.getInstructionContaining(lastSetAddr);
        }
        Reference[] refs = instr.getReferencesFrom();
        boolean found = false;
        for (Reference ref : refs) {
            Address refAddr = ref.getToAddress();
            Address addr = refAddr.getAddressSpace().getTruncatedAddress(val, true);
            if (ref.getReferenceType() == RefType.PARAM && !this.visitedBody.contains(ref.getFromAddress())) {
                instr.removeOperandReference(ref.getOperandIndex(), refAddr);
                continue;
            }
            if (refAddr.getOffset() != addr.getOffset()) continue;
            found = true;
        }
        RefType refType = callOffset == 0L ? RefType.DATA : RefType.PARAM;
        this.makeReference(varnodeContext, instr, -1, knownSpaceID, val, 0, dataType, refType, 0, knownReference, found, monitor);
    }

    private Object getPointerDataTypeValue(DataType dataType, Address lastSetAddr, BigInteger bval) {
        int len = dataType.getLength();
        byte[] byteArray = new byte[len];
        BigEndianDataConverter.INSTANCE.putBigInteger(byteArray, 0, len, bval);
        ByteMemBufferImpl buf = new ByteMemBufferImpl(this.program.getMemory(), lastSetAddr, byteArray, true);
        if (len > byteArray.length) {
            return null;
        }
        Object value = dataType.getValue((MemBuffer)buf, dataType.getDefaultSettings(), len);
        return value;
    }

    private VariableStorage getReturnLocationStorage(Function func) {
        VariableStorage returnLoc = null;
        int pointerSize = this.program.getDefaultPointerSize();
        PrototypeModel conv = null;
        if (func != null) {
            conv = func.getCallingConvention();
            DataType returnType = func.getReturnType();
            if (returnType != null && !(returnType instanceof DefaultDataType) && returnType.getLength() < pointerSize) {
                return null;
            }
        }
        if (conv == null) {
            conv = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        returnLoc = conv.getReturnLocation((DataType)new PointerDataType(Undefined.DEFAULT, pointerSize), this.program);
        return returnLoc;
    }

    private int getReferenceSpaceID(Instruction instruction, long offset) {
        if (offset <= 4L && offset >= -1L) {
            return -1;
        }
        AddressSpace defaultSpace = this.program.getLanguage().getDefaultDataSpace();
        if (this.memorySpaces.size() == 1) {
            return defaultSpace.getSpaceID();
        }
        int realMemSpaceCnt = 0;
        int containingMemSpaceCnt = 0;
        Address containingAddr = null;
        int symbolTargetCnt = 0;
        Address symbolTarget = null;
        AddressSpace instrSpace = instruction.getMinAddress().getAddressSpace();
        if (instrSpace.isOverlaySpace() && ((OverlayAddressSpace)instrSpace).getBaseSpaceID() == defaultSpace.getSpaceID()) {
            defaultSpace = instrSpace;
        }
        for (AddressSpace space : this.memorySpaces) {
            if (space.isOverlaySpace()) {
                if (space != instrSpace) {
                    continue;
                }
            } else {
                ++realMemSpaceCnt;
            }
            Address addr = space.getTruncatedAddress(offset, true);
            if (space.isOverlaySpace() && !addr.getAddressSpace().equals((Object)space)) continue;
            if (space.hasMappedRegisters() && this.program.getRegister(addr) != null) {
                if (space.isOverlaySpace()) continue;
                --realMemSpaceCnt;
                continue;
            }
            if (this.program.getMemory().contains(addr)) {
                ++containingMemSpaceCnt;
                containingAddr = addr;
            }
            if (!this.program.getReferenceManager().hasReferencesTo(addr) && this.program.getSymbolTable().getPrimarySymbol(addr) == null) continue;
            ++symbolTargetCnt;
            symbolTarget = addr;
        }
        if (containingMemSpaceCnt == 1 && containingAddr != null) {
            return containingAddr.getAddressSpace().getSpaceID();
        }
        if (symbolTargetCnt == 1 && symbolTarget != null) {
            return symbolTarget.getAddressSpace().getSpaceID();
        }
        if (realMemSpaceCnt != 1 && !this.defaultSpacesAreTheSame) {
            return -1;
        }
        return defaultSpace.getSpaceID();
    }

    public Address makeReference(VarnodeContext varnodeContext, Instruction instruction, int opIndex, Varnode vt, DataType dataType, RefType refType, int pcodeop, boolean knownReference, TaskMonitor monitor) {
        if (!vt.isAddress() && !varnodeContext.isExternalSpace(vt.getSpace())) {
            if (this.evaluator != null) {
                this.evaluator.evaluateSymbolicReference(varnodeContext, instruction, vt.getAddress());
            }
            return null;
        }
        return this.makeReference(varnodeContext, instruction, opIndex, vt.getSpace(), vt.getWordOffset(), vt.getSize(), dataType, refType, pcodeop, knownReference, false, monitor);
    }

    public Address makeReference(VarnodeContext vContext, Instruction instruction, int opIndex, long knownSpaceID, long wordOffset, int size, DataType dataType, RefType refType, int pcodeop, boolean knownReference, boolean preExisting, TaskMonitor monitor) {
        Address target;
        long spaceID = knownSpaceID;
        if (spaceID == -1L && (spaceID = (long)this.getReferenceSpaceID(instruction, wordOffset)) == -1L) {
            return null;
        }
        Address instructionAddress = instruction.getMinAddress();
        try {
            AddressSpace space = this.program.getAddressFactory().getAddressSpace((int)spaceID);
            if (space.isExternalSpace()) {
                target = space.getAddress(wordOffset, true);
            } else {
                if (!space.isLoadedMemorySpace()) {
                    return null;
                }
                if (wordOffset == 0L) {
                    return null;
                }
                target = wordOffset < 0L ? space.getTruncatedAddress(wordOffset, true) : space.getAddress(wordOffset, true);
                wordOffset = target.getAddressableWordOffset();
                if (space.hasMappedRegisters() && this.program.getRegister(target) != null) {
                    return null;
                }
                target = instructionAddress.getAddressSpace().getOverlayAddress(target);
                if (!(knownReference || this.program.getMemory().contains(target) || refType.isFlow() || this.program.getReferenceManager().hasReferencesTo(target))) {
                    return null;
                }
            }
            if (refType.isCall() && !refType.isComputed()) {
                return null;
            }
            if ((target = this.evaluateReference(vContext, instruction, knownSpaceID, wordOffset, size, dataType, refType, pcodeop, knownReference, target)) == null || preExisting) {
                return null;
            }
            if (refType.isData() && !this.evaluatePureDataRef(instruction, wordOffset, refType, target)) {
                return null;
            }
            if (refType.isJump() && refType.isComputed()) {
                Address[] flows = this.getInstructionFlows(instruction);
                if (flows.length > 1) {
                    return target;
                }
                for (Address address : flows) {
                    if (!address.equals((Object)target)) continue;
                    return target;
                }
            }
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
        if ((opIndex = this.findOpIndexForRef(vContext, instruction, opIndex, wordOffset, refType)) == -1 && instruction.getPrototype().hasDelaySlots() && !instruction.getFlowType().equals((Object)refType)) {
            if ((instruction = instruction.getNext()) == null) {
                return target;
            }
            opIndex = this.findOpIndexForRef(vContext, instruction, opIndex, wordOffset, refType);
        }
        if (opIndex == -1 && (!refType.isFlow() || target.isExternalAddress())) {
            opIndex = instruction.getNumOperands() - 1;
            List list = instruction.getDefaultOperandRepresentationList(opIndex);
            if (list == null || list.size() == 0) {
                opIndex = -1;
            }
            if (target.isExternalAddress() && instruction.getReferencesFrom().length != 0) {
                opIndex = -1;
            }
        }
        if (opIndex == -1) {
            instruction.addMnemonicReference(target, refType, SourceType.ANALYSIS);
        } else {
            instruction.addOperandReference(opIndex, target, refType, SourceType.ANALYSIS);
        }
        return target;
    }

    private Address evaluateReference(VarnodeContext vContext, Instruction instruction, long knownSpaceID, long wordOffset, int size, DataType dataType, RefType refType, int pcodeop, boolean knownReference, Address target) {
        if (this.evaluator == null) {
            return target;
        }
        if (knownSpaceID == -1L || !knownReference) {
            Address constant = this.program.getAddressFactory().getConstantAddress(wordOffset);
            Address newTarget = this.evaluator.evaluateConstant(vContext, instruction, pcodeop, constant, size, dataType, refType);
            if (newTarget == null) {
                return null;
            }
            if (newTarget != constant) {
                target = newTarget;
            }
        }
        if (!this.evaluator.evaluateReference(vContext, instruction, pcodeop, target, size, dataType, refType)) {
            return null;
        }
        return target;
    }

    private boolean evaluatePureDataRef(Instruction instruction, long wordOffset, RefType refType, Address target) {
        Instruction targetInstr;
        long fallAddrOffset;
        if (refType.isRead() || refType.isWrite()) {
            return true;
        }
        if ((instruction.hasFallthrough() || instruction.getFlowOverride() != FlowOverride.NONE) && (fallAddrOffset = instruction.getMinAddress().getOffset() + (long)instruction.getDefaultFallThroughOffset()) == wordOffset) {
            return false;
        }
        if (this.program.getMemory().contains(target) && (targetInstr = this.getInstructionContaining(target)) != null) {
            Address disassemblyAddress = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)this.program, (Address)target);
            if (!targetInstr.getMinAddress().equals((Object)disassemblyAddress)) {
                return false;
            }
            if (targetInstr.isInDelaySlot()) {
                return false;
            }
            Function func = this.program.getFunctionManager().getFunctionContaining(target);
            if (func != null && !func.getEntryPoint().equals((Object)disassemblyAddress)) {
                return false;
            }
        }
        return true;
    }

    private int findOpIndexForRef(VarnodeContext vcontext, Instruction instruction, int opIndex, long wordOffset, RefType refType) {
        int numOperands = instruction.getNumOperands();
        for (int i = 0; i < numOperands; ++i) {
            List list;
            int len;
            long val;
            Scalar s;
            Address opAddr;
            int opType = instruction.getOperandType(i);
            if ((opType & 0x2000) != 0 && (opAddr = instruction.getAddress(i)) != null && opAddr.getAddressableWordOffset() == wordOffset) {
                opIndex = i;
                break;
            }
            if ((opType & 0x4000) != 0 && (s = instruction.getScalar(i)) != null && ((val = s.getUnsignedValue()) == wordOffset || val == wordOffset >> 1)) {
                opIndex = i;
                break;
            }
            if (opIndex != -1) continue;
            if ((opType & 0x200) != 0) {
                Register reg = instruction.getRegister(i);
                if (refType.isFlow() && reg != null && reg.isProgramCounter()) {
                    opIndex = i;
                    break;
                }
                if (reg != null) {
                    if (this.checkOffByOne(reg, wordOffset)) {
                        opIndex = i;
                        if (refType.isFlow()) break;
                    }
                    if (this.checkOffByOne(reg.getParentRegister(), wordOffset)) {
                        opIndex = i;
                        if (refType.isFlow()) break;
                    }
                }
            }
            if ((opType & 0x400000) == 0 || (len = (list = instruction.getDefaultOperandRepresentationList(i)).size()) <= 0) continue;
            long baseRegVal = 0L;
            long offset_residue_pos = wordOffset;
            long offset_residue_neg = wordOffset;
            for (int idx = 0; idx < len; ++idx) {
                Register reg;
                BigInteger val2;
                Object obj = list.get(idx);
                if (obj instanceof Scalar) {
                    long val3 = ((Scalar)obj).getUnsignedValue();
                    if (val3 == wordOffset || val3 == wordOffset >> 1 || val3 + baseRegVal == wordOffset) {
                        opIndex = i;
                        break;
                    }
                    val3 = ((Scalar)obj).getSignedValue();
                    offset_residue_neg -= val3;
                    offset_residue_pos += val3;
                }
                if (!(obj instanceof Register) || (val2 = vcontext.getValue(reg = (Register)obj, false)) == null) continue;
                baseRegVal = val2.longValue();
                if ((baseRegVal & this.pointerMask) == wordOffset) {
                    opIndex = i;
                }
                offset_residue_neg -= baseRegVal;
                offset_residue_pos -= baseRegVal;
            }
            if (offset_residue_neg == 0L || offset_residue_pos == 0L) {
                opIndex = i;
                break;
            }
            if (opIndex != -1 || i != numOperands - 1) continue;
            opIndex = i;
        }
        return opIndex;
    }

    private boolean checkOffByOne(Register reg, long wordOffset) {
        if (reg == null) {
            return false;
        }
        BigInteger val = this.context.getValue(reg, false);
        if (val == null) {
            return false;
        }
        long lval = val.longValue() & this.pointerMask;
        return lval == wordOffset || (lval ^ wordOffset) == 1L;
    }

    public boolean encounteredBranch() {
        return this.hitCodeFlow;
    }

    public boolean readExecutable() {
        return this.readExecutableAddress;
    }

    public void setParamRefCheck(boolean checkParamRefsOption) {
        this.checkForParamRefs = checkParamRefsOption;
    }

    public void setParamPointerRefCheck(boolean checkParamRefsOption) {
        this.checkForParamPointerRefs = checkParamRefsOption;
    }

    public void setReturnRefCheck(boolean checkReturnRefsOption) {
        this.checkForReturnRefs = checkReturnRefsOption;
    }

    public void setStoredRefCheck(boolean checkStoredRefsOption) {
        this.checkForStoredRefs = checkStoredRefsOption;
    }

    public class Value {
        final Register relativeRegister;
        final long value;

        Value(SymbolicPropogator this$0, Register relativeRegister, long value) {
            this.relativeRegister = relativeRegister;
            this.value = value;
        }

        Value(SymbolicPropogator this$0, long value) {
            this.relativeRegister = null;
            this.value = value;
        }

        public long getValue() {
            if (this.isRegisterRelativeValue()) {
                long off = this.value;
                int size = this.relativeRegister.getBitLength();
                off = off << 64 - size >> 64 - size;
                return off;
            }
            return this.value;
        }

        public boolean isRegisterRelativeValue() {
            return this.relativeRegister != null;
        }

        public Register getRelativeRegister() {
            return this.relativeRegister;
        }
    }

    record SavedFlowState(VarnodeContext vContext, FlowType flowType, Address source, Address destination, int pcodeIndex, int continueAfterHittingFlow) {
        public SavedFlowState(VarnodeContext vContext, FlowType flowType, Address source, Address destination, int continueAfterHittingFlow) {
            this(vContext, flowType, source, destination, 0, continueAfterHittingFlow);
        }

        public SavedFlowState(VarnodeContext vContext, FlowType flowType, Address source, Address destination, int pcodeIndex, int continueAfterHittingFlow) {
            this.vContext = vContext;
            this.flowType = flowType;
            this.source = source;
            this.destination = destination;
            this.pcodeIndex = pcodeIndex;
            this.continueAfterHittingFlow = continueAfterHittingFlow;
            vContext.pushMemState();
        }

        public boolean isContinueAfterHittingFlow() {
            return this.continueAfterHittingFlow != -1;
        }

        public void restoreState() {
            this.vContext.popMemState();
        }
    }
}

