/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;

abstract class ReferenceDB
implements Reference {
    protected Address fromAddr;
    protected Address toAddr;
    protected RefType refType;
    protected int opIndex;
    protected SourceType sourceType;
    protected long symbolID;
    protected boolean isPrimary;

    ReferenceDB(Address fromAddr, Address toAddr, RefType refType, int opIndex, SourceType sourceType, boolean isPrimary, long symbolID) {
        this.fromAddr = fromAddr;
        this.toAddr = toAddr;
        this.refType = refType;
        this.opIndex = opIndex;
        this.sourceType = sourceType;
        this.isPrimary = isPrimary;
        this.symbolID = symbolID;
    }

    public abstract boolean equals(Object var1);

    @Override
    public Address getFromAddress() {
        return this.fromAddr;
    }

    @Override
    public RefType getReferenceType() {
        return this.refType;
    }

    @Override
    public int getOperandIndex() {
        return this.opIndex;
    }

    @Override
    public boolean isMnemonicReference() {
        return !this.isOperandReference();
    }

    @Override
    public boolean isOperandReference() {
        return this.opIndex >= 0;
    }

    public int hashCode() {
        return this.fromAddr.hashCode();
    }

    public String toString() {
        return "From: " + String.valueOf(this.fromAddr) + " To: " + String.valueOf(this.toAddr) + " Type: " + String.valueOf(this.refType) + " Op: " + this.opIndex + " " + this.sourceType.toString();
    }

    @Override
    public final int compareTo(Reference r) {
        int result = this.fromAddr.compareTo(r.getFromAddress());
        if (result == 0 && (result = this.opIndex - r.getOperandIndex()) == 0) {
            return this.toAddr.compareTo(r.getToAddress());
        }
        return result;
    }

    @Override
    public long getSymbolID() {
        return this.symbolID;
    }

    @Override
    public Address getToAddress() {
        return this.toAddr;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public boolean isExternalReference() {
        return false;
    }

    @Override
    public boolean isMemoryReference() {
        return this.toAddr.isMemoryAddress();
    }

    @Override
    public boolean isRegisterReference() {
        return this.toAddr.isRegisterAddress();
    }

    @Override
    public boolean isOffsetReference() {
        return false;
    }

    @Override
    public boolean isShiftedReference() {
        return false;
    }

    @Override
    public boolean isEntryPointReference() {
        return false;
    }

    @Override
    public boolean isStackReference() {
        return false;
    }

    @Override
    public SourceType getSource() {
        return this.sourceType;
    }
}

