/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.KeyRange;
import ghidra.program.model.address.OverlayAddressSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AddressMapImpl {
    private static final int ADDR_OFFSET_SIZE = 32;
    private static final int MAP_ID_SIZE = 8;
    private static final long MAX_OFFSET = 0xFFFFFFFFL;
    private static final long ADDR_OFFSET_MASK = 0xFFFFFFFFL;
    private static final long MAP_ID_MASK = -72057594037927936L;
    private static final long BASE_MASK = -4294967296L;
    private static final int BASE_ID_SIZE = 24;
    private static final int BASE_ID_MASK = 0xFFFFFF;
    private static final int STACK_SPACE_ID = 0xFFFFFF;
    private HashMap<String, AddressSpace> spaceMap = new HashMap();
    private AddressSpace stackSpace;
    private final AddressFactory addrFactory;
    private Address[] baseAddrs;
    private Address[] sortedBaseStartAddrs;
    private Address[] sortedBaseEndAddrs;
    private HashMap<Address, Integer> addrToIndexMap = new HashMap();
    private int lastBaseIndex;
    private long mapIdBits;
    private Comparator<Object> addressInsertionKeyRangeComparator = new Comparator<Object>(){

        @Override
        public int compare(Object keyRangeObj, Object addrObj) {
            KeyRange range = (KeyRange)keyRangeObj;
            Address addr = (Address)addrObj;
            Address min = AddressMapImpl.this.decodeAddress(range.minKey);
            if (min.compareTo(addr) > 0) {
                return 1;
            }
            Address max = AddressMapImpl.this.decodeAddress(range.maxKey);
            if (max.compareTo(addr) < 0) {
                return -1;
            }
            return 0;
        }
    };

    public AddressMapImpl() {
        this(0, null);
    }

    public AddressMapImpl(byte mapID, AddressFactory addrFactory) {
        this.addrFactory = addrFactory;
        this.mapIdBits = (long)mapID << 56;
        this.baseAddrs = new Address[0];
        this.init();
    }

    private void init() {
        int i;
        this.lastBaseIndex = this.baseAddrs.length - 1;
        this.sortedBaseEndAddrs = new Address[this.baseAddrs.length];
        this.sortedBaseStartAddrs = new Address[this.baseAddrs.length];
        System.arraycopy(this.baseAddrs, 0, this.sortedBaseStartAddrs, 0, this.baseAddrs.length);
        Arrays.sort(this.sortedBaseStartAddrs);
        for (i = 0; i < this.sortedBaseStartAddrs.length; ++i) {
            long max = this.sortedBaseStartAddrs[i].getAddressSpace().getMaxAddress().getOffset();
            max = max < 0L ? 0xFFFFFFFFL : Math.min(max, 0xFFFFFFFFL);
            long off = this.sortedBaseStartAddrs[i].getOffset() | max;
            this.sortedBaseEndAddrs[i] = this.sortedBaseStartAddrs[i].getAddressSpace().getAddressInThisSpaceOnly(off);
        }
        this.addrToIndexMap.clear();
        for (i = 0; i < this.baseAddrs.length; ++i) {
            if (this.addrToIndexMap.containsKey(this.baseAddrs[i])) continue;
            this.addrToIndexMap.put(this.baseAddrs[i], i);
        }
    }

    private int getBaseAddressIndex(Address addr) {
        Address base;
        Address base2;
        AddressSpace space = addr.getAddressSpace();
        if (space.isStackSpace()) {
            if (this.stackSpace != null && !this.stackSpace.equals(space)) {
                throw new IllegalArgumentException("Only one stack space allowed");
            }
            this.stackSpace = space;
            return 0xFFFFFF;
        }
        long baseOffset = addr.getOffset() & 0xFFFFFFFF00000000L;
        if (this.lastBaseIndex >= 0 && (base2 = this.baseAddrs[this.lastBaseIndex]).hasSameAddressSpace(addr) && baseOffset == base2.getOffset()) {
            return this.lastBaseIndex;
        }
        int search = Arrays.binarySearch(this.sortedBaseStartAddrs, addr);
        if (search < 0) {
            search = -search - 2;
        }
        if (search >= 0 && (base = this.sortedBaseStartAddrs[search]).hasSameAddressSpace(addr) && baseOffset == base.getOffset()) {
            int index;
            this.lastBaseIndex = index = this.addrToIndexMap.get(base).intValue();
            return index;
        }
        this.checkAddressSpace(addr.getAddressSpace());
        int index = this.baseAddrs.length;
        Address[] newBaseAddrs = new Address[this.baseAddrs.length + 1];
        System.arraycopy(this.baseAddrs, 0, newBaseAddrs, 0, this.baseAddrs.length);
        newBaseAddrs[index] = addr.getAddressSpace().getAddressInThisSpaceOnly(baseOffset);
        this.baseAddrs = newBaseAddrs;
        this.init();
        this.lastBaseIndex = index;
        return this.lastBaseIndex;
    }

    void checkAddressSpace(AddressSpace addrSpace) {
        String name = addrSpace.getName();
        AddressSpace existingSpace = this.spaceMap.get(name);
        if (existingSpace == null) {
            this.spaceMap.put(name, addrSpace);
        } else if (!addrSpace.equals(existingSpace)) {
            throw new IllegalArgumentException("Address space conflicts with another space in map");
        }
    }

    public synchronized Address decodeAddress(long value) {
        if ((value & 0xFF00000000000000L) != this.mapIdBits) {
            return Address.NO_ADDRESS;
        }
        int baseIndex = (int)(value >> 32) & 0xFFFFFF;
        long offset = value & 0xFFFFFFFFL;
        if (baseIndex == 0xFFFFFF && this.stackSpace != null) {
            return this.stackSpace.getAddress((int)offset);
        }
        if (baseIndex >= this.baseAddrs.length) {
            return Address.NO_ADDRESS;
        }
        return this.baseAddrs[baseIndex].addWrapSpace(offset);
    }

    public synchronized long getKey(Address addr) {
        return this.mapIdBits | (long)this.getBaseAddressIndex(addr) << 32 | addr.getOffset() & 0xFFFFFFFFL;
    }

    public int findKeyRange(List<KeyRange> keyRangeList, Address addr) {
        if (addr == null) {
            return -1;
        }
        return Collections.binarySearch(keyRangeList, addr, this.addressInsertionKeyRangeComparator);
    }

    public List<KeyRange> getKeyRanges(Address start, Address end) {
        if (start.getAddressSpace() != end.getAddressSpace() || start.getOffset() > end.getOffset()) {
            throw new IllegalArgumentException();
        }
        ArrayList<KeyRange> keyRangeList = new ArrayList<KeyRange>();
        this.addKeyRanges(keyRangeList, start, end);
        return keyRangeList;
    }

    public synchronized List<KeyRange> getKeyRanges(AddressSetView set) {
        ArrayList<KeyRange> keyRangeList = new ArrayList<KeyRange>();
        if (set == null) {
            for (int i = 0; i < this.sortedBaseStartAddrs.length; ++i) {
                keyRangeList.add(new KeyRange(this.getKey(this.sortedBaseStartAddrs[i]), this.getKey(this.sortedBaseEndAddrs[i])));
            }
        } else {
            AddressRangeIterator it = set.getAddressRanges();
            while (it.hasNext()) {
                AddressRange range = (AddressRange)it.next();
                this.addKeyRanges(keyRangeList, range.getMinAddress(), range.getMaxAddress());
            }
        }
        return keyRangeList;
    }

    private void addKeyRanges(List<KeyRange> keyRangeList, Address start, Address end) {
        int index = Arrays.binarySearch(this.sortedBaseStartAddrs, start);
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            ++index;
        }
        while (index < this.sortedBaseStartAddrs.length && end.compareTo(this.sortedBaseStartAddrs[index]) >= 0) {
            Address addr2;
            Address addr1 = this.max(start, this.sortedBaseStartAddrs[index]);
            if (addr1.compareTo(addr2 = this.min(end, this.sortedBaseEndAddrs[index])) <= 0) {
                keyRangeList.add(new KeyRange(this.getKey(addr1), this.getKey(addr2)));
            }
            ++index;
        }
    }

    private Address min(Address a1, Address a2) {
        return a1.compareTo(a2) < 0 ? a1 : a2;
    }

    private Address max(Address a1, Address a2) {
        return a1.compareTo(a2) < 0 ? a2 : a1;
    }

    public void reconcile() {
        AddressSpace curSpace;
        if (this.addrFactory == null) {
            return;
        }
        HashMap<String, OverlayAddressSpace> remapSpaces = new HashMap<String, OverlayAddressSpace>();
        Iterator<String> iter = this.spaceMap.keySet().iterator();
        while (iter.hasNext()) {
            AddressSpace curSpace2;
            String key = iter.next();
            AddressSpace space = this.spaceMap.get(key);
            if (space instanceof ObsoleteOverlaySpace) {
                OverlayAddressSpace oldOverlaySpace = ((ObsoleteOverlaySpace)space).getOriginalSpace();
                curSpace = this.addrFactory.getAddressSpace(oldOverlaySpace.getName());
                if (curSpace == null || !curSpace.equals(oldOverlaySpace)) continue;
                remapSpaces.put(space.getName(), (OverlayAddressSpace)curSpace);
                iter.remove();
                continue;
            }
            if (!(space instanceof OverlayAddressSpace) || (curSpace2 = this.addrFactory.getAddressSpace(space.getName())) != null && curSpace2.equals(space)) continue;
            ObsoleteOverlaySpace obsoleteSpace = new ObsoleteOverlaySpace((OverlayAddressSpace)space);
            remapSpaces.put(space.getName(), obsoleteSpace);
            iter.remove();
        }
        for (AddressSpace space : remapSpaces.values()) {
            this.spaceMap.put(space.getName(), space);
        }
        for (int i = 0; i < this.baseAddrs.length; ++i) {
            Address addr = this.baseAddrs[i];
            AddressSpace space = addr.getAddressSpace();
            curSpace = (OverlayAddressSpace)remapSpaces.get(space.getName());
            if (curSpace == null) continue;
            this.baseAddrs[i] = ((OverlayAddressSpace)curSpace).getAddressInThisSpaceOnly(addr.getOffset());
        }
        this.init();
    }

    private static class ObsoleteOverlaySpace
    extends OverlayAddressSpace {
        private final OverlayAddressSpace originalSpace;
        private String name;

        ObsoleteOverlaySpace(OverlayAddressSpace ovSpace) {
            super(ovSpace.getOverlayedSpace(), ovSpace.getUnique(), ObsoleteOverlaySpace.createName(ovSpace));
            this.originalSpace = ovSpace;
            this.name = ObsoleteOverlaySpace.createName(ovSpace);
        }

        private static String createName(OverlayAddressSpace ovSpace) {
            return "DELETED_" + ovSpace.getName() + "_" + ovSpace.getSpaceID();
        }

        OverlayAddressSpace getOriginalSpace() {
            return this.originalSpace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean contains(long offset) {
            return false;
        }

        @Override
        public AddressSetView getOverlayAddressSet() {
            return new AddressSet();
        }
    }
}

