/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import generic.hash.SimpleCRC32;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Iterator;

public class DataTypeSymbol {
    private Symbol sym = null;
    private DataType datatype;
    private String nmroot;
    private String category;

    public DataTypeSymbol(DataType dt, String nr, String cat) {
        this.datatype = dt;
        this.nmroot = nr;
        this.category = cat;
    }

    public Symbol getSymbol() {
        return this.sym;
    }

    public Address getAddress() {
        return this.sym.getAddress();
    }

    public DataType getDataType() {
        return this.datatype;
    }

    private String buildHashedDataType(DataTypeManager dtmanage) {
        if (this.datatype instanceof FunctionSignature) {
            if (dtmanage.contains(this.datatype)) {
                return null;
            }
        } else {
            if (!dtmanage.contains(this.datatype)) {
                return null;
            }
            this.datatype = new TypedefDataType("mytypedef", this.datatype);
        }
        CategoryPath path = new CategoryPath(this.category);
        int hash = DataTypeSymbol.generateHash(this.datatype);
        for (int i = 0; i < 256; ++i) {
            String hashString = Integer.toHexString(hash + i);
            String type_hashname = "dt_" + hashString;
            try {
                this.datatype.setNameAndCategory(path, type_hashname);
            }
            catch (InvalidNameException e) {
                return null;
            }
            catch (DuplicateNameException e) {
                return null;
            }
            DataType preexists = dtmanage.getDataType(path, type_hashname);
            if (preexists == null) {
                this.datatype = dtmanage.addDataType(this.datatype, DataTypeConflictHandler.KEEP_HANDLER);
                return hashString;
            }
            if (!preexists.isEquivalent(this.datatype)) continue;
            this.datatype = preexists;
            return hashString;
        }
        return null;
    }

    private String buildSymbolName(String hash, Address addr) {
        return this.nmroot + "_" + Long.toHexString(addr.getOffset()) + "_" + hash;
    }

    public void writeSymbol(SymbolTable symtab, Address addr, Namespace namespace, DataTypeManager dtmanage, boolean clearold) throws InvalidInputException {
        String hash;
        if (clearold) {
            DataTypeSymbol.deleteSymbols(this.nmroot, addr, symtab, namespace);
        }
        if ((hash = this.buildHashedDataType(dtmanage)) == null) {
            throw new InvalidInputException("Unable to create datatype associated with symbol");
        }
        String symname = this.buildSymbolName(hash, addr);
        HighFunction.createLabelSymbol(symtab, addr, symname, namespace, SourceType.USER_DEFINED, false);
    }

    public static void deleteSymbols(String nmroot, Address addr, SymbolTable symtab, Namespace space) throws InvalidInputException {
        ArrayList<Symbol> dellist = new ArrayList<Symbol>();
        for (Symbol sym : symtab.getSymbols(addr)) {
            if (!sym.getName().startsWith(nmroot) || sym.getSymbolType() != SymbolType.LABEL || space.equals(sym.getParentNamespace())) continue;
            if (sym.hasReferences()) {
                throw new InvalidInputException("DataTypeSymbol has a reference");
            }
            dellist.add(sym);
        }
        for (Symbol s : dellist) {
            s.delete();
        }
    }

    public void cleanupUnusedOverride() {
        Symbol s;
        String n;
        if (this.sym == null) {
            throw new RuntimeException("not instantiated with readSymbol method");
        }
        String overrideName = this.sym.getName();
        Program program = this.sym.getProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        String prefix = this.nmroot + "_";
        String hashSuffix = "_" + DataTypeSymbol.extractHash(overrideName);
        Iterator iterator = symbolTable.scanSymbolsByName(prefix).iterator();
        while (iterator.hasNext() && (n = (s = (Symbol)iterator.next()).getName()).startsWith(prefix)) {
            if (s.getSymbolType() != SymbolType.LABEL || !n.endsWith(hashSuffix) || !HighFunction.isOverrideNamespace(s.getParentNamespace())) continue;
            return;
        }
        program.getDataTypeManager().remove(this.getDataType());
    }

    public static DataTypeSymbol readSymbol(String cat, Symbol s) {
        if (s.getSymbolType() != SymbolType.LABEL) {
            throw new IllegalArgumentException("Expected CODE symbol");
        }
        String hash = DataTypeSymbol.extractHash(s.getName());
        String nmr = DataTypeSymbol.extractNameRoot(s.getName());
        if (hash == null) {
            return null;
        }
        ProgramBasedDataTypeManager dtmanage = s.getProgram().getDataTypeManager();
        DataType dt = dtmanage.getDataType(new CategoryPath(cat), "dt_" + hash);
        if (dt == null) {
            return null;
        }
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (!(dt instanceof FunctionSignature)) {
            return null;
        }
        DataTypeSymbol res = new DataTypeSymbol(dt, nmr, cat);
        res.sym = s;
        return res;
    }

    public static int generateHash(DataType dt) {
        String material = dt instanceof FunctionSignature ? ((FunctionSignature)((Object)dt)).getPrototypeString(true) : (dt instanceof TypeDef ? ((TypeDef)dt).getDataType().getPathName() : null);
        int hash = 315593131;
        if (material != null) {
            for (int i = 0; i < material.length(); ++i) {
                hash = SimpleCRC32.hashOneByte((int)hash, (int)material.charAt(i));
            }
        }
        return hash;
    }

    public static String extractHash(String symname) {
        int last = symname.lastIndexOf(95);
        if (last < 0) {
            return null;
        }
        return symname.substring(last + 1);
    }

    public static String extractNameRoot(String symname) {
        int first = symname.indexOf(95);
        if (first < 0) {
            return "";
        }
        return symname.substring(0, first);
    }
}

