/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint.state;

import ghidra.pcode.emu.taint.TaintPcodeArithmetic;
import ghidra.pcode.emu.taint.state.TaintSpace;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.taint.model.TaintVec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaintPcodeExecutorStatePiece
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], TaintVec, TaintSpace> {
    protected final Map<AddressSpace, TaintSpace> spaceMap = new HashMap<AddressSpace, TaintSpace>();

    public TaintPcodeExecutorStatePiece(Language language, PcodeArithmetic<byte[]> addressArithmetic, PcodeArithmetic<TaintVec> arithmetic, PcodeStateCallbacks cb) {
        super(language, addressArithmetic, arithmetic, cb);
    }

    public TaintPcodeExecutorStatePiece(Language language, PcodeArithmetic<byte[]> addressArithmetic, PcodeStateCallbacks cb) {
        super(language, addressArithmetic, (PcodeArithmetic)TaintPcodeArithmetic.forLanguage(language), cb);
    }

    public TaintPcodeExecutorStatePiece fork(PcodeStateCallbacks cb) {
        throw new UnsupportedOperationException();
    }

    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make Taint concrete", purpose);
    }

    protected TaintSpace getForSpace(AddressSpace space, boolean toWrite) {
        if (toWrite) {
            return this.spaceMap.computeIfAbsent(space, s -> new TaintSpace(space, this));
        }
        return this.spaceMap.get(space);
    }

    protected void setInSpace(TaintSpace space, long offset, int size, TaintVec val, PcodeStateCallbacks cb) {
        space.set(offset, val, cb);
    }

    protected TaintVec getFromSpace(TaintSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        return space.get(offset, size, cb);
    }

    protected Map<Register, TaintVec> getRegisterValuesFromSpace(TaintSpace space, List<Register> registers) {
        return space.getRegisterValues(registers);
    }

    public void clear() {
        for (TaintSpace space : this.spaceMap.values()) {
            space.clear();
        }
    }

    public Map.Entry<Long, TaintVec> getNextEntryInternal(AddressSpace space, long offset) {
        TaintSpace s = this.getForSpace(space, false);
        if (s == null) {
            return null;
        }
        return s.getNextEntry(offset);
    }
}

