/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.util.VertexLocationAnimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimatedPickingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(AnimatedPickingGraphMousePlugin.class);
    protected V vertex;
    protected int selectionModifiers;

    public AnimatedPickingGraphMousePlugin() {
        this(1152);
    }

    public AnimatedPickingGraphMousePlugin(int selectionModifiers) {
        this.selectionModifiers = selectionModifiers;
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.trace("mousePressed in {}", (Object)this.getClass().getName());
        if (e.getModifiersEx() == this.selectionModifiers) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            MutableSelectedState pickedVertexState = vv.getSelectedVertexState();
            if (pickSupport != null && pickedVertexState != null) {
                Point p = e.getPoint();
                this.vertex = pickSupport.getVertex(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
                if (this.vertex != null) {
                    pickedVertexState.select(this.vertex);
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        log.trace("mouseReleased in {}", (Object)this.getClass().getName());
        if (e.getModifiersEx() == 128) {
            VertexLocationAnimator.scrollVertexToCenter((VisualizationViewer)e.getSource(), this.vertex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }
}

