/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.graphanalysis;

import ghidra.features.codecompare.graphanalysis.DataGraph;
import ghidra.features.codecompare.graphanalysis.DataNGram;
import ghidra.features.codecompare.graphanalysis.Pinning;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import java.util.ArrayList;

public class DataVertex {
    int uid;
    PcodeOpAST op;
    VarnodeAST vn;
    DataGraph graph;
    ArrayList<DataVertex> sources;
    ArrayList<DataVertex> sinks;
    ArrayList<DataNGram> ngrams;
    int passComplete;
    boolean paired;

    public DataVertex(PcodeOpAST myOp, DataGraph myGraph, int uniqueID) {
        this.op = myOp;
        this.vn = null;
        this.commonConstructor(myGraph, uniqueID);
    }

    public DataVertex(VarnodeAST myVn, DataGraph myGraph, int uniqueID) {
        this.vn = myVn;
        this.op = null;
        this.commonConstructor(myGraph, uniqueID);
    }

    private void commonConstructor(DataGraph myGraph, int uniqueID) {
        this.uid = uniqueID * 2 + myGraph.side.getValue();
        this.graph = myGraph;
        this.sources = new ArrayList();
        this.sinks = new ArrayList();
        this.ngrams = new ArrayList();
        int hash = this.depthZeroHash();
        this.ngrams.add(new DataNGram(this, 1, 0, hash));
        this.paired = false;
        this.passComplete = -1;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("uid=").append(this.uid).append(' ');
        if (this.op != null) {
            int i;
            for (i = 0; i < this.sinks.size(); ++i) {
                buffer.append('[').append(this.sinks.get((int)i).uid).append("] = ");
            }
            buffer.append(this.op.getMnemonic());
            for (i = 0; i < this.sources.size(); ++i) {
                buffer.append(" [").append(this.sources.get((int)i).uid).append(']');
            }
        } else {
            buffer.append(this.vn.toString());
        }
        return buffer.toString();
    }

    void collapse() {
        this.sinks.clear();
        this.sources.clear();
        this.ngrams.clear();
    }

    public int hashCode() {
        return this.uid;
    }

    private int depthZeroHash() {
        int encoding = 0;
        if (this.op != null) {
            encoding = this.op.getOpcode() == 66 ? 19 : this.op.getOpcode();
            encoding |= 0xC0000000;
        } else {
            VarnodeAST node = this.vn;
            int ramCode = (this.graph.ramCaring ? 1 : 0) * (node.isPersistent() ? 1 : 0);
            int constCode = node.isConstant() ? 1 : 0;
            int size = node.getSize();
            if (this.graph.sizeCollapse && size > 4) {
                size = 4;
            }
            int sizeCode = size << 4 >> 4;
            encoding |= ramCode << 29;
            encoding |= constCode << 28;
            encoding |= sizeCode;
            encoding |= Integer.MIN_VALUE;
            if (this.graph.constCaring && this.graph.isConstantNonPointer((Varnode)node)) {
                return Pinning.hashTwo(encoding, (int)node.getOffset());
            }
        }
        return Pinning.hashTwo(encoding, 0);
    }

    void nextNGramSource(int index) {
        int finalHash;
        int nextSize = 1;
        DataNGram zeroGram = this.ngrams.get(0);
        if (this.isCommutative()) {
            finalHash = 0;
            for (DataVertex neighbor : this.sources) {
                DataNGram gram = neighbor.ngrams.get(index);
                finalHash += gram.hash;
                nextSize += gram.weight;
            }
            finalHash = Pinning.hashTwo(zeroGram.hash, finalHash);
        } else {
            finalHash = zeroGram.hash;
            for (DataVertex neighbor : this.sources) {
                DataNGram gram = neighbor.ngrams.get(index);
                finalHash = Pinning.hashTwo(finalHash, gram.hash);
                nextSize += gram.weight;
            }
        }
        this.ngrams.add(new DataNGram(this, nextSize, this.ngrams.size(), finalHash));
    }

    public boolean isOp() {
        return this.op != null;
    }

    public boolean isCollapsed() {
        return this.ngrams.size() == 0;
    }

    public boolean isCommutative() {
        if (this.op == null) {
            return false;
        }
        int opc = this.op.getOpcode();
        if (opc == 60) {
            return true;
        }
        return PcodeOp.isCommutative((int)opc);
    }
}

