/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public interface ColorsModified<P extends JComponent> {
    public Color getDiffForeground(P var1);

    public Color getDiffSelForeground(P var1);

    public Color getForeground(P var1);

    public Color getSelForeground(P var1);

    default public Color getForegroundFor(P p, boolean isModified, boolean isSelected) {
        return isModified ? (isSelected ? this.getDiffSelForeground(p) : this.getDiffForeground(p)) : (isSelected ? this.getSelForeground(p) : this.getForeground(p));
    }

    public static interface InTree
    extends ColorsModified<JTree>,
    TreeCellRenderer {
        public Color getTextNonSelectionColor();

        public Color getTextSelectionColor();

        @Override
        default public Color getForeground(JTree tree) {
            return this.getTextNonSelectionColor();
        }

        @Override
        default public Color getSelForeground(JTree tree) {
            return this.getTextSelectionColor();
        }
    }

    public static interface InTable
    extends ColorsModified<JTable> {
        @Override
        default public Color getForeground(JTable table) {
            return table.getForeground();
        }

        @Override
        default public Color getSelForeground(JTable table) {
            return table.getSelectionForeground();
        }
    }
}

