/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.mm;

import com.google.gson.JsonElement;
import generic.stl.Pair;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.mm.ExtMemoryMap;
import sarif.managers.MemoryMapBytesFile;
import sarif.managers.MemoryMapSarifMgr;

public class SarifMemoryMapWriter
extends AbstractExtWriter {
    private List<Pair<AddressRange, MemoryBlock>> memory;
    private MemoryMapBytesFile bytesFile;
    private boolean write;

    public SarifMemoryMapWriter(List<Pair<AddressRange, MemoryBlock>> request, Writer baseWriter, MemoryMapBytesFile bytes, boolean isWriteContents) throws IOException {
        super(baseWriter);
        this.memory = request;
        this.bytesFile = bytes;
        this.write = isWriteContents;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genMaps(monitor);
        this.root.add("memory", (JsonElement)this.objects);
    }

    private void genMaps(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.memory.size());
        for (Pair<AddressRange, MemoryBlock> m : this.memory) {
            AddressRange range = (AddressRange)m.first;
            ExtMemoryMap isf = new ExtMemoryMap((AddressRange)m.first, (MemoryBlock)m.second, this.bytesFile, this.write);
            SarifObject sarif = new SarifObject(MemoryMapSarifMgr.SUBKEY, MemoryMapSarifMgr.KEY, this.getTree(isf), range.getMinAddress(), range.getMaxAddress());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

