/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.data;

import ghidra.pcode.exec.trace.data.InternalPcodeTraceDataAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.trace.model.property.TracePropertyMapOperations;
import ghidra.trace.model.property.TracePropertyMapSpace;
import java.util.Map;

public class DefaultPcodeTracePropertyAccess<T>
implements PcodeTracePropertyAccess<T> {
    protected final InternalPcodeTraceDataAccess data;
    protected final String name;
    protected final Class<T> type;
    protected TracePropertyMapOperations<T> po;

    protected DefaultPcodeTracePropertyAccess(InternalPcodeTraceDataAccess data, String name, Class<T> type) {
        this.data = data;
        this.name = name;
        this.type = type;
        this.po = data.getPropertyOps(name, type, false);
    }

    @Override
    public Language getLanguage() {
        return this.data.getLanguage();
    }

    protected TracePropertyMapOperations<T> getPropertyOperations(boolean createIfAbsent) {
        if (this.po == null) {
            this.po = this.data.getPropertyOps(this.name, this.type, createIfAbsent);
            return this.po;
        }
        return this.po;
    }

    protected T whenNull(Address hostAddress) {
        return null;
    }

    @Override
    public T get(Address address) {
        Address hostAddr = this.data.getPlatform().mapGuestToHost(address);
        if (hostAddr == null) {
            return null;
        }
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(false);
        if (ops == null) {
            return this.whenNull(hostAddr);
        }
        Address overlayAddr = this.toOverlay(ops, hostAddr);
        return ops.get(this.data.getSnap(), overlayAddr);
    }

    @Override
    public Map.Entry<AddressRange, T> getEntry(Address address) {
        Address hostAddr = this.data.getPlatform().mapGuestToHost(address);
        if (hostAddr == null) {
            return null;
        }
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(false);
        if (ops == null) {
            return null;
        }
        Address overlayAddr = this.toOverlay(ops, hostAddr);
        Map.Entry<TraceAddressSnapRange, T> entry = ops.getEntry(this.data.getSnap(), overlayAddr);
        return entry == null ? null : Map.entry(entry.getKey().getRange(), entry.getValue());
    }

    @Override
    public void put(Address address, T value) {
        Address hostAddr = this.data.getPlatform().mapGuestToHost(address);
        if (hostAddr == null) {
            return;
        }
        Lifespan span = Lifespan.nowOnMaybeScratch(this.data.getSnap());
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(true);
        if (value == null) {
            if (ops == null) {
                return;
            }
            ops.clear(span, this.toOverlay(ops, (AddressRange)new AddressRangeImpl(hostAddr, hostAddr)));
        } else {
            ops.set(span, this.toOverlay(ops, hostAddr), value);
        }
    }

    @Override
    public void put(AddressRange range, T value) {
        AddressRange hostRange = this.data.getPlatform().mapGuestToHost(range);
        if (hostRange == null) {
            return;
        }
        Lifespan span = Lifespan.nowOnMaybeScratch(this.data.getSnap());
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(true);
        if (value == null) {
            if (ops == null) {
                return;
            }
            ops.clear(span, this.toOverlay(ops, hostRange));
        } else {
            ops.set(span, this.toOverlay(ops, hostRange), value);
        }
    }

    @Override
    public void clear(AddressRange range) {
        this.put(range, null);
    }

    @Override
    public boolean hasSpace(AddressSpace space) {
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(false);
        if (ops == null) {
            return false;
        }
        if (ops instanceof TracePropertyMapSpace) {
            TracePropertyMapSpace propSpace = (TracePropertyMapSpace)ops;
            return propSpace.getAddressSpace() == space;
        }
        if (ops instanceof TracePropertyMap) {
            TracePropertyMap propMap = (TracePropertyMap)ops;
            return propMap.getPropertyMapSpace(space, false) != null;
        }
        throw new AssertionError();
    }

    protected Address toOverlay(TracePropertyMapOperations<T> ops, Address address) {
        if (ops instanceof TracePropertyMap) {
            return address;
        }
        if (ops instanceof TracePropertyMapSpace) {
            TracePropertyMapSpace mapSpace = (TracePropertyMapSpace)ops;
            return mapSpace.getAddressSpace().getOverlayAddress(address);
        }
        throw new AssertionError();
    }

    protected AddressRange toOverlay(TracePropertyMapOperations<T> ops, AddressRange range) {
        if (ops instanceof TracePropertyMap) {
            return range;
        }
        if (ops instanceof TracePropertyMapSpace) {
            TracePropertyMapSpace mapSpace = (TracePropertyMapSpace)ops;
            AddressSpace space = mapSpace.getAddressSpace();
            return new AddressRangeImpl(space.getOverlayAddress(range.getMinAddress()), space.getOverlayAddress(range.getMaxAddress()));
        }
        throw new AssertionError();
    }
}

