/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.data;

import db.DBHandle;
import db.DBRecord;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.data.DBTraceDataSettingsOperations;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceDataSettingsAdapter
extends DBTraceAddressSnapRangePropertyMap<DBTraceSettingsEntry, DBTraceSettingsEntry>
implements DBTraceDataSettingsOperations {
    public static final String NAME = "DataSettings";

    public DBTraceDataSettingsAdapter(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceSettingsEntry.class, DBTraceSettingsEntry::new);
    }

    @Override
    protected DBTraceDataSettingsSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceDataSettingsSpace(this, this.tableName(space), this.trace, this.trace.getStoreFactory(), this.lock, space, this.dataType, this.dataFactory);
    }

    @Override
    public DBTraceDataSettingsSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceDataSettingsSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceDataSettingsSpace getRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceDataSettingsSpace)super.getRegisterSpace(thread, createIfAbsent);
    }

    @Override
    public void makeWay(DBTraceSettingsEntry entry, Lifespan span) {
        DBTraceUtils.makeWay(entry, span, (e, s) -> e.setLifespan((Lifespan)s), e -> this.deleteData(e));
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceSettingsEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceSettingsEntry> {
        static final String NAME_COLUMN_NAME = "Name";
        static final String LONG_VALUE_COLUMN_NAME = "LongValue";
        static final String STRING_VALUE_COLUMN_NAME = "StringValue";
        static final String BYTES_VALUE_COLUMN_NAME = "BytesValue";
        @DBAnnotatedColumn(value="Name")
        static DBObjectColumn NAME_COLUMN;
        @DBAnnotatedColumn(value="LongValue")
        static DBObjectColumn LONG_VALUE_COLUMN;
        @DBAnnotatedColumn(value="StringValue")
        static DBObjectColumn STRING_VALUE_COLUMN;
        @DBAnnotatedColumn(value="BytesValue")
        static DBObjectColumn BYTES_VALUE_COLUMN;
        @DBAnnotatedField(column="Name")
        String name;
        @DBAnnotatedField(column="LongValue")
        long longValue;
        @DBAnnotatedField(column="StringValue")
        String stringValue;
        @DBAnnotatedField(column="BytesValue")
        byte[] bytesValue;

        public DBTraceSettingsEntry(DBTraceAddressSnapRangePropertyMapTree<DBTraceSettingsEntry, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(DBTraceSettingsEntry value) {
        }

        protected DBTraceSettingsEntry getRecordValue() {
            return this;
        }

        void setName(String name) {
            this.name = name;
            this.update(NAME_COLUMN);
        }

        void setLong(long value) {
            this.longValue = value;
            this.stringValue = null;
            this.bytesValue = null;
            this.update(LONG_VALUE_COLUMN, STRING_VALUE_COLUMN, BYTES_VALUE_COLUMN);
        }

        Long getLong() {
            if (this.stringValue != null || this.bytesValue != null) {
                return null;
            }
            return this.longValue;
        }

        void setString(String value) {
            this.longValue = 0L;
            this.stringValue = value;
            this.bytesValue = null;
            this.update(LONG_VALUE_COLUMN, STRING_VALUE_COLUMN, BYTES_VALUE_COLUMN);
        }

        String getString() {
            return this.stringValue;
        }

        void setBytes(byte[] value) {
            this.longValue = 0L;
            this.stringValue = null;
            this.bytesValue = value;
            this.update(LONG_VALUE_COLUMN, STRING_VALUE_COLUMN, BYTES_VALUE_COLUMN);
        }

        byte[] getBytes() {
            return this.bytesValue;
        }

        void setValue(Object obj) {
            if (obj instanceof Long) {
                this.setLong((Long)obj);
            } else if (obj instanceof String) {
                this.setString((String)obj);
            } else if (obj instanceof byte[]) {
                this.setBytes((byte[])obj);
            } else {
                throw new AssertionError();
            }
        }

        Object getValue() {
            if (this.stringValue != null) {
                return this.stringValue;
            }
            if (this.bytesValue != null) {
                return this.bytesValue;
            }
            return this.longValue;
        }

        protected void setLifespan(Lifespan lifespan) {
            super.doSetLifespan(lifespan);
        }
    }

    public class DBTraceDataSettingsSpace
    extends DBTraceAddressSnapRangePropertyMapSpace<DBTraceSettingsEntry, DBTraceSettingsEntry>
    implements DBTraceDataSettingsOperations {
        public DBTraceDataSettingsSpace(DBTraceDataSettingsAdapter this$0, String tableName, DBTrace trace, DBCachedObjectStoreFactory storeFactory, ReadWriteLock lock, AddressSpace space, Class<DBTraceSettingsEntry> dataType, DBTraceAddressSnapRangePropertyMap.DBTraceAddressSnapRangePropertyMapDataFactory<DBTraceSettingsEntry, DBTraceSettingsEntry> dataFactory) throws VersionException, IOException {
            super(tableName, trace, storeFactory, lock, space, dataType, dataFactory);
        }

        @Override
        public void makeWay(DBTraceSettingsEntry entry, Lifespan span) {
            DBTraceUtils.makeWay(entry, span, (e, s) -> e.setLifespan((Lifespan)s), e -> this.deleteData(e));
        }

        @Override
        public ReadWriteLock getLock() {
            return this.lock;
        }
    }
}

