/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import generic.util.FlattenedIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import java.util.Iterator;

public abstract class AbstractBaseDBTraceCodeUnitsView<T extends DBTraceCodeUnitAdapter> {
    protected final DBTraceCodeSpace space;

    public AbstractBaseDBTraceCodeUnitsView(DBTraceCodeSpace space) {
        this.space = space;
    }

    public AddressSpace getSpace() {
        return this.getAddressSpace();
    }

    protected AddressSpace getAddressSpace() {
        return this.space.space;
    }

    public Trace getTrace() {
        return this.space.manager.getTrace();
    }

    public abstract int size();

    public T getBefore(long snap, Address address) {
        Address previous = address.previous();
        if (previous == null) {
            return null;
        }
        return this.getFloor(snap, previous);
    }

    public abstract T getFloor(long var1, Address var3);

    public abstract T getContaining(long var1, Address var3);

    public abstract T getAt(long var1, Address var3);

    public abstract T getCeiling(long var1, Address var3);

    public T getAfter(long snap, Address address) {
        Address next = address.next();
        if (next == null) {
            return null;
        }
        return this.getCeiling(snap, next);
    }

    public abstract Iterable<? extends T> get(long var1, Address var3, Address var4, boolean var5);

    public abstract Iterable<? extends T> getIntersecting(TraceAddressSnapRange var1);

    public Iterable<? extends T> get(long snap, AddressSetView set, boolean forward) {
        return () -> FlattenedIterator.start((Iterator)set.iterator(forward), r -> this.get(snap, (AddressRange)r, forward).iterator());
    }

    public Iterable<? extends T> get(long snap, AddressRange range, boolean forward) {
        return this.get(snap, range.getMinAddress(), range.getMaxAddress(), forward);
    }

    public Iterable<? extends T> get(long snap, Address start, boolean forward) {
        return forward ? this.get(snap, start, this.getAddressSpace().getMaxAddress(), forward) : this.get(snap, this.getAddressSpace().getMinAddress(), start, forward);
    }

    public Iterable<? extends T> get(long snap, boolean forward) {
        return this.get(snap, this.getAddressSpace().getMinAddress(), this.getAddressSpace().getMaxAddress(), forward);
    }

    public abstract AddressSetView getAddressSetView(long var1, AddressRange var3);

    public AddressSetView getAddressSetView(long snap) {
        return this.getAddressSetView(snap, this.space.all);
    }

    public abstract boolean containsAddress(long var1, Address var3);

    public abstract boolean coversRange(Lifespan var1, AddressRange var2);

    public boolean coversRange(TraceAddressSnapRange range) {
        return this.coversRange(range.getLifespan(), range.getRange());
    }

    public abstract boolean intersectsRange(Lifespan var1, AddressRange var2);

    public boolean intersectsRange(TraceAddressSnapRange range) {
        return this.intersectsRange(range.getLifespan(), range.getRange());
    }
}

