/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.MemBufferMixin;
import ghidra.program.model.mem.Memory;
import ghidra.trace.database.DBTrace;
import ghidra.util.MathUtilities;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class DBTraceEmptyMemBuffer
implements MemBufferMixin {
    private final DBTrace trace;
    private final Address start;
    private final ByteOrder byteOrder;

    public DBTraceEmptyMemBuffer(DBTrace trace, Address start, ByteOrder byteOrder) {
        this.trace = trace;
        this.start = start;
        this.byteOrder = byteOrder;
    }

    public Address getAddress() {
        return this.start;
    }

    public Memory getMemory() {
        return this.trace.getProgramView().getMemory();
    }

    public boolean isBigEndian() {
        return this.byteOrder == ByteOrder.BIG_ENDIAN;
    }

    public int getBytes(ByteBuffer buffer, int offset) {
        try {
            long toRead = this.start.getAddressSpace().getMaxAddress().subtract(this.start.addNoWrap((long)offset)) + 1L;
            toRead = MathUtilities.unsignedMin((long)toRead, (int)buffer.remaining());
            toRead = MathUtilities.unsignedMin((long)toRead, (int)Integer.MAX_VALUE);
            int result = (int)toRead;
            int end = buffer.position() + result;
            Arrays.fill(buffer.array(), buffer.position(), end, (byte)0);
            return result;
        }
        catch (AddressOverflowException e) {
            return 0;
        }
    }
}

