/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.trace.model.memory.RegisterValueException;
import ghidra.trace.model.target.TraceObjectValue;
import java.math.BigInteger;

public class RegisterValueConverter {
    private final TraceObjectValue registerValue;
    private BigInteger value;
    private int bitLength = -1;
    private byte[] be;
    private byte[] le;

    public RegisterValueConverter(TraceObjectValue registerValue) {
        this.registerValue = registerValue;
    }

    public static BigInteger convertValueToBigInteger(Object val) throws RegisterValueException {
        if (val instanceof String) {
            String s = (String)val;
            try {
                return new BigInteger(s, 16);
            }
            catch (NumberFormatException e) {
                throw new RegisterValueException("Invalid register value " + s + ". Must be hex digits only.");
            }
        }
        if (val instanceof byte[]) {
            byte[] arr = (byte[])val;
            return new BigInteger(1, arr);
        }
        if (val instanceof Byte) {
            Byte b = (Byte)val;
            return BigInteger.valueOf(b.byteValue());
        }
        if (val instanceof Short) {
            Short s = (Short)val;
            return BigInteger.valueOf(s.shortValue());
        }
        if (val instanceof Integer) {
            Integer i = (Integer)val;
            return BigInteger.valueOf(i.intValue());
        }
        if (val instanceof Long) {
            Long l = (Long)val;
            return BigInteger.valueOf(l);
        }
        if (val instanceof Address) {
            Address a = (Address)val;
            return a.getOffsetAsBigInteger();
        }
        throw new RegisterValueException("Cannot convert register value: (" + String.valueOf(val.getClass()) + ") '" + String.valueOf(val) + "'");
    }

    BigInteger convertRegisterValueToBigInteger() throws RegisterValueException {
        return RegisterValueConverter.convertValueToBigInteger(this.registerValue.getValue());
    }

    int getRegisterValueBitLength() throws RegisterValueException {
        Object objBitLength = this.registerValue.getParent().getValue(this.registerValue.getMinSnap(), "_length").getValue();
        if (!(objBitLength instanceof Number)) {
            throw new RegisterValueException("Register length is not numeric: (" + String.valueOf(objBitLength.getClass()) + ") '" + String.valueOf(objBitLength) + "'");
        }
        Number numBitLength = (Number)objBitLength;
        return numBitLength.intValue();
    }

    public BigInteger getValue() throws RegisterValueException {
        if (this.value != null) {
            return this.value;
        }
        this.value = this.convertRegisterValueToBigInteger();
        return this.value;
    }

    int getBitLength() throws RegisterValueException {
        if (this.bitLength != -1) {
            return this.bitLength;
        }
        this.bitLength = this.getRegisterValueBitLength();
        return this.bitLength;
    }

    int getByteLength() throws RegisterValueException {
        return (this.getBitLength() + 7) / 8;
    }

    public byte[] getBytesBigEndian() throws RegisterValueException {
        if (this.be != null) {
            return this.be;
        }
        this.be = Utils.bigIntegerToBytes((BigInteger)this.getValue(), (int)this.getByteLength(), (boolean)true);
        return this.be;
    }

    public byte[] getBytesLittleEndian() throws RegisterValueException {
        if (this.le != null) {
            return this.le;
        }
        this.le = Utils.bigIntegerToBytes((BigInteger)this.getValue(), (int)this.getByteLength(), (boolean)false);
        return this.le;
    }

    public byte[] getBytes(boolean isBigEndian) throws RegisterValueException {
        return isBigEndian ? this.getBytesBigEndian() : this.getBytesLittleEndian();
    }
}

