/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.gen.FieldForUserop;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitCallOtherDefOp;
import ghidra.pcode.emu.jit.op.JitCallOtherOpIf;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public enum CallOtherOpGen implements OpGen<JitCallOtherOpIf>
{
    GEN;


    public static void generateRunCodeUsingRetirementStrategy(JitCodeGenerator gen, PcodeOp op, JitControlFlowModel.JitBlock block, PcodeUseropLibrary.PcodeUseropDefinition<?> userop, MethodVisitor rv) {
        VarGen.BlockTransition transition = VarGen.computeBlockTransition(gen, block, null);
        transition.generate(rv);
        gen.generateRetirePcCtx(() -> rv.visitLdcInsn((Object)gen.getAddressForOp(op).getOffset()), gen.getExitContext(op), JitCodeGenerator.RetireMode.SET, rv);
        JitAllocationModel.RunFixedLocal.THIS.generateLoadCode(rv);
        gen.requestFieldForUserop(userop).generateLoadCode(gen, rv);
        if (op.getOutput() == null) {
            rv.visitInsn(1);
        } else {
            gen.requestStaticFieldForVarnode(op.getOutput()).generateLoadCode(gen, rv);
        }
        rv.visitLdcInsn((Object)(op.getNumInputs() - 1));
        rv.visitTypeInsn(189, GenConsts.NAME_VARNODE);
        for (int i = 1; i < op.getNumInputs(); ++i) {
            rv.visitInsn(89);
            rv.visitLdcInsn((Object)(i - 1));
            Varnode input = op.getInput(i);
            gen.requestStaticFieldForVarnode(input).generateLoadCode(gen, rv);
            rv.visitInsn(83);
        }
        rv.visitMethodInsn(185, GenConsts.NAME_JIT_COMPILED_PASSAGE, "invokeUserop", GenConsts.MDESC_JIT_COMPILED_PASSAGE__INVOKE_USEROP, true);
        transition.generateInv(rv);
    }

    static Parameter findOutputParameter(Parameter[] parameters, Method method) {
        List<Parameter> found = Stream.of(parameters).filter(p -> p.getAnnotation(AnnotatedPcodeUseropLibrary.OpOutput.class) != null).toList();
        return switch (found.size()) {
            case 0 -> null;
            case 1 -> {
                Parameter p = found.get(0);
                if (p.getType() == int[].class) {
                    yield p;
                }
                throw new IllegalArgumentException("@%s requires parameter to have type int[] when functional=true. Got %s (method %s)".formatted(AnnotatedPcodeUseropLibrary.OpOutput.class.getSimpleName(), p, method.getName()));
            }
            default -> throw new IllegalArgumentException("@%s can only be applied to one parameter of method %s. It is applied to: %s".formatted(AnnotatedPcodeUseropLibrary.OpOutput.class.getSimpleName(), method.getName(), found.stream().map(Parameter::toString).collect(Collectors.joining(", "))));
        };
    }

    public static void generateRunCodeUsingDirectStrategy(JitCodeGenerator gen, JitCallOtherOpIf op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        FieldForUserop useropField = gen.requestFieldForUserop(op.userop());
        Label tryStart = new Label();
        Label tryEnd = new Label();
        rv.visitTryCatchBlock(tryStart, tryEnd, gen.requestExceptionHandler((JitPassage.DecodedPcodeOp)op.op(), block).label(), GenConsts.NAME_THROWABLE);
        JitAllocationModel am = gen.getAllocationModel();
        useropField.generateLoadCode(gen, rv);
        rv.visitMethodInsn(185, GenConsts.NAME_PCODE_USEROP_DEFINITION, "getDefiningLibrary", GenConsts.MDESC_PCODE_USEROP_DEFINITION__GET_DEFINING_LIBRARY, true);
        Method method = op.userop().getJavaMethod();
        String owningLibName = Type.getInternalName(method.getDeclaringClass());
        rv.visitTypeInsn(192, owningLibName);
        Parameter[] parameters = method.getParameters();
        Parameter outputParameter = CallOtherOpGen.findOutputParameter(parameters, method);
        if (outputParameter != null && method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("@%s cannot be applied to any parameter of a method returning non-void. It's applied to %s of %s".formatted(AnnotatedPcodeUseropLibrary.OpOutput.class.getSimpleName(), outputParameter, method.getName()));
        }
        try (JitAllocationModel.JvmTempAlloc out = am.allocateTemp(rv, "out", int[].class, outputParameter == null ? 0 : 1);){
            JitType.MpIntJitType outMpType;
            if (outputParameter != null) {
                if (!(op instanceof JitCallOtherDefOp)) {
                    outMpType = null;
                    rv.visitInsn(1);
                } else {
                    JitCallOtherDefOp defOp = (JitCallOtherDefOp)op;
                    outMpType = JitType.MpIntJitType.forSize(defOp.out().size());
                    rv.visitLdcInsn((Object)outMpType.legsAlloc());
                    rv.visitIntInsn(188, 10);
                }
                rv.visitVarInsn(58, out.idx(0));
            } else {
                outMpType = null;
            }
            int argIdx = 0;
            for (int i = 0; i < parameters.length; ++i) {
                Parameter p = parameters[i];
                if (p == outputParameter) {
                    rv.visitVarInsn(25, out.idx(0));
                    continue;
                }
                JitVal arg = op.args().get(argIdx++);
                JitType type = gen.generateValReadCode(arg, JitTypeBehavior.ANY, TypeConversions.Ext.ZERO);
                if (p.getType() == Boolean.TYPE) {
                    TypeConversions.generateIntToBool(type, rv);
                    continue;
                }
                if (p.getType() == int[].class) {
                    JitType.MpIntJitType mpType = JitType.MpIntJitType.forSize(type.size());
                    TypeConversions.generate(gen, type, mpType, TypeConversions.Ext.ZERO, rv);
                    int legCount = mpType.legsAlloc();
                    try (JitAllocationModel.JvmTempAlloc temp = am.allocateTemp(rv, "temp", legCount);){
                        OpGen.generateMpLegsIntoTemp(temp, legCount, rv);
                        OpGen.generateMpLegsIntoArray(temp, legCount, legCount, rv);
                        continue;
                    }
                }
                TypeConversions.generate(gen, type, JitType.forJavaType(p.getType()), TypeConversions.Ext.ZERO, rv);
            }
            rv.visitLabel(tryStart);
            rv.visitMethodInsn(182, owningLibName, method.getName(), Type.getMethodDescriptor((Method)method), false);
            rv.visitLabel(tryEnd);
            if (outputParameter != null) {
                if (outMpType != null && op instanceof JitCallOtherDefOp) {
                    JitCallOtherDefOp defOp = (JitCallOtherDefOp)op;
                    rv.visitVarInsn(25, out.idx(0));
                    OpGen.generateMpLegsFromArray(outMpType.legsAlloc(), rv);
                    gen.generateVarWriteCode(defOp.out(), outMpType, TypeConversions.Ext.ZERO);
                }
            } else if (op instanceof JitCallOtherDefOp) {
                JitCallOtherDefOp defOp = (JitCallOtherDefOp)op;
                gen.generateVarWriteCode(defOp.out(), JitType.forJavaType(method.getReturnType()), TypeConversions.Ext.ZERO);
            } else if (method.getReturnType() != Void.TYPE) {
                TypeConversions.generatePop(JitType.forJavaType(method.getReturnType()), rv);
            }
        }
    }

    public static boolean canDoDirectInvocation(JitCallOtherOpIf op) {
        JitCallOtherDefOp defOp;
        if (!op.userop().isFunctional() || op.userop().modifiesContext()) {
            return false;
        }
        for (JitTypeBehavior type : op.inputTypes()) {
            if (type != JitTypeBehavior.ANY) continue;
            return false;
        }
        return !(op instanceof JitCallOtherDefOp) || (defOp = (JitCallOtherDefOp)op).type() != JitTypeBehavior.ANY;
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitCallOtherOpIf op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        if (op.userop().modifiesContext()) {
            rv.visitLdcInsn((Object)1);
            JitAllocationModel.RunFixedLocal.CTXMOD.generateStoreCode(rv);
        }
        if (CallOtherOpGen.canDoDirectInvocation(op)) {
            CallOtherOpGen.generateRunCodeUsingDirectStrategy(gen, op, block, rv);
        } else {
            CallOtherOpGen.generateRunCodeUsingRetirementStrategy(gen, op.op(), block, op.userop(), rv);
        }
    }

    static class ResourceGroup
    implements AutoCloseable {
        private final List<AutoCloseable> resources = new ArrayList<AutoCloseable>();

        ResourceGroup() {
        }

        @Override
        public void close() throws Exception {
            for (AutoCloseable r : this.resources) {
                r.close();
            }
        }

        public <T extends AutoCloseable> T add(T resource) {
            this.resources.add(resource);
            return resource;
        }
    }
}

