/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntUnOpGen;
import ghidra.pcode.emu.jit.op.JitPopCountOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum PopCountOpGen implements IntUnOpGen<JitPopCountOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return false;
    }

    private void generateMpIntPopCount(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        mv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "bitCount", GenConsts.MDESC_INTEGER__BIT_COUNT, false);
        for (int i = 1; i < type.legsAlloc(); ++i) {
            mv.visitInsn(95);
            mv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "bitCount", GenConsts.MDESC_INTEGER__BIT_COUNT, false);
            mv.visitInsn(96);
        }
    }

    @Override
    public JitType generateUnOpRunCode(JitCodeGenerator gen, JitPopCountOp op, JitControlFlowModel.JitBlock block, JitType uType, MethodVisitor rv) {
        JitType jitType = uType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                rv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "bitCount", GenConsts.MDESC_INTEGER__BIT_COUNT, false);
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                rv.visitMethodInsn(184, GenConsts.NAME_LONG, "bitCount", GenConsts.MDESC_LONG__BIT_COUNT, false);
                break;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                this.generateMpIntPopCount(gen, t, rv);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return JitType.IntJitType.I4;
    }
}

