/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.elastic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import generic.lsh.vector.IDFLookup;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.VectorCompare;
import generic.lsh.vector.WeightFactory;
import ghidra.features.bsim.gui.filters.FunctionTagBSimFilterType;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.Configuration;
import ghidra.features.bsim.query.client.IdHistogram;
import ghidra.features.bsim.query.client.NoDatabaseException;
import ghidra.features.bsim.query.client.tables.ExeTable;
import ghidra.features.bsim.query.description.CallgraphEntry;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.RowKey;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.features.bsim.query.description.VectorResult;
import ghidra.features.bsim.query.elastic.Base64Lite;
import ghidra.features.bsim.query.elastic.Base64VectorFactory;
import ghidra.features.bsim.query.elastic.ElasticConnection;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.elastic.RowKeyElastic;
import ghidra.features.bsim.query.protocol.AdjustVectorIndex;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.CreateDatabase;
import ghidra.features.bsim.query.protocol.DropDatabase;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.features.bsim.query.protocol.FunctionEntry;
import ghidra.features.bsim.query.protocol.InsertRequest;
import ghidra.features.bsim.query.protocol.InstallCategoryRequest;
import ghidra.features.bsim.query.protocol.InstallMetadataRequest;
import ghidra.features.bsim.query.protocol.InstallTagRequest;
import ghidra.features.bsim.query.protocol.PairInput;
import ghidra.features.bsim.query.protocol.PairNote;
import ghidra.features.bsim.query.protocol.PasswordChange;
import ghidra.features.bsim.query.protocol.PrewarmRequest;
import ghidra.features.bsim.query.protocol.QueryChildren;
import ghidra.features.bsim.query.protocol.QueryDelete;
import ghidra.features.bsim.query.protocol.QueryExeCount;
import ghidra.features.bsim.query.protocol.QueryExeInfo;
import ghidra.features.bsim.query.protocol.QueryInfo;
import ghidra.features.bsim.query.protocol.QueryName;
import ghidra.features.bsim.query.protocol.QueryNearest;
import ghidra.features.bsim.query.protocol.QueryNearestVector;
import ghidra.features.bsim.query.protocol.QueryPair;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.QueryUpdate;
import ghidra.features.bsim.query.protocol.QueryVectorId;
import ghidra.features.bsim.query.protocol.QueryVectorMatch;
import ghidra.features.bsim.query.protocol.ResponseAdjustIndex;
import ghidra.features.bsim.query.protocol.ResponseChildren;
import ghidra.features.bsim.query.protocol.ResponseDelete;
import ghidra.features.bsim.query.protocol.ResponseDropDatabase;
import ghidra.features.bsim.query.protocol.ResponseExe;
import ghidra.features.bsim.query.protocol.ResponseInfo;
import ghidra.features.bsim.query.protocol.ResponseInsert;
import ghidra.features.bsim.query.protocol.ResponseName;
import ghidra.features.bsim.query.protocol.ResponseNearest;
import ghidra.features.bsim.query.protocol.ResponseNearestVector;
import ghidra.features.bsim.query.protocol.ResponsePair;
import ghidra.features.bsim.query.protocol.ResponsePassword;
import ghidra.features.bsim.query.protocol.ResponsePrewarm;
import ghidra.features.bsim.query.protocol.ResponseUpdate;
import ghidra.features.bsim.query.protocol.SimilarityResult;
import ghidra.features.bsim.query.protocol.SimilarityVectorResult;
import ghidra.framework.client.ClientUtil;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class ElasticDatabase
implements FunctionDatabase {
    public static final int LAYOUT_VERSION = 3;
    public static final int MAX_VECTOR_OVERALL = 9000;
    public static final int MAX_FUNCTION_WINDOW = 500;
    public static final int MAX_FUNCTIONUPDATE_WINDOW = 500;
    public static final int MAX_VECTORCOUNT_WINDOW = 100;
    public static final int MAX_VECTORDELETE_WINDOW = 100;
    public static final int MAX_FUNCTION_BULK = 200;
    public static final int MAX_VECTOR_BULK = 200;
    private ElasticConnection connection;
    private FunctionDatabase.ConnectionType connectionType = FunctionDatabase.ConnectionType.Unencrypted_No_Authentication;
    private DatabaseInformation info;
    private Base64VectorFactory vectorFactory;
    private final BSimServerInfo serverInfo;
    private final String baseURL;
    private final String repository;
    private FunctionDatabase.BSimError lastError;
    private FunctionDatabase.Status status;
    private boolean initialized;

    public static String escape(String s) {
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        block10: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static void appendCategoryTag(List<CategoryRecord> catRecords, StringBuilder buffer) {
        buffer.append("\"execategory\": [");
        if (catRecords != null) {
            boolean needsComma = false;
            for (CategoryRecord catrec : catRecords) {
                if (needsComma) {
                    buffer.append(',');
                } else {
                    needsComma = true;
                }
                buffer.append('\"');
                buffer.append(catrec.getType()).append("\\t").append(ElasticDatabase.escape(catrec.getCategory()));
                buffer.append('\"');
            }
        }
        buffer.append(']');
    }

    private boolean insertExecutableRecord(ExecutableRecord exeRecord, String exeId) throws ElasticException {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"md5\": \"").append(exeRecord.getMd5()).append("\", ");
        builder.append("\"name_exec\": \"").append(ElasticDatabase.escape(exeRecord.getNameExec())).append("\", ");
        builder.append("\"architecture\": \"").append(exeRecord.getArchitecture()).append("\", ");
        builder.append("\"name_compiler\": \"").append(exeRecord.getNameCompiler()).append("\", ");
        builder.append("\"ingest_date\": ").append(exeRecord.getDate().getTime()).append(", ");
        if (exeRecord.getRepository() == null) {
            builder.append("\"repository\": null, ");
        } else {
            builder.append("\"repository\": \"").append(ElasticDatabase.escape(exeRecord.getRepository())).append("\", ");
        }
        if (exeRecord.getPath() == null) {
            builder.append("\"path\": null");
        } else {
            builder.append("\"path\": \"").append(ElasticDatabase.escape(exeRecord.getPath())).append("\"");
        }
        List<CategoryRecord> catrecs = exeRecord.getAllCategories();
        if (catrecs != null) {
            builder.append(", ");
            ElasticDatabase.appendCategoryTag(catrecs, builder);
        }
        builder.append(", \"join_field\": \"exe\" }");
        StringBuilder pathbuilder = new StringBuilder();
        pathbuilder.append("executable/_doc/");
        pathbuilder.append(exeId);
        pathbuilder.append("?op_type=create");
        JsonObject resp = this.connection.executeStatementExpectFailure("PUT", pathbuilder.toString(), builder.toString());
        JsonObject error = (JsonObject)resp.get("error");
        if (error != null) {
            String type = error.get("type").getAsString();
            if (type.startsWith("version_conflict")) {
                return false;
            }
            String reason = ElasticConnection.convertToString(error.get("reason"));
            throw new ElasticException(reason);
        }
        return true;
    }

    private static RowKeyElastic updateKey(DescriptionManager manager, ExecutableRecord exeRecord) {
        if (exeRecord.getRowId() == null) {
            RowKeyElastic eKey = new RowKeyElastic(exeRecord.getMd5());
            manager.setExeRowId(exeRecord, eKey);
            return eKey;
        }
        return (RowKeyElastic)exeRecord.getRowId();
    }

    private static List<String> generateChildIds(DescriptionManager manager, FunctionDescription funcRecord) {
        List<CallgraphEntry> callgraphRecord = funcRecord.getCallgraphRecord();
        if (callgraphRecord == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(callgraphRecord.size());
        for (CallgraphEntry element : callgraphRecord) {
            FunctionDescription func = element.getFunctionDescription();
            ExecutableRecord exeRec = func.getExecutableRecord();
            RowKeyElastic eKey = ElasticDatabase.updateKey(manager, exeRec);
            StringBuilder buffer = new StringBuilder();
            eKey.generateFunctionId(buffer, func);
            res.add(buffer.toString());
        }
        Collections.sort(res);
        return res;
    }

    private void insertFunctionRange(DescriptionManager manager, ExecutableRecord exeRecord, RowKeyElastic exeKey, String exeId, Iterator<FunctionDescription> iter, int maxNumber) throws ElasticException {
        StringBuilder builder = new StringBuilder();
        do {
            List<String> vals;
            FunctionDescription desc = iter.next();
            builder.append("{ \"create\": { \"_index\": \"").append(this.repository).append("_executable\", ");
            builder.append("\"_id\": \"");
            exeKey.generateFunctionId(builder, desc);
            builder.append("\", \"routing\": \"");
            builder.append(exeId).append("\"}}\n");
            builder.append("{ \"name_func\": \"");
            builder.append(ElasticDatabase.escape(desc.getFunctionName()));
            SignatureRecord sigRec = desc.getSignatureRecord();
            long vecid = 0L;
            if (sigRec != null) {
                vecid = sigRec.getVectorId();
            }
            builder.append("\", \"id_signature\": \"");
            Base64Lite.encodeLongBase64(builder, vecid);
            builder.append("\", \"flags\": ").append(desc.getFlags());
            builder.append(", \"addr\": ").append(desc.getAddress());
            if (this.info.trackcallgraph && (vals = ElasticDatabase.generateChildIds(manager, desc)) != null) {
                builder.append(", \"childid\": [");
                boolean needComma = false;
                for (String val : vals) {
                    if (needComma) {
                        builder.append(',');
                    }
                    builder.append('\"').append(val).append('\"');
                    needComma = true;
                }
                builder.append(" ]");
            }
            builder.append(", \"join_field\": { ");
            builder.append("\"name\": \"function\", ");
            builder.append("\"parent\": \"");
            builder.append(exeId).append("\"}}\n");
        } while (--maxNumber > 0 && iter.hasNext());
        this.connection.executeBulk("/_bulk", builder.toString());
    }

    private JsonObject queryMd5ExeMatch(String md5) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": 1, \"query\": { \"bool\": { \"filter\": { \"term\": { \"md5\": \"");
        buffer.append(md5).append("\" } } } } }");
        JsonObject resp = this.connection.executeStatement("GET", "executable/_search", buffer.toString());
        JsonObject hits = (JsonObject)resp.get("hits");
        JsonObject totalRec = (JsonObject)hits.get("total");
        long total = totalRec.get("value").getAsLong();
        if (total == 0L) {
            return null;
        }
        JsonArray hitsArray = (JsonArray)hits.get("hits");
        return (JsonObject)hitsArray.get(0);
    }

    private JsonArray queryFuncNameMatch(String exeId, String functionName, int maxDocuments) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": ").append(maxDocuments);
        buffer.append(", \"_source\": { \"excludes\": [ \"childid\" ] }");
        buffer.append(", \"query\": {");
        buffer.append("    \"bool\": {");
        buffer.append("      \"must\": {");
        buffer.append("        \"term\": {");
        buffer.append("          \"name_func\": \"");
        buffer.append(ElasticDatabase.escape(functionName));
        buffer.append("\"} },");
        buffer.append("      \"filter\": {");
        buffer.append("        \"parent_id\": {");
        buffer.append("          \"type\": \"function\",");
        buffer.append("          \"id\": \"").append(exeId);
        buffer.append("\"} } } } }");
        JsonObject resp = this.connection.executeStatement("GET", "executable/_search", buffer.toString());
        JsonObject baseHits = (JsonObject)resp.get("hits");
        JsonElement hitsArray = baseHits.get("hits");
        if (hitsArray instanceof JsonArray) {
            JsonArray a = (JsonArray)hitsArray;
            return a;
        }
        return new JsonArray();
    }

    private JsonObject queryFuncNameAddress(String exeId, String functionName, long address) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"_source\": { \"excludes\": [ \"childid\" ] }");
        buffer.append(", \"query\": {");
        buffer.append("    \"bool\": {");
        buffer.append("      \"must\": {");
        buffer.append("        \"term\": {");
        buffer.append("          \"name_func\": \"");
        buffer.append(ElasticDatabase.escape(functionName));
        buffer.append("\"},");
        buffer.append("        \"term\": {");
        buffer.append("           \"addr\": ").append(address);
        buffer.append("} },");
        buffer.append("      \"filter\": {");
        buffer.append("        \"parent_id\": {");
        buffer.append("          \"type\": \"function\",");
        buffer.append("          \"id\": \"").append(exeId);
        buffer.append("\"} } } } }");
        JsonObject resp = this.connection.executeStatement("GET", "executable/_search", buffer.toString());
        JsonObject baseHits = (JsonObject)resp.get("hits");
        JsonObject totalRec = (JsonObject)baseHits.get("total");
        long total = totalRec.get("value").getAsLong();
        if (total != 1L) {
            return null;
        }
        JsonArray hitsArray = (JsonArray)baseHits.get("hits");
        return (JsonObject)hitsArray.get(0);
    }

    private ExecutableRecord findSingleExecutable(ExeSpecifier specifier, DescriptionManager manager) throws LSHException, ElasticException {
        if (specifier.exemd5 != null && specifier.exemd5.length() != 0) {
            JsonObject row = this.queryMd5ExeMatch(specifier.exemd5);
            if (row == null) {
                return null;
            }
            return ElasticDatabase.makeExecutableRecord(manager, row);
        }
        if (StringUtils.isEmpty((CharSequence)specifier.exename)) {
            throw new LSHException("ExeSpecifier must provide either md5 or name");
        }
        return this.querySingleExecutable(manager, specifier.exename, specifier.arch, specifier.execompname);
    }

    private ExecutableRecord findSingleExeWithMap(ExeSpecifier specifier, DescriptionManager manager, TreeMap<ExeSpecifier, ExecutableRecord> nameMap) throws LSHException, ElasticException {
        ExecutableRecord erec = nameMap.get(specifier);
        if (erec != null) {
            return erec;
        }
        erec = this.findSingleExecutable(specifier, manager);
        nameMap.put(specifier, erec);
        return erec;
    }

    private void queryExecutables(DescriptionManager manager, List<ExecutableRecord> exeList, int maxWindow, String searchAfter, boolean md5Order, String filter) throws ElasticException, LSHException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": ").append(maxWindow);
        buffer.append(", \"query\": {");
        buffer.append("  \"bool\": {");
        buffer.append("    \"must\": {");
        buffer.append("      \"exists\": { \"field\": \"md5\" } }");
        if (filter != null) {
            buffer.append(", ");
            buffer.append(filter);
        }
        buffer.append("}}, ");
        if (searchAfter != null) {
            buffer.append("\"search_after\": [ \"");
            buffer.append(ElasticDatabase.escape(searchAfter));
            buffer.append("\"], ");
        }
        if (md5Order) {
            buffer.append("\"sort\": [ { \"md5\": \"asc\" } ] }");
        } else {
            buffer.append("\"sort\": [ { \"name_exec\": \"asc\" } ] }");
        }
        JsonObject resp = this.connection.executeStatement("GET", "executable/_search", buffer.toString());
        JsonObject baseHits = (JsonObject)resp.get("hits");
        JsonArray hitsArray = (JsonArray)baseHits.get("hits");
        for (JsonElement element : hitsArray) {
            JsonObject exerow = (JsonObject)element;
            ExecutableRecord exeRecord = ElasticDatabase.makeExecutableRecord(manager, exerow);
            exeList.add(exeRecord);
        }
    }

    protected int countExecutables(String filter) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"query\": {");
        buffer.append("  \"bool\": {");
        buffer.append("    \"must\": {");
        buffer.append("      \"exists\": { \"field\": \"md5\" } }");
        if (filter != null) {
            buffer.append(", ");
            buffer.append(filter);
        }
        buffer.append("}}}");
        JsonObject resp = this.connection.executeStatement("GET", "executable/_count", buffer.toString());
        Long res = resp.get("count").getAsLong();
        return res.intValue();
    }

    private ExecutableRecord querySingleExecutable(DescriptionManager manager, String exeName, String arch, String compilerName) throws ElasticException, LSHException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": 4,");
        buffer.append("  \"query\": {");
        buffer.append("  \"bool\": {");
        buffer.append("      \"must\": {");
        buffer.append("        \"term\": { \"name_exec\": \"").append(ElasticDatabase.escape(exeName)).append("\" } }");
        if (!StringUtils.isEmpty((CharSequence)arch) || !StringUtils.isEmpty((CharSequence)compilerName)) {
            buffer.append(",   \"filter\": {");
            buffer.append("      \"script\": {");
            buffer.append("        \"script\": {");
            buffer.append("          \"inline\": \"");
            if (StringUtils.isEmpty((CharSequence)arch)) {
                buffer.append("doc['name_compiler'].value == params.comp");
            } else if (StringUtils.isEmpty((CharSequence)compilerName)) {
                buffer.append("doc['architecture'].value == params.arch");
            } else {
                buffer.append("doc['name_compiler'].value == params.comp && doc['architecture'].value == params.arch");
            }
            buffer.append("\",");
            buffer.append("          \"params\": {");
            if (arch.length() != 0) {
                buffer.append(" \"arch\": \"").append(arch);
                if (!StringUtils.isEmpty((CharSequence)compilerName)) {
                    buffer.append("\", ");
                } else {
                    buffer.append("\" ");
                }
            }
            if (!StringUtils.isEmpty((CharSequence)compilerName)) {
                buffer.append(" \"comp\": \"").append(compilerName).append("\" ");
            }
            buffer.append("}}}}");
        }
        buffer.append("} } }");
        JsonObject resp = this.connection.executeStatement("GET", "executable/_search", buffer.toString());
        JsonObject baseHits = (JsonObject)resp.get("hits");
        JsonObject totalRec = (JsonObject)baseHits.get("total");
        long total = totalRec.get("value").getAsLong();
        if (total != 1L) {
            return null;
        }
        JsonArray hitsArray = (JsonArray)baseHits.get("hits");
        JsonObject exerow = (JsonObject)hitsArray.get(0);
        ExecutableRecord exerec = ElasticDatabase.makeExecutableRecord(manager, exerow);
        return exerec;
    }

    private long fetchVectorCounts(Iterator<VectorResult> iter1, Iterator<VectorResult> iter2, int maxDocuments) throws ElasticException {
        if (!iter1.hasNext()) {
            return 0L;
        }
        long totalCount = 0L;
        VectorResult vecRes = iter1.next();
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"ids\": [ ");
        buffer.append('\"');
        Base64Lite.encodeLongBase64(buffer, vecRes.vectorid);
        buffer.append('\"');
        for (int i = 1; i < maxDocuments && iter1.hasNext(); ++i) {
            vecRes = iter1.next();
            buffer.append(", \"");
            Base64Lite.encodeLongBase64(buffer, vecRes.vectorid);
            buffer.append('\"');
        }
        buffer.append(" ] }");
        JsonObject resp = this.connection.executeStatement("GET", "meta/_mget", buffer.toString());
        JsonArray docs = (JsonArray)resp.get("docs");
        for (int i = 0; i < maxDocuments && iter2.hasNext(); ++i) {
            vecRes = iter2.next();
            JsonObject oneResp = (JsonObject)docs.get(i);
            String matchId = oneResp.get("_id").getAsString();
            long matchIdVal = Base64Lite.decodeLongBase64(matchId);
            if (matchIdVal != vecRes.vectorid) {
                throw new ElasticException("Mismatch in metaid");
            }
            JsonElement source = oneResp.get("_source");
            if (ElasticConnection.isNull(source)) {
                throw new ElasticException("meta document does not exist for id=" + matchId);
            }
            long count = ((JsonObject)source).get("count").getAsLong();
            totalCount += count;
            vecRes.hitcount = (int)count;
        }
        return totalCount;
    }

    private void fetchVectors(Iterator<VectorResult> iter1, Iterator<VectorResult> iter2, int maxDocuments) throws ElasticException {
        if (!iter1.hasNext()) {
            return;
        }
        VectorResult vecRes = iter1.next();
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"ids\": [ ");
        buffer.append('\"');
        Base64Lite.encodeLongBase64(buffer, vecRes.vectorid);
        buffer.append('\"');
        for (int i = 1; i < maxDocuments && iter1.hasNext(); ++i) {
            vecRes = iter1.next();
            buffer.append(", \"");
            Base64Lite.encodeLongBase64(buffer, vecRes.vectorid);
            buffer.append('\"');
        }
        buffer.append(" ] }");
        JsonObject resp = this.connection.executeStatement("GET", "vector/_mget", buffer.toString());
        JsonArray docs = (JsonArray)resp.get("docs");
        char[] vectorDecodeBuffer = Base64VectorFactory.allocateBuffer();
        for (int i = 0; i < maxDocuments && iter2.hasNext(); ++i) {
            vecRes = iter2.next();
            JsonObject oneResp = (JsonObject)docs.get(i);
            String matchId = oneResp.get("_id").getAsString();
            long matchIdVal = Base64Lite.decodeLongBase64(matchId);
            if (matchIdVal != vecRes.vectorid) {
                throw new ElasticException("Mismatch in vectorid");
            }
            JsonElement source = oneResp.get("_source");
            if (ElasticConnection.isNull(source)) {
                throw new ElasticException("vector document does not exist for id=" + matchId);
            }
            StringReader reader = new StringReader(((JsonObject)source).get("features").getAsString());
            try {
                vecRes.vec = this.vectorFactory.restoreVectorFromBase64(reader, vectorDecodeBuffer);
                continue;
            }
            catch (IOException e) {
                throw new ElasticException(e.getMessage());
            }
        }
    }

    private void queryAssociatedSignatures(List<FunctionDescription> listFunctions, DescriptionManager manager) throws ElasticException {
        SignatureRecord sigRec;
        TreeMap<Long, VectorResult> vecMap = new TreeMap<Long, VectorResult>();
        for (FunctionDescription fdesc : listFunctions) {
            Long key;
            if (fdesc.getSignatureRecord() != null || vecMap.containsKey(key = Long.valueOf(fdesc.getVectorId()))) continue;
            VectorResult vecRes = new VectorResult();
            vecRes.vectorid = key;
            vecMap.put(key, vecRes);
        }
        Iterator<VectorResult> iter1 = vecMap.values().iterator();
        Iterator<VectorResult> iter2 = vecMap.values().iterator();
        while (iter1.hasNext()) {
            this.fetchVectors(iter1, iter2, 50);
        }
        iter1 = vecMap.values().iterator();
        iter2 = vecMap.values().iterator();
        while (iter1.hasNext()) {
            this.fetchVectorCounts(iter1, iter2, 100);
        }
        TreeMap<Long, SignatureRecord> sigMap = new TreeMap<Long, SignatureRecord>();
        for (Map.Entry entry : vecMap.entrySet()) {
            sigRec = manager.newSignature(((VectorResult)entry.getValue()).vec, ((VectorResult)entry.getValue()).hitcount);
            manager.setSignatureId(sigRec, (long)((Long)entry.getKey()));
            sigMap.put((Long)entry.getKey(), sigRec);
        }
        for (FunctionDescription fdesc : listFunctions) {
            if (fdesc.getSignatureRecord() != null) continue;
            sigRec = (SignatureRecord)sigMap.get(fdesc.getVectorId());
            manager.attachSignature(fdesc, sigRec);
        }
    }

    private JsonArray queryVectorIdMatch(long vectorId, String filter, int maxDocuments) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": ").append(maxDocuments);
        buffer.append(", \"_source\": { \"excludes\": [ \"childid\" ] }");
        buffer.append(", \"query\": { ");
        buffer.append("    \"bool\": { ");
        buffer.append("      \"must\": { ");
        buffer.append("        \"term\": { \"id_signature\": \"");
        Base64Lite.encodeLongBase64(buffer, vectorId);
        buffer.append("\" } }");
        if (filter != null) {
            buffer.append(filter);
        }
        buffer.append("} } }");
        JsonObject resp = this.connection.executeStatement("GET", "executable/_search", buffer.toString());
        JsonObject baseHits = (JsonObject)resp.get("hits");
        JsonObject totalRec = (JsonObject)baseHits.get("total");
        long total = totalRec.get("value").getAsLong();
        if (total == 0L) {
            return new JsonArray();
        }
        JsonArray hitsArray = (JsonArray)baseHits.get("hits");
        return hitsArray;
    }

    private long queryNearestVector(List<VectorResult> listResult, LSHVector vector, double similarityThreshold, double significanceThreshold, int maxVectors) throws ElasticException {
        if (this.connection == null) {
            return 0L;
        }
        StringBuilder vecEncode = new StringBuilder();
        vector.saveBase64(vecEncode, Base64Lite.encode);
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": ").append(maxVectors).append(", ");
        buffer.append("  \"query\": { ");
        buffer.append("  \"function_score\": { ");
        buffer.append("    \"query\": { ");
        buffer.append("      \"match\": { ");
        buffer.append("        \"features\": \"");
        buffer.append((CharSequence)vecEncode);
        buffer.append("\" } }, ");
        buffer.append("    \"min_score\": 0.00001, ");
        buffer.append("    \"boost_mode\": \"replace\", ");
        buffer.append("    \"functions\": [ { ");
        buffer.append("      \"script_score\": { ");
        buffer.append("        \"script\": { ");
        buffer.append("          \"lang\": \"bsim_scripts\", ");
        buffer.append("          \"source\": \"lsh_compare\", ");
        buffer.append("          \"params\": { ");
        buffer.append("            \"indexname\": \"lsh_").append(this.repository).append("\", ");
        buffer.append("            \"vector\": \"");
        buffer.append((CharSequence)vecEncode);
        buffer.append("\",          \"simthresh\": ").append(similarityThreshold);
        buffer.append(",            \"sigthresh\": ").append(significanceThreshold);
        buffer.append(" } } } } ] } } }");
        JsonObject resp = this.connection.executeStatement("GET", "vector/_search", buffer.toString());
        JsonObject baseHits = (JsonObject)resp.get("hits");
        if (baseHits == null) {
            throw new ElasticException("Could not find hits document");
        }
        JsonObject totalRec = (JsonObject)baseHits.get("total");
        long numHits = totalRec.get("value").getAsLong();
        if (numHits == 0L) {
            return 0L;
        }
        JsonArray hitsArray = (JsonArray)baseHits.get("hits");
        char[] decodeBuffer = Base64VectorFactory.allocateBuffer();
        VectorCompare vecCompare = new VectorCompare();
        try {
            int returnedHits = hitsArray.size();
            for (int i = 0; i < returnedHits; ++i) {
                JsonObject mainHit = (JsonObject)hitsArray.get(i);
                VectorResult vecRes = new VectorResult();
                vecRes.vectorid = Base64Lite.decodeLongBase64(mainHit.get("_id").getAsString());
                vecRes.hitcount = -1;
                vecRes.sim = mainHit.get("_score").getAsDouble();
                JsonObject source = (JsonObject)mainHit.get("_source");
                StringReader reader = new StringReader(source.get("features").getAsString());
                vecRes.vec = this.vectorFactory.restoreVectorFromBase64(reader, decodeBuffer);
                vector.compareCounts(vecRes.vec, vecCompare);
                vecCompare.dotproduct = vecRes.sim * vector.getLength() * vecRes.vec.getLength();
                vecRes.signif = this.vectorFactory.calculateSignificance(vecCompare);
                listResult.add(vecRes);
            }
        }
        catch (IOException ex) {
            throw new ElasticException("Bad encoding in result document");
        }
        long totalCount = 0L;
        Iterator<VectorResult> iter1 = listResult.iterator();
        Iterator<VectorResult> iter2 = listResult.iterator();
        while (iter1.hasNext()) {
            totalCount += this.fetchVectorCounts(iter1, iter2, 100);
        }
        return totalCount;
    }

    private int getTotalCount(List<VectorResult> listResult) {
        int count = 0;
        for (VectorResult res : listResult) {
            count += res.hitcount;
        }
        return count;
    }

    private void queryNearest(SimilarityResult similarityResult, DescriptionManager manager, LSHVector vector, QueryNearest query, String filter, HashMap<LSHVector, List<VectorResult>> vecToResultsMap) throws ElasticException, LSHException {
        ArrayList<VectorResult> resultset = new ArrayList<VectorResult>();
        int vectormax = query.vectormax;
        if (vectormax == 0) {
            vectormax = 9000;
        }
        if (vecToResultsMap.containsKey(vector)) {
            resultset = vecToResultsMap.get(vector);
            similarityResult.setTotalCount(this.getTotalCount(resultset));
        } else {
            similarityResult.setTotalCount((int)this.queryNearestVector(resultset, vector, query.thresh, query.signifthresh, vectormax));
            vecToResultsMap.put(vector, resultset);
        }
        int count = 0;
        for (VectorResult dresult : resultset) {
            if (count >= query.max) break;
            SignatureRecord srec = manager.newSignature(dresult.vec, dresult.hitcount);
            JsonArray descres = this.queryVectorIdMatch(dresult.vectorid, filter, query.max - count);
            if (descres == null) {
                throw new ElasticException("Error querying vectorid: " + Long.toString(dresult.vectorid));
            }
            if (descres.size() == 0) {
                if (filter != null) continue;
                throw new ElasticException("No functions matching vectorid: " + Long.toString(dresult.vectorid));
            }
            count += descres.size();
            this.convertDescriptionRows(similarityResult, descres, dresult, manager, srec);
        }
    }

    private int queryFunctions(QueryNearest query, String filter, ResponseNearest response, DescriptionManager manager, Iterator<FunctionDescription> iter) throws ElasticException, LSHException {
        HashMap<LSHVector, List<VectorResult>> vecToResultMap = new HashMap<LSHVector, List<VectorResult>>();
        while (iter.hasNext()) {
            LSHVector thevec;
            double len2;
            FunctionDescription frec = iter.next();
            SignatureRecord srec = frec.getSignatureRecord();
            if (srec == null || (len2 = this.vectorFactory.getSelfSignificance(thevec = srec.getLSHVector())) < query.signifthresh) continue;
            ++response.totalfunc;
            SimilarityResult simres = new SimilarityResult(frec);
            if (manager.getExecutableRecordSet().size() > 1000) {
                manager.clear();
            } else {
                manager.clearFunctions();
            }
            this.queryNearest(simres, manager, thevec, query, filter, vecToResultMap);
            if (simres.size() == 0) continue;
            ++response.totalmatch;
            if (simres.size() == 1) {
                ++response.uniquematch;
            }
            response.result.add(simres);
            simres.transfer(response.manage, true);
        }
        return vecToResultMap.size();
    }

    private void queryByName(List<FunctionDescription> listFunctions, DescriptionManager manager, ExecutableRecord exeRecord, String functionName, boolean fillInSignatures, int maxFunctions) throws ElasticException {
        RowKeyElastic eKey = (RowKeyElastic)exeRecord.getRowId();
        String exeId = eKey.generateExeIdString();
        if (listFunctions == null) {
            listFunctions = new ArrayList<FunctionDescription>();
        }
        if (functionName.length() == 0) {
            this.queryAllFunc(listFunctions, exeRecord, exeId, manager, maxFunctions);
        } else {
            JsonArray hitsarray = this.queryFuncNameMatch(exeId, functionName, maxFunctions);
            JsonObject doc = null;
            for (JsonElement element : hitsarray) {
                doc = (JsonObject)element;
                FunctionDescription funcDesc = ElasticDatabase.convertDescriptionRow(doc, exeRecord, manager, null);
                listFunctions.add(funcDesc);
            }
        }
        if (fillInSignatures) {
            this.queryAssociatedSignatures(listFunctions, manager);
        }
    }

    private FunctionDescription queryByNameAddress(DescriptionManager manager, ExecutableRecord exeRecord, String functionName, long address, boolean fillInSignatures) throws ElasticException {
        RowKeyElastic eKey = (RowKeyElastic)exeRecord.getRowId();
        String exeId = eKey.generateExeIdString();
        JsonObject doc = this.queryFuncNameAddress(exeId, functionName, address);
        if (doc == null) {
            return null;
        }
        FunctionDescription funcDesc = ElasticDatabase.convertDescriptionRow(doc, exeRecord, manager, null);
        if (fillInSignatures) {
            ArrayList<FunctionDescription> vecres = new ArrayList<FunctionDescription>();
            vecres.add(funcDesc);
            this.queryAssociatedSignatures(vecres, manager);
        }
        return funcDesc;
    }

    private void queryExecutableRecordById(DescriptionManager manager, Iterator<RowKeyElastic> iter1, Iterator<RowKeyElastic> iter2, int maxDocuments) throws ElasticException, LSHException {
        JsonElement hits;
        JsonObject subquery;
        int i;
        StringBuilder buffer = new StringBuilder();
        if (!iter1.hasNext()) {
            return;
        }
        String path = "/" + this.repository + "_executable/_msearch";
        int count = 0;
        for (int i2 = 0; i2 < maxDocuments; ++i2) {
            String exeId = iter1.next().generateExeIdString();
            buffer.append("{}\n");
            buffer.append("{ \"query\": { \"bool\": { \"filter\": { \"term\": { \"_id\": \"");
            buffer.append(exeId);
            buffer.append("\" }}}}}\n");
            ++count;
            if (!iter1.hasNext()) break;
        }
        JsonObject bulkobj = this.connection.executeBulk(path, buffer.toString());
        JsonArray responses = (JsonArray)bulkobj.get("responses");
        for (i = 0; i < count; ++i) {
            subquery = (JsonObject)responses.get(i);
            hits = subquery.get("hits");
            if (ElasticConnection.isNull(hits)) {
                throw new ElasticException("Multi-search for exe records failed");
            }
            JsonObject totalRec = (JsonObject)((JsonObject)hits).get("total");
            long total = totalRec.get("value").getAsLong();
            if (total == 1L) continue;
            throw new ElasticException("Could not recover unique executable via id");
        }
        for (i = 0; i < count; ++i) {
            subquery = (JsonObject)responses.get(i);
            hits = (JsonObject)subquery.get("hits");
            JsonArray hitsArray = (JsonArray)hits.get("hits");
            hits = (JsonObject)hitsArray.get(0);
            ExecutableRecord newExe = ElasticDatabase.makeExecutableRecord(manager, (JsonObject)hits);
            RowKey rowKey = iter2.next();
            manager.cacheExecutableByRow(newExe, rowKey);
        }
    }

    private JsonObject queryFunctionsOfExeId(String exeId, long maxDocuments, long start) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": ").append(maxDocuments);
        buffer.append(", \"_source\": { \"excludes\": [ \"childid\" ] }");
        buffer.append(", \"query\": { \"parent_id\": { \"type\": \"function\", \"id\": \"").append(exeId).append("\" }}");
        if (start != 0L) {
            buffer.append(", \"search_after\": [").append(start).append(']');
        }
        buffer.append(", \"sort\": [ { \"_doc\": \"asc\" } ] }");
        return this.connection.executeStatement("GET", "executable/_search", buffer.toString());
    }

    private int queryAllFunc(List<FunctionDescription> listFunctions, ExecutableRecord exeRecord, String exeId, DescriptionManager manager, int maxDocuments) throws ElasticException {
        long total;
        long start = 0L;
        long count = 0L;
        do {
            int limit = 500;
            if (maxDocuments != 0 && (long)maxDocuments - count < (long)limit) {
                limit = (int)((long)maxDocuments - count);
            }
            JsonObject resp = this.queryFunctionsOfExeId(exeId, limit, start);
            JsonObject hits = (JsonObject)resp.get("hits");
            JsonObject totalRec = (JsonObject)hits.get("total");
            total = totalRec.get("value").getAsLong();
            if (maxDocuments != 0 && (long)maxDocuments < total) {
                total = maxDocuments;
            }
            JsonArray hitsarray = (JsonArray)hits.get("hits");
            JsonObject doc = null;
            for (JsonElement element : hitsarray) {
                doc = (JsonObject)element;
                FunctionDescription funcDesc = ElasticDatabase.convertDescriptionRow(doc, exeRecord, manager, null);
                listFunctions.add(funcDesc);
                ++count;
            }
            if (hitsarray.size() == 0) break;
            JsonArray sort = (JsonArray)doc.get("sort");
            start = sort.get(0).getAsLong();
        } while (total > count);
        return (int)total;
    }

    private void updateFunctions(Iterator<FunctionDescription.Update> iter, String exeId, int maxFunctions) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        do {
            FunctionDescription.Update rec = iter.next();
            RowKeyElastic eKey = (RowKeyElastic)rec.update.getExecutableRecord().getRowId();
            buffer.append("{ \"update\": { \"_index\": \"").append(this.repository).append("_executable\", ");
            buffer.append("\"_id\": \"");
            eKey.generateFunctionId(buffer, rec.update);
            buffer.append("\", \"routing\": \"").append(exeId).append("\"} }\n");
            buffer.append("{ \"doc\": { ");
            boolean needscomma = false;
            if (rec.function_name) {
                needscomma = true;
                buffer.append("\"name_func\": \"").append(ElasticDatabase.escape(rec.update.getFunctionName())).append('\"');
            }
            if (rec.flags) {
                if (needscomma) {
                    buffer.append(',');
                }
                buffer.append(" \"flags\": ").append(rec.update.getFlags());
            }
            buffer.append("} }\n");
        } while (iter.hasNext());
        this.connection.executeBulk("/_bulk", buffer.toString());
    }

    private void updateExecutable(ExecutableRecord.Update updateRecord, String exeId) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        boolean needscomma = false;
        buffer.append("{ \"doc\": {");
        if (updateRecord.name_exec) {
            needscomma = true;
            buffer.append("\"name_exec\": \"").append(ElasticDatabase.escape(updateRecord.update.getNameExec())).append('\"');
        }
        if (updateRecord.architecture) {
            if (needscomma) {
                buffer.append(',');
            } else {
                needscomma = true;
            }
            buffer.append("\"architecture\": \"").append(updateRecord.update.getArchitecture()).append('\"');
        }
        if (updateRecord.name_compiler) {
            if (needscomma) {
                buffer.append(',');
            } else {
                needscomma = true;
            }
            buffer.append("\"name_compiler\": \"").append(updateRecord.update.getArchitecture()).append('\"');
        }
        if (updateRecord.date) {
            if (needscomma) {
                buffer.append(',');
            } else {
                needscomma = true;
            }
            buffer.append("\"ingest_date\": ").append(updateRecord.update.getDate().getTime());
        }
        if (updateRecord.repository) {
            if (needscomma) {
                buffer.append(',');
            } else {
                needscomma = true;
            }
            buffer.append("\"repository\": \"").append(updateRecord.update.getRepository()).append('\"');
        }
        if (updateRecord.path) {
            if (needscomma) {
                buffer.append(',');
            } else {
                needscomma = true;
            }
            buffer.append("\"path\": \"").append(updateRecord.update.getPath()).append('\"');
        }
        if (updateRecord.categories) {
            if (needscomma) {
                buffer.append(',');
            } else {
                needscomma = true;
            }
            ElasticDatabase.appendCategoryTag(updateRecord.update.getAllCategories(), buffer);
        }
        buffer.append("} }");
        StringBuilder pathBuffer = new StringBuilder();
        pathBuffer.append("executable/_update/");
        pathBuffer.append(exeId);
        this.connection.executeStatementNoResponse("POST", pathBuffer.toString(), buffer.toString());
    }

    private int updateExecutable(DescriptionManager manager, ExecutableRecord exeRecord, List<FunctionDescription> badFunctions) throws ElasticException, LSHException {
        JsonObject row = this.queryMd5ExeMatch(exeRecord.getMd5());
        if (row == null) {
            return -1;
        }
        ExecutableRecord erec_db = ElasticDatabase.makeExecutableRecordTemp(row);
        DescriptionManager dbmanage = new DescriptionManager();
        erec_db = dbmanage.transferExecutable(erec_db);
        ExecutableRecord.Update exe_update = new ExecutableRecord.Update();
        boolean has_exe_update = exeRecord.diffForUpdate(exe_update, erec_db);
        RowKeyElastic eKey = (RowKeyElastic)erec_db.getRowId();
        String exeId = eKey.generateExeIdString();
        ArrayList<FunctionDescription> funclist = new ArrayList<FunctionDescription>();
        this.queryAllFunc(funclist, erec_db, exeId, dbmanage, 0);
        Map<Long, FunctionDescription> addrmap = FunctionDescription.createAddressToFunctionMap(funclist.iterator());
        List<FunctionDescription.Update> updatelist = FunctionDescription.generateUpdates(manager.listFunctions(exeRecord), addrmap, badFunctions);
        if (!has_exe_update && updatelist.isEmpty()) {
            return 0;
        }
        if (has_exe_update) {
            this.updateExecutable(exe_update, exeId);
        }
        Iterator<FunctionDescription.Update> iter = updatelist.iterator();
        while (iter.hasNext()) {
            this.updateFunctions(iter, exeId, 500);
        }
        int val = has_exe_update ? 1 : 0;
        return val += 2 * updatelist.size();
    }

    private static List<CategoryRecord> makeCategoryList(JsonObject source) {
        JsonArray catArray = (JsonArray)source.get("execategory");
        if (catArray == null || catArray.size() == 0) {
            return null;
        }
        ArrayList<CategoryRecord> res = new ArrayList<CategoryRecord>();
        for (JsonElement element : catArray) {
            String concat = element.getAsString();
            int pos = concat.indexOf(9);
            if (pos <= 0) continue;
            String type = concat.substring(0, pos);
            String value = concat.substring(pos + 1);
            res.add(new CategoryRecord(type, value));
        }
        return res;
    }

    private static ExecutableRecord makeExecutableRecordTemp(JsonObject hit) {
        ExecutableRecord exeres;
        RowKeyElastic eKey = RowKeyElastic.parseExeIdString(hit.get("_id").getAsString());
        JsonObject source = (JsonObject)hit.get("_source");
        String md5 = ElasticConnection.convertToString(source.get("md5"));
        String exename = ElasticConnection.convertToString(source.get("name_exec"));
        String arch = ElasticConnection.convertToString(source.get("architecture"));
        if (ExecutableRecord.isLibraryHash(md5)) {
            exeres = new ExecutableRecord(exename, arch, eKey);
        } else {
            String cname = ElasticConnection.convertToString(source.get("name_compiler"));
            String repo = ElasticConnection.convertToString(source.get("repository"));
            String path = null;
            if (repo != null) {
                path = ElasticConnection.convertToString(source.get("path"));
            }
            List<CategoryRecord> catrecs = ElasticDatabase.makeCategoryList(source);
            long milli = source.get("ingest_date").getAsLong();
            exeres = new ExecutableRecord(md5, exename, cname, arch, new Date(milli), catrecs, eKey, repo, path);
        }
        return exeres;
    }

    private static ExecutableRecord makeExecutableRecord(DescriptionManager manager, JsonObject hit) throws LSHException {
        ExecutableRecord exerec;
        RowKeyElastic eKey = RowKeyElastic.parseExeIdString(hit.get("_id").getAsString());
        JsonObject source = (JsonObject)hit.get("_source");
        String md5 = ElasticConnection.convertToString(source.get("md5"));
        String exename = ElasticConnection.convertToString(source.get("name_exec"));
        String arch = ElasticConnection.convertToString(source.get("architecture"));
        if (ExecutableRecord.isLibraryHash(md5)) {
            exerec = manager.newExecutableLibrary(exename, arch, eKey);
        } else {
            String cname = ElasticConnection.convertToString(source.get("name_compiler"));
            String repo = ElasticConnection.convertToString(source.get("repository"));
            String path = null;
            if (repo != null) {
                path = ElasticConnection.convertToString(source.get("path"));
            }
            List<CategoryRecord> catrecs = ElasticDatabase.makeCategoryList(source);
            long milli = source.get("ingest_date").getAsLong();
            Date date = new Date(milli);
            exerec = manager.newExecutableRecord(md5, exename, cname, arch, date, repo, path, eKey);
            if (catrecs != null) {
                manager.setExeCategories(exerec, catrecs);
            }
        }
        return exerec;
    }

    private static FunctionDescription convertDescriptionRow(JsonObject hit, ExecutableRecord exeRecord, DescriptionManager manager, SignatureRecord sigRecord) {
        RowKeyElastic rowid = RowKeyElastic.parseFunctionId(hit.get("_id").getAsString());
        JsonObject source = (JsonObject)hit.get("_source");
        String func_name = source.get("name_func").getAsString();
        long addr = source.get("addr").getAsLong();
        int flags = (int)source.get("flags").getAsLong();
        long id_sig = Base64Lite.decodeLongBase64(source.get("id_signature").getAsString());
        FunctionDescription fres = manager.newFunctionDescription(func_name, addr, exeRecord);
        manager.setFunctionDescriptionId(fres, rowid);
        manager.setFunctionDescriptionFlags(fres, flags);
        manager.setSignatureId(fres, id_sig);
        if (sigRecord != null) {
            manager.setSignatureId(sigRecord, id_sig);
            manager.attachSignature(fres, sigRecord);
        }
        return fres;
    }

    protected void convertDescriptionRows(SimilarityResult similarityResult, JsonArray descRows, VectorResult vectorResult, DescriptionManager manager, SignatureRecord sigRecord) throws ElasticException, LSHException {
        RowKeyElastic eKey;
        if (descRows.size() == 0) {
            return;
        }
        ArrayList<RowKeyElastic> parentIds = new ArrayList<RowKeyElastic>(descRows.size());
        TreeSet<RowKeyElastic> parents = new TreeSet<RowKeyElastic>();
        for (JsonElement descRow : descRows) {
            JsonObject hit = (JsonObject)descRow;
            JsonObject source = (JsonObject)hit.get("_source");
            JsonObject joinfield = (JsonObject)source.get("join_field");
            String exeid = joinfield.get("parent").getAsString();
            eKey = RowKeyElastic.parseExeIdString(exeid);
            parentIds.add(eKey);
            if (manager.findExecutableByRow(eKey) != null) continue;
            parents.add(eKey);
        }
        Iterator<RowKeyElastic> iter1 = parents.iterator();
        Iterator<RowKeyElastic> iter2 = parents.iterator();
        while (iter1.hasNext()) {
            this.queryExecutableRecordById(manager, iter1, iter2, 100);
        }
        JsonObject currow = (JsonObject)descRows.get(0);
        eKey = (RowKeyElastic)parentIds.get(0);
        ExecutableRecord curexe = manager.findExecutableByRow(eKey);
        FunctionDescription fres = ElasticDatabase.convertDescriptionRow(currow, curexe, manager, sigRecord);
        if (similarityResult != null) {
            similarityResult.addNote(fres, vectorResult.sim, vectorResult.signif);
        }
        for (int i = 1; i < descRows.size(); ++i) {
            currow = (JsonObject)descRows.get(i);
            eKey = (RowKeyElastic)parentIds.get(i);
            curexe = manager.findExecutableByRow(eKey);
            fres = ElasticDatabase.convertDescriptionRow(currow, curexe, manager, sigRecord);
            if (similarityResult == null) continue;
            similarityResult.addNote(fres, vectorResult.sim, vectorResult.signif);
        }
    }

    private void insertLibrary(DescriptionManager manager, ExecutableRecord exeRecord) throws ElasticException {
        RowKeyElastic eKey = ElasticDatabase.updateKey(manager, exeRecord);
        String exeId = eKey.generateExeIdString();
        this.insertExecutableRecord(exeRecord, exeId);
        Iterator<FunctionDescription> iter = manager.listFunctions(exeRecord);
        while (iter.hasNext()) {
            this.insertFunctionRange(manager, exeRecord, eKey, exeId, iter, 200);
        }
    }

    private boolean insertExe(DescriptionManager manager, ExecutableRecord exeRecord) throws ElasticException, LSHException, FunctionDatabase.DatabaseNonFatalException {
        RowKeyElastic eKey = ElasticDatabase.updateKey(manager, exeRecord);
        String exeId = eKey.generateExeIdString();
        if (!this.insertExecutableRecord(exeRecord, exeId)) {
            JsonObject exeObj = this.queryMd5ExeMatch(exeRecord.getMd5());
            if (exeObj != null) {
                ExecutableRecord oldrec = ElasticDatabase.makeExecutableRecordTemp(exeObj);
                int cmp = oldrec.compareMetadata(exeRecord);
                if (cmp != 0) {
                    String fatalerror = FunctionDatabase.constructFatalError(cmp, exeRecord, oldrec);
                    if (fatalerror != null) {
                        throw new LSHException(fatalerror);
                    }
                    throw new FunctionDatabase.DatabaseNonFatalException(FunctionDatabase.constructNonfatalError(cmp, exeRecord, oldrec));
                }
                throw new FunctionDatabase.DatabaseNonFatalException(exeRecord.getNameExec() + " is already ingested");
            }
            return false;
        }
        int newIds = 0;
        long baseId = 0L;
        Iterator<FunctionDescription> iter = manager.listFunctions(exeRecord);
        while (iter.hasNext()) {
            iter.next();
            ++newIds;
        }
        baseId = this.allocateFunctionIndexSpace(newIds);
        iter = manager.listFunctions(exeRecord);
        while (iter.hasNext()) {
            manager.setFunctionDescriptionId(iter.next(), new RowKeyElastic(baseId));
            ++baseId;
        }
        Set<IdHistogram> vectorContainer = IdHistogram.collectVectors(manager, manager.listFunctions(exeRecord));
        iter = manager.listFunctions(exeRecord);
        while (iter.hasNext()) {
            this.insertFunctionRange(manager, exeRecord, eKey, exeId, iter, 200);
        }
        Iterator<IdHistogram> viter = vectorContainer.iterator();
        while (viter.hasNext()) {
            this.insertVectorRange(viter, 200);
        }
        return true;
    }

    private void createConfigurationIndex() throws ElasticException {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"settings\": { ");
        builder.append("    \"number_of_shards\": 1, ");
        builder.append("    \"auto_expand_replicas\": \"0-all\" }, ");
        builder.append("  \"mappings\": { ");
        builder.append("    \"dynamic\": \"strict\", ");
        builder.append("    \"properties\": { ");
        builder.append("      \"type\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"iid\": { ");
        builder.append("        \"type\": \"long\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"value\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false } } } }");
        this.connection.executeStatementNoResponse("PUT", "configuration", builder.toString());
        this.connection.executeStatementNoResponse("PUT", "configuration/_doc/1", "{ \"type\": \"sequence\", \"iid\": 1 }");
    }

    private long allocateFunctionIndexSpace(int amount) throws ElasticException {
        String body = "{ \"script\": { \"inline\": \"ctx._source.iid += params.bulk_size\", \"params\": { \"bulk_size\": " + Integer.toString(amount) + "}}}";
        JsonObject resp = this.connection.executeStatement("POST", "configuration/_update/1?_source=iid&retry_on_conflict=5", body);
        JsonObject get = (JsonObject)resp.get("get");
        JsonObject fields = (JsonObject)get.get("_source");
        long res = fields.get("iid").getAsLong();
        return res - (long)amount;
    }

    private void insertVectorRange(Iterator<IdHistogram> iter, int maxVectors) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        do {
            IdHistogram entry = iter.next();
            buffer.append("{ \"create\": { \"_index\": \"").append(this.repository).append("_vector\", ");
            buffer.append("\"_id\": \"");
            Base64Lite.encodeLongBase64(buffer, entry.id);
            buffer.append("\" } }\n");
            buffer.append("{ \"features\": \"");
            entry.vec.saveBase64(buffer, Base64Lite.encode);
            buffer.append("\" }\n");
            buffer.append("{ \"update\": { \"_index\": \"").append(this.repository).append("_meta\", ");
            buffer.append("\"_id\": \"");
            Base64Lite.encodeLongBase64(buffer, entry.id);
            buffer.append("\", \"retry_on_conflict\": 5 } }\n");
            buffer.append("{ \"script\": { \"inline\": \"ctx._source.count += params.count\", ");
            buffer.append("\"params\": { \"count\": ").append(entry.count).append("} },");
            buffer.append("\"upsert\": { \"count\": ").append(entry.count).append("} }\n");
        } while (--maxVectors > 0 && iter.hasNext());
        JsonObject resp = this.connection.executeBulk("/_bulk", buffer.toString());
        if (resp.get("errors").getAsBoolean()) {
            JsonArray items = (JsonArray)resp.get("items");
            for (JsonElement elem : items) {
                JsonObject item = (JsonObject)elem;
                JsonObject create = (JsonObject)item.get("create");
                JsonObject error = null;
                if (create != null) {
                    String type;
                    error = (JsonObject)create.get("error");
                    if (error != null && (type = error.get("type").getAsString()).startsWith("version_conflict")) {
                        continue;
                    }
                } else {
                    JsonObject update = (JsonObject)item.get("update");
                    error = (JsonObject)update.get("error");
                }
                if (error == null) continue;
                throw new ElasticException(ElasticConnection.convertToString(error.get("reason")));
            }
        }
    }

    private void decrementVectorCounters(List<IdHistogram> deleteList, Iterator<IdHistogram> iter1, Iterator<IdHistogram> iter2, int maxVectors) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < maxVectors && iter1.hasNext(); ++i) {
            IdHistogram entry = iter1.next();
            buffer.append("{ \"update\": { \"_index\": \"").append(this.repository).append("_meta\", ");
            buffer.append("\"_id\": \"");
            Base64Lite.encodeLongBase64(buffer, entry.id);
            buffer.append("\", \"retry_on_conflict\": 5 } }\n");
            buffer.append("{ \"script\": { \"inline\": \"if ((ctx._source.count -= params.count) <=0) { ctx.op = \\\"delete\\\" }\", ");
            buffer.append("\"params\": { \"count\": ").append(entry.count).append("} } }\n");
        }
        JsonObject resp = this.connection.executeBulk("/_bulk", buffer.toString());
        JsonArray items = (JsonArray)resp.get("items");
        for (int i = 0; i < maxVectors && iter2.hasNext(); ++i) {
            IdHistogram entry = iter2.next();
            JsonObject item = (JsonObject)items.get(i);
            JsonObject update = (JsonObject)item.get("update");
            long id = Base64Lite.decodeLongBase64(update.get("_id").getAsString());
            if (id != entry.id) {
                throw new ElasticException("Mismatch in decrementVectorCounters");
            }
            if (!"deleted".equals(ElasticConnection.convertToString(update.get("result")))) continue;
            deleteList.add(entry);
        }
    }

    private void deleteRawVectors(Iterator<IdHistogram> iter, int maxVectors) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        do {
            IdHistogram entry = iter.next();
            buffer.append("{ \"delete\": { \"_index\": \"").append(this.repository).append("_vector\", ");
            buffer.append("\"_id\": \"");
            Base64Lite.encodeLongBase64(buffer, entry.id);
            buffer.append("\" } }\n");
        } while (iter.hasNext() && --maxVectors > 0);
        JsonObject resp = this.connection.executeBulk("/_bulk", buffer.toString());
        if (resp.get("errors").getAsBoolean()) {
            throw new ElasticException("Error during vector deletion");
        }
    }

    private int deleteExeDocuments(String exeId) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"query\": {");
        buffer.append("  \"parent_id\": {");
        buffer.append("    \"type\": \"function\",");
        buffer.append("    \"id\": \"").append(exeId).append("\" } } }");
        JsonObject resp = this.connection.executeStatement("POST", "executable/_delete_by_query", buffer.toString());
        long numDocs = resp.get("deleted").getAsLong();
        this.connection.executeURIOnly("DELETE", "executable/_doc/" + exeId);
        return (int)numDocs;
    }

    private static void appendWeightSettings(StringBuilder builder, Configuration config) {
        double[] weightArray = config.weightfactory.toArray();
        builder.append('\"').append(weightArray[0]);
        for (int i = 1; i < weightArray.length; ++i) {
            builder.append(' ').append(weightArray[i]);
        }
        builder.append("\" ");
    }

    private static void appendLookupSettings(StringBuilder builder, Configuration config) {
        int[] intArray = config.idflookup.toArray();
        builder.append('\"').append(intArray[0]);
        for (int i = 1; i < intArray.length; ++i) {
            builder.append(' ').append(intArray[i]);
        }
        builder.append("\" ");
    }

    private void adjustReplicaRefresh(String index, int numReplicas, int refreshRateInSecs) throws ElasticException {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"index\": { ");
        builder.append("  \"number_of_replicas\": ").append(numReplicas).append(", ");
        builder.append("  \"refresh_interval\": \"");
        if (refreshRateInSecs < 1) {
            builder.append("-1");
        } else {
            builder.append(refreshRateInSecs).append('s');
        }
        builder.append("\" } }");
        JsonObject resp = this.connection.executeStatement("PUT", index + "/_settings", builder.toString());
        JsonElement ack = resp.get("acknowledged");
        if (ElasticConnection.isNull(ack)) {
            throw new ElasticException("Unknown response trying to adjust number_of_replicas and refresh_interval");
        }
        if (!ack.getAsBoolean()) {
            throw new ElasticException("Cluster did not accept settings for index: " + index);
        }
    }

    private void createVectorIndex(Configuration config) throws ElasticException {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"settings\": { ");
        builder.append("  \"index\": { ");
        builder.append("    \"analysis\": { ");
        builder.append("      \"tokenizer\": { ");
        builder.append("        \"lsh_").append(this.repository).append("\": { ");
        builder.append("          \"type\": \"lsh_tokenizer\", ");
        builder.append("          \"").append("lsh_weights").append("\": ");
        ElasticDatabase.appendWeightSettings(builder, config);
        builder.append(",         \"").append("idf_config").append("\": ");
        ElasticDatabase.appendLookupSettings(builder, config);
        builder.append(",         \"").append("k_setting").append("\": ").append(config.k);
        builder.append(",         \"").append("l_setting").append("\": ").append(config.L);
        builder.append(" } }, ");
        builder.append("      \"analyzer\": { ");
        builder.append("        \"lsh_analyzer\": { ");
        builder.append("          \"type\": \"custom\", ");
        builder.append("          \"tokenizer\": \"lsh_").append(this.repository).append("\" } } } } }, ");
        builder.append("  \"mappings\": { ");
        builder.append("    \"properties\": { ");
        builder.append("      \"features\": { ");
        builder.append("        \"type\": \"text\", ");
        builder.append("        \"norms\": false, ");
        builder.append("        \"index_options\": \"freqs\", ");
        builder.append("        \"analyzer\": \"lsh_analyzer\" } } } }");
        this.connection.executeStatementNoResponse("PUT", "vector", builder.toString());
        builder = new StringBuilder();
        builder.append("{ \"mappings\": { ");
        builder.append("    \"properties\": { ");
        builder.append("      \"count\": { ");
        builder.append("        \"type\": \"integer\", ");
        builder.append("        \"index\": false } } } }");
        this.connection.executeStatementNoResponse("PUT", "meta", builder.toString());
    }

    private void createExecutableIndex() throws ElasticException {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \"mappings\": { ");
        builder.append("    \"properties\": { ");
        builder.append("      \"md5\": { ");
        builder.append("        \"type\": \"keyword\" }, ");
        builder.append("      \"name_exec\": { ");
        builder.append("        \"type\": \"keyword\" }, ");
        builder.append("      \"architecture\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"name_compiler\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"ingest_date\": { ");
        builder.append("        \"type\": \"date\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"repository\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"path\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"execategory\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"name_func\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"doc_values\": false }, ");
        builder.append("      \"id_signature\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"doc_values\": false }, ");
        builder.append("      \"flags\": { ");
        builder.append("        \"type\": \"integer\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"addr\": { ");
        builder.append("        \"type\": \"long\", ");
        builder.append("        \"doc_values\": false }, ");
        builder.append("      \"childid\": { ");
        builder.append("        \"type\": \"keyword\", ");
        builder.append("        \"index\": false }, ");
        builder.append("      \"join_field\": { ");
        builder.append("        \"type\": \"join\", ");
        builder.append("        \"relations\": { ");
        builder.append("          \"exe\": \"function\" }, ");
        builder.append("        \"eager_global_ordinals\": true } } } }");
        this.connection.executeStatementNoResponse("PUT", "executable", builder.toString());
    }

    public ElasticDatabase(URL baseURL) throws MalformedURLException {
        String path;
        Object fullURL = baseURL.toString();
        if (((String)fullURL).startsWith("elastic:")) {
            fullURL = "https:" + ((String)fullURL).substring(8);
        }
        if (!((String)fullURL).endsWith(path = baseURL.getPath())) {
            throw new MalformedURLException("URL path must indicate the repository only");
        }
        this.repository = path.substring(1);
        this.serverInfo = new BSimServerInfo(BSimServerInfo.DBType.elastic, null, baseURL.getHost(), baseURL.getPort(), this.repository);
        this.baseURL = ((String)fullURL).substring(0, ((String)fullURL).length() - path.length());
        this.lastError = null;
        this.info = null;
        this.status = FunctionDatabase.Status.Unconnected;
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private Map<String, String> readKeyValues() throws ElasticException, NoDatabaseException {
        JsonObject resp;
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"size\": 500, \"query\": { \"match_all\": {} } }");
        try {
            resp = this.connection.executeStatement("GET", "configuration/_search", buffer.toString());
        }
        catch (ElasticException ex) {
            if (ex.getMessage().contains("index_not_found_exception")) {
                throw new NoDatabaseException("Database instance does not exist");
            }
            throw ex;
        }
        JsonObject baseHits = (JsonObject)resp.get("hits");
        long total = 0L;
        if (baseHits != null) {
            JsonObject totalRec = (JsonObject)baseHits.get("total");
            total = totalRec.get("value").getAsLong();
        }
        if (total <= 1L) {
            throw new ElasticException("Unrecoverable error: Could not find configuration");
        }
        HashMap<String, String> res = new HashMap<String, String>();
        JsonArray hits = (JsonArray)baseHits.get("hits");
        for (JsonElement hit2 : hits) {
            JsonObject hit = (JsonObject)hit2;
            String key = hit.get("_id").getAsString();
            JsonObject source = (JsonObject)hit.get("_source");
            JsonElement value = source.get("value");
            if (ElasticConnection.isNull(value)) continue;
            res.put(key, value.getAsString());
        }
        return res;
    }

    private String getCriticalValue(String key, Map<String, String> keyValue) throws ElasticException {
        String value = keyValue.get(key);
        if (value == null) {
            throw new ElasticException("Missing critical configuration value: " + key);
        }
        return value;
    }

    private void writeBasicInfo(int k, int L) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"index\": { \"_id\": \"name\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\", \"value\": \"").append(this.info.databasename).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"owner\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(this.info.owner).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"description\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(this.info.description).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"major\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(Short.toString(this.info.major)).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"minor\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(Short.toString(this.info.minor)).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"settings\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(Integer.toString(this.info.settings)).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"readonly\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(SpecXmlUtils.encodeBoolean((boolean)this.info.readonly)).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"trackcallgraph\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(SpecXmlUtils.encodeBoolean((boolean)this.info.trackcallgraph)).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"layout\" } }\n");
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(Integer.toString(this.info.layout_version)).append("\" }\n");
        buffer.append("{ \"index\": { \"_id\": \"datecolumn\" } }\n");
        String datecol = this.info.dateColumnName == null ? "Ingest Date" : this.info.dateColumnName;
        buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(datecol).append("\" }\n");
        if (k > 0) {
            buffer.append("{ \"index\": { \"_id\": \"k\" } }\n");
            buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(Integer.toString(k)).append("\" }\n");
            buffer.append("{ \"index\": { \"_id\": \"L\" } }\n");
            buffer.append("{ \"type\": \"keyvalue\",  \"value\": \"").append(Integer.toString(L)).append("\" }\n");
        }
        this.connection.executeBulk("/" + this.repository + "_configuration/_bulk", buffer.toString());
        this.writeExecutableCategories();
        this.writeFunctionTags();
    }

    private void readExecutableCategories(DatabaseInformation infoResult, Map<String, String> keyValue) throws ElasticException {
        String countString = keyValue.get("execatcount");
        int count = countString != null ? Integer.parseInt(countString) : 0;
        if (count <= 0) {
            infoResult.execats = null;
            return;
        }
        infoResult.execats = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String key = "execat" + (i + 1);
            String value = this.getCriticalValue(key, keyValue);
            infoResult.execats.add(value);
        }
    }

    private void readFunctionTags(DatabaseInformation infoResult, Map<String, String> keyValue) throws ElasticException {
        String countString = keyValue.get("functiontagcount");
        int count = countString != null ? Integer.parseInt(countString) : 0;
        if (count <= 0) {
            infoResult.functionTags = null;
            return;
        }
        infoResult.functionTags = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String key = "functiontag" + (i + 1);
            String value = this.getCriticalValue(key, keyValue);
            infoResult.functionTags.add(value);
        }
    }

    private void writeExecutableCategories() throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        if (this.info.execats == null) {
            buffer.append("{ \"index\": { \"_id\": \"execatcount\" } }\n");
            buffer.append("{ \"type\": \"keyvalue\", \"value\": \"0\"}\n");
        } else {
            buffer.append("{ \"index\": { \"_id\": \"execatcount\" } }\n");
            buffer.append("{ \"type\": \"keyvalue\", \"value\": \"").append(this.info.execats.size()).append("\" }\n");
            for (int i = 0; i < this.info.execats.size(); ++i) {
                buffer.append("{ \"index\": { \"_id\": \"execat").append(i + 1).append("\" } }\n");
                buffer.append("{ \"type\": \"keyvalue\", \"value\": \"").append(this.info.execats.get(i)).append("\" }\n");
            }
        }
        this.connection.executeBulk("/" + this.repository + "_configuration/_bulk", buffer.toString());
    }

    private void writeFunctionTags() throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        if (this.info.functionTags == null) {
            buffer.append("{ \"index\": { \"_id\": \"functiontagcount\" } }\n");
            buffer.append("{ \"type\": \"keyvalue\", \"value\": \"0\"}\n");
        } else {
            buffer.append("{ \"index\": { \"_id\": \"functiontagcount\" } }\n");
            buffer.append("{ \"type\": \"keyvalue\", \"value\": \"").append(this.info.functionTags.size()).append("\" }\n");
            for (int i = 0; i < this.info.functionTags.size(); ++i) {
                buffer.append("{ \"index\": { \"_id\": \"functiontag").append(i + 1).append("\" } }\n");
                buffer.append("{ \"type\": \"keyvalue\", \"value\": \"").append(this.info.functionTags.get(i)).append("\" }\n");
            }
        }
        this.connection.executeBulk("/" + this.repository + "_configuration/_bulk", buffer.toString());
    }

    private void readBasicInfo(Configuration config) throws ElasticException, NoDatabaseException {
        Map<String, String> keyValue = this.readKeyValues();
        config.info.databasename = this.getCriticalValue("name", keyValue);
        config.info.owner = this.getCriticalValue("owner", keyValue);
        config.info.description = this.getCriticalValue("description", keyValue);
        config.info.major = (short)SpecXmlUtils.decodeInt((String)this.getCriticalValue("major", keyValue));
        config.info.minor = (short)SpecXmlUtils.decodeInt((String)this.getCriticalValue("minor", keyValue));
        config.info.settings = SpecXmlUtils.decodeInt((String)this.getCriticalValue("settings", keyValue));
        config.info.readonly = SpecXmlUtils.decodeBoolean((String)this.getCriticalValue("readonly", keyValue));
        config.info.trackcallgraph = SpecXmlUtils.decodeBoolean((String)this.getCriticalValue("trackcallgraph", keyValue));
        config.info.layout_version = SpecXmlUtils.decodeInt((String)this.getCriticalValue("layout", keyValue));
        config.info.dateColumnName = this.getCriticalValue("datecolumn", keyValue);
        if (config.info.dateColumnName.equals("Ingest Date")) {
            config.info.dateColumnName = null;
        }
        config.k = SpecXmlUtils.decodeInt((String)this.getCriticalValue("k", keyValue));
        config.L = SpecXmlUtils.decodeInt((String)this.getCriticalValue("L", keyValue));
        this.readExecutableCategories(config.info, keyValue);
        this.readFunctionTags(config.info, keyValue);
    }

    private void changePasswordInternal(String uName, char[] password) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"password\": \"");
        buffer.append(ElasticDatabase.escape(String.valueOf(password)));
        buffer.append("\" }");
        StringBuilder path = new StringBuilder();
        path.append("/_security/user/_password");
        this.connection.executeRawStatement("POST", path.toString(), buffer.toString());
    }

    private void initializeElastic(Configuration config) throws ElasticException, NoDatabaseException {
        JsonObject res;
        this.connection = new ElasticConnection(this.baseURL, this.repository);
        if (this.baseURL.startsWith("https")) {
            this.connectionType = FunctionDatabase.ConnectionType.SSL_Password_Authentication;
        }
        config.info = new DatabaseInformation();
        this.readBasicInfo(config);
        this.vectorFactory = new Base64VectorFactory();
        config.weightfactory = new WeightFactory();
        config.idflookup = new IDFLookup();
        try {
            res = this.connection.executeURIOnly("GET", "vector/_settings");
        }
        catch (ElasticException ex) {
            if (ex.getMessage().contains("no such index")) {
                throw new NoDatabaseException(this.baseURL);
            }
            throw ex;
        }
        JsonObject repo = (JsonObject)res.get(this.repository + "_vector");
        JsonObject settings = (JsonObject)repo.get("settings");
        JsonObject index = (JsonObject)settings.get("index");
        JsonObject analysis = (JsonObject)index.get("analysis");
        JsonObject tokenizer = (JsonObject)analysis.get("tokenizer");
        String tokenizerName = null;
        for (String key : tokenizer.keySet()) {
            if (!key.startsWith("lsh_")) continue;
            tokenizerName = key;
            break;
        }
        if (tokenizerName == null) {
            throw new ElasticException("Missing tokenizer configuration");
        }
        JsonObject tokenizerSettings = (JsonObject)tokenizer.get(tokenizerName);
        String idfWeights = tokenizerSettings.get("lsh_weights").getAsString();
        String[] split = idfWeights.split(" ");
        double[] weightArray = new double[split.length];
        if (weightArray.length != config.weightfactory.getSize()) {
            throw new ElasticException("weighttable has wrong number of rows");
        }
        for (int i = 0; i < weightArray.length; ++i) {
            weightArray[i] = Double.parseDouble(split[i]);
        }
        config.weightfactory.set(weightArray);
        String lookup = tokenizerSettings.get("idf_config").getAsString();
        split = lookup.split(" ");
        int[] lookupArray = new int[split.length];
        for (int i = 0; i < lookupArray.length; ++i) {
            lookupArray[i] = Integer.parseInt(split[i]);
        }
        config.idflookup.set(lookupArray);
    }

    @Override
    public FunctionDatabase.Status getStatus() {
        return this.status;
    }

    @Override
    public FunctionDatabase.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public String getUserName() {
        return this.serverInfo.getUserName();
    }

    @Override
    public LSHVectorFactory getLSHVectorFactory() {
        return this.vectorFactory;
    }

    @Override
    public DatabaseInformation getInfo() {
        return this.info;
    }

    @Override
    public int compareLayout() {
        if (this.info.layout_version == 3) {
            return 0;
        }
        return this.info.layout_version < 3 ? -1 : 1;
    }

    @Override
    public BSimServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public String getURLString() {
        return this.baseURL + "/" + this.repository;
    }

    @Override
    public boolean initialize() {
        if (this.initialized) {
            return true;
        }
        try {
            ClientUtil.getClientAuthenticator();
            Configuration config = new Configuration();
            this.initializeElastic(config);
            this.info = config.info;
            this.vectorFactory.set(config.weightfactory, config.idflookup, config.info.settings);
        }
        catch (ElasticException err) {
            this.lastError = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Initialization, "Database error on initialization: " + err.getMessage());
            this.status = FunctionDatabase.Status.Error;
            return false;
        }
        catch (NoDatabaseException err) {
            this.info = null;
            this.lastError = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Nodatabase, "Database has not been created yet: " + err.getMessage());
            this.initialized = true;
            this.status = FunctionDatabase.Status.Ready;
            return true;
        }
        this.status = FunctionDatabase.Status.Ready;
        this.initialized = true;
        return true;
    }

    @Override
    public void close() {
        this.connection = null;
        this.status = FunctionDatabase.Status.Unconnected;
        this.initialized = false;
        this.info = null;
    }

    @Override
    public FunctionDatabase.BSimError getLastError() {
        return this.lastError;
    }

    @Override
    public QueryResponseRecord query(BSimQuery<?> query) {
        if (!(this.isInitialized() || query instanceof CreateDatabase || query instanceof DropDatabase)) {
            this.lastError = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Nodatabase, "The database does not exist");
            return null;
        }
        this.lastError = null;
        try {
            query.buildResponseTemplate();
            if (query instanceof QueryNearest) {
                this.fdbQueryNearest((QueryNearest)query);
            } else if (query instanceof QueryNearestVector) {
                this.fdbQueryNearestVector((QueryNearestVector)query);
            } else if (query instanceof InsertRequest) {
                this.fdbDatabaseInsert((InsertRequest)query);
            } else if (query instanceof QueryInfo) {
                this.fdbDatabaseInfo((QueryInfo)query);
            } else if (query instanceof QueryName) {
                this.fdbQueryName((QueryName)query);
            } else if (query instanceof QueryExeInfo) {
                this.fdbQueryExeInfo((QueryExeInfo)query);
            } else if (query instanceof QueryExeCount) {
                this.fdbQueryExeCount((QueryExeCount)query);
            } else if (query instanceof DropDatabase) {
                DropDatabase q = (DropDatabase)query;
                this.fdbDatabaseDrop(q);
            } else if (query instanceof CreateDatabase) {
                this.fdbDatabaseCreate((CreateDatabase)query);
            } else if (query instanceof QueryChildren) {
                this.fdbQueryChildren((QueryChildren)query);
            } else if (query instanceof QueryDelete) {
                this.fdbDelete((QueryDelete)query);
            } else if (query instanceof QueryUpdate) {
                this.fdbUpdate((QueryUpdate)query);
            } else if (query instanceof QueryVectorId) {
                this.fdbQueryVectorId((QueryVectorId)query);
            } else if (query instanceof QueryVectorMatch) {
                this.fdbQueryVectorMatch((QueryVectorMatch)query);
            } else if (query instanceof QueryPair) {
                this.fdbQueryPair((QueryPair)query);
            } else if (query instanceof InstallCategoryRequest) {
                this.fdbInstallCategory((InstallCategoryRequest)query);
            } else if (query instanceof InstallTagRequest) {
                this.fdbInstallTag((InstallTagRequest)query);
            } else if (query instanceof InstallMetadataRequest) {
                this.fdbInstallMetadata((InstallMetadataRequest)query);
            } else if (query instanceof AdjustVectorIndex) {
                this.fdbAdjustVectorIndex((AdjustVectorIndex)query);
            } else if (query instanceof PrewarmRequest) {
                this.fdbPrewarm((PrewarmRequest)query);
            } else if (query instanceof PasswordChange) {
                this.fdbPasswordChange((PasswordChange)query);
            } else {
                this.lastError = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Fatal, "Unknown query type");
                query.clearResponse();
            }
        }
        catch (FunctionDatabase.DatabaseNonFatalException err) {
            this.lastError = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Nonfatal, "Skipping -" + query.getName() + "- : " + err.getMessage());
            query.clearResponse();
        }
        catch (LSHException err) {
            this.lastError = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Fatal, "Fatal error during -" + query.getName() + "- : " + err.getMessage());
            query.clearResponse();
        }
        catch (ElasticException err) {
            this.lastError = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Fatal, "Elastic error during -" + query.getName() + "- : " + err.getMessage());
            query.clearResponse();
        }
        return query.getResponse();
    }

    private void generate(Configuration config) throws ElasticException {
        config.info.layout_version = 3;
        this.info = config.info;
        this.vectorFactory = new Base64VectorFactory();
        this.vectorFactory.set(config.weightfactory, config.idflookup, config.info.settings);
        this.connection = new ElasticConnection(this.baseURL, this.repository);
        this.createConfigurationIndex();
        this.createExecutableIndex();
        this.createVectorIndex(config);
        this.writeBasicInfo(config.k, config.L);
        this.status = FunctionDatabase.Status.Ready;
        this.initialized = true;
    }

    private void dropDatabase() throws ElasticException {
        ElasticConnection c = this.connection;
        if (c != null) {
            this.close();
        } else {
            c = new ElasticConnection(this.baseURL, this.repository);
        }
        Msg.info((Object)this, (Object)("Dropping BSim Elasticsearch database: " + String.valueOf(this.serverInfo)));
        ElasticDatabase.dropIndex(c, "configuration");
        ElasticDatabase.dropIndex(c, "executable");
        ElasticDatabase.dropIndex(c, "vector");
        ElasticDatabase.dropIndex(c, "meta");
    }

    private static void dropIndex(ElasticConnection c, String indexName) throws ElasticException {
        try {
            c.executeURIOnly("DELETE", indexName);
        }
        catch (ElasticException e) {
            if (e.getMessage().contains("no such index")) {
                return;
            }
            throw e;
        }
    }

    public String recoverExternalFunctionId(String exeName, String funcName, String arch) throws ElasticException {
        String md5 = ExecutableRecord.calcLibraryMd5Placeholder(exeName, arch);
        JsonObject row = this.queryMd5ExeMatch(md5);
        if (row == null) {
            throw new ElasticException("Could not resolve filter specifying executable: " + exeName);
        }
        String exeId = row.get("_id").getAsString();
        JsonArray descres = this.queryFuncNameMatch(exeId, funcName, 2);
        if (1 != descres.size()) {
            throw new ElasticException("Could not resolve filter specifying function: [" + exeName + "]" + funcName);
        }
        RowKeyElastic eKey = RowKeyElastic.parseExeIdString(exeId);
        StringBuilder buffer = new StringBuilder();
        eKey.generateLibraryFunctionId(buffer, funcName);
        return buffer.toString();
    }

    private void queryCallgraph(DescriptionManager manager) throws LSHException, ElasticException {
        if (!this.info.trackcallgraph) {
            throw new LSHException("Database does not track callgraph");
        }
        TreeMap<RowKey, FunctionDescription> funcmap = new TreeMap<RowKey, FunctionDescription>();
        manager.generateFunctionIdMap(funcmap);
        for (ExecutableRecord exeRec : manager.getExecutableRecordSet()) {
            if (exeRec.isLibrary()) continue;
            ArrayList<FunctionDescription> funclist = new ArrayList<FunctionDescription>();
            Iterator<FunctionDescription> iter = manager.listFunctions(exeRec);
            while (iter.hasNext()) {
                funclist.add(iter.next());
            }
            for (FunctionDescription element : funclist) {
                this.fillinChildren(element, manager, funcmap);
            }
        }
    }

    private void fdbQueryName(QueryName query) throws ElasticException, LSHException {
        ResponseName response = query.nameresponse;
        response.printselfsig = query.printselfsig;
        response.printjustexe = query.printjustexe;
        response.manage.setVersion(this.info.major, this.info.minor);
        response.manage.setSettings(this.info.settings);
        ExecutableRecord erec = this.findSingleExecutable(query.spec, response.manage);
        if (erec == null) {
            response.uniqueexecutable = false;
            return;
        }
        response.uniqueexecutable = true;
        this.queryByName(null, response.manage, erec, query.funcname, query.fillinSigs, query.maxfunc);
        if (query.fillinCallgraph) {
            this.queryCallgraph(response.manage);
        }
    }

    private String createExeFilter(String filterMd5, String filterExeName, String filterArch, String filterCompilerName, boolean includeFakes) {
        if (filterMd5 == null && filterExeName == null && filterArch == null && filterCompilerName == null && includeFakes) {
            return null;
        }
        boolean placedFirst = false;
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"filter\": [\n");
        if (filterMd5 != null) {
            if (filterMd5.length() == 32) {
                buffer.append("{ \"term\" : { \"md5\" : \"");
                buffer.append(filterMd5);
                buffer.append("\" }}");
            } else {
                buffer.append("{ \"prefix\" : { \"md5\" : \"");
                buffer.append(filterMd5);
                buffer.append("\" }}");
            }
            placedFirst = true;
        }
        if (filterExeName != null) {
            if (placedFirst) {
                buffer.append(",\n");
            }
            buffer.append("{ \"wildcard\" : {");
            buffer.append(" \"name_exec\" : {");
            buffer.append(" \"value\" : \"*");
            buffer.append(ElasticDatabase.escape(filterExeName));
            buffer.append("*\" }}}");
            placedFirst = true;
        }
        if (filterArch != null || filterCompilerName != null) {
            if (placedFirst) {
                buffer.append(",\n");
            }
            buffer.append("{ \"script\": {");
            buffer.append("  \"script\": {");
            buffer.append("  \"inline\": \"");
            if (filterArch == null) {
                buffer.append("doc['name_compiler'].value == params.comp");
            } else if (filterCompilerName == null) {
                buffer.append("doc['architecture'].value == params.arch");
            } else {
                buffer.append("doc['name_compiler'].value == params.comp && doc['architecture'].value == params.arch");
            }
            buffer.append("\",");
            buffer.append("          \"params\": {");
            if (filterArch != null) {
                buffer.append(" \"arch\": \"").append(filterArch);
                if (filterCompilerName != null) {
                    buffer.append("\", ");
                } else {
                    buffer.append("\" ");
                }
            }
            if (filterCompilerName != null) {
                buffer.append(" \"comp\": \"").append(filterCompilerName).append("\" ");
            }
            buffer.append("}}}}");
        }
        buffer.append("]\n");
        if (!includeFakes) {
            buffer.append(", \"must_not\" : ");
            buffer.append("{ \"prefix\" : { \"md5\" : \"bbbbbbbbaaaaaaaa\" }}\n");
        }
        return buffer.toString();
    }

    private void fdbQueryExeCount(QueryExeCount query) throws ElasticException {
        ResponseExe response = query.exeresponse;
        String filter = this.createExeFilter(query.filterMd5, query.filterExeName, query.filterArch, query.filterCompilerName, query.includeFakes);
        response.recordCount = this.countExecutables(filter);
    }

    private void fdbQueryExeInfo(QueryExeInfo query) throws ElasticException, LSHException {
        ResponseExe response = query.exeresponse;
        String filter = this.createExeFilter(query.filterMd5, query.filterExeName, query.filterArch, query.filterCompilerName, query.includeFakes);
        this.queryExecutables(response.manage, response.records, query.limit, null, query.sortColumn == ExeTable.ExeTableOrderColumn.MD5, filter);
        response.recordCount = response.records.size();
    }

    private void fdbDatabaseCreate(CreateDatabase query) throws LSHException, ElasticException {
        ResponseInfo response = query.inforesponse;
        Configuration config = FunctionDatabase.loadConfigurationTemplate(query.config_template);
        if (query.info.databasename != null) {
            config.info.databasename = query.info.databasename;
        }
        if (query.info.owner != null) {
            config.info.owner = query.info.owner;
        }
        if (query.info.description != null) {
            config.info.description = query.info.description;
        }
        if (!query.info.trackcallgraph) {
            config.info.trackcallgraph = query.info.trackcallgraph;
        }
        if (query.info.functionTags != null) {
            ElasticDatabase.checkStrings(query.info.functionTags, "function tags", FunctionTagBSimFilterType.MAX_TAG_COUNT);
            config.info.functionTags = query.info.functionTags;
        }
        if (query.info.execats != null) {
            ElasticDatabase.checkStrings(query.info.execats, "categories", -1);
            config.info.execats = query.info.execats;
        }
        this.generate(config);
        response.info = config.info;
    }

    private static void checkStrings(List<String> list, String type, int limit) throws LSHException {
        if (limit > 0 && list.size() > limit) {
            throw new LSHException("Too many " + type + " specified (limit=" + FunctionTagBSimFilterType.MAX_TAG_COUNT + "): " + list.size());
        }
        HashSet<String> names = new HashSet<String>();
        for (String name : list) {
            if (!CategoryRecord.enforceTypeCharacters(name)) {
                throw new LSHException("Bad characters in one or more proposed " + type);
            }
            if (names.add(name)) continue;
            throw new LSHException("Duplicate " + type + " entry specified: " + name);
        }
    }

    private void fdbInstallCategory(InstallCategoryRequest query) throws LSHException, ElasticException {
        ResponseInfo response = query.installresponse;
        if (!CategoryRecord.enforceTypeCharacters(query.type_name)) {
            throw new LSHException("Bad characters in proposed category type");
        }
        if (query.isdatecolumn) {
            this.info.dateColumnName = query.type_name;
            StringBuilder buffer = new StringBuilder();
            buffer.append("{ \"type\": \"keyvalue\", \"value\": \"").append(this.info.dateColumnName).append("\" }");
            this.connection.executeStatementNoResponse("PUT", "configuration/datecolumn", buffer.toString());
            response.info = this.info;
            return;
        }
        if (this.info.execats != null) {
            for (String cat : this.info.execats) {
                if (!cat.equals(query.type_name)) continue;
                throw new LSHException("Executable category already exists");
            }
        }
        if (this.info.execats == null) {
            this.info.execats = new ArrayList<String>();
        }
        this.info.execats.add(query.type_name);
        this.writeExecutableCategories();
        response.info = this.info;
    }

    private void fdbInstallTag(InstallTagRequest query) throws LSHException, ElasticException {
        ResponseInfo response = query.installresponse;
        if (!CategoryRecord.enforceTypeCharacters(query.tag_name)) {
            throw new LSHException("Bad characters in proposed function tag");
        }
        if (this.info.functionTags != null && this.info.functionTags.contains(query.tag_name)) {
            throw new LSHException("Function tag already exists");
        }
        if (this.info.functionTags == null) {
            this.info.functionTags = new ArrayList<String>();
        }
        if (this.info.functionTags.size() >= FunctionTagBSimFilterType.MAX_TAG_COUNT) {
            throw new LSHException("Cannot allocate new function tag: " + query.tag_name + " - Column space is full");
        }
        this.info.functionTags.add(query.tag_name);
        this.writeFunctionTags();
        response.info = this.info;
    }

    private void fdbInstallMetadata(InstallMetadataRequest query) throws ElasticException {
        ResponseInfo response = query.installresponse;
        if (query.dbname != null) {
            this.info.databasename = query.dbname;
        }
        if (query.owner != null) {
            this.info.owner = query.owner;
        }
        if (query.description != null) {
            this.info.description = query.description;
        }
        if (query.dbname != null || query.owner != null || query.description != null) {
            this.writeBasicInfo(0, 0);
        }
        response.info = this.info;
    }

    private void fdbAdjustVectorIndex(AdjustVectorIndex query) throws ElasticException {
        ResponseAdjustIndex response = query.adjustresponse;
        response.success = false;
        response.operationSupported = true;
        int numReplicas = query.doRebuild ? 1 : 0;
        int refreshRateInSecs = query.doRebuild ? 1 : -1;
        this.adjustReplicaRefresh("meta", numReplicas, refreshRateInSecs);
        this.adjustReplicaRefresh("vector", numReplicas, refreshRateInSecs);
        this.adjustReplicaRefresh("executable", numReplicas, refreshRateInSecs);
        response.success = true;
    }

    private void fdbPrewarm(PrewarmRequest request) {
        ResponsePrewarm response = request.prewarmresponse;
        response.operationSupported = false;
    }

    private void fdbDatabaseInsert(InsertRequest query) throws LSHException, ElasticException, FunctionDatabase.DatabaseNonFatalException {
        if (this.info.readonly) {
            throw new LSHException("Trying to insert on read-only database");
        }
        if (FunctionDatabase.checkSettingsForInsert(query.manage, this.info)) {
            this.info.major = query.manage.getMajorVersion();
            this.info.minor = query.manage.getMinorVersion();
            this.info.settings = query.manage.getSettings();
            this.writeBasicInfo(0, 0);
        }
        ResponseInsert response = query.insertresponse;
        if (query.repo_override != null && query.repo_override.length() != 0) {
            query.manage.overrideRepository(query.repo_override, query.path_override);
        }
        boolean newExecutable = false;
        for (ExecutableRecord erec : query.manage.getExecutableRecordSet()) {
            if (erec.isLibrary()) {
                this.insertLibrary(query.manage, erec);
                continue;
            }
            if (!this.insertExe(query.manage, erec)) continue;
            newExecutable = true;
        }
        if (!newExecutable) {
            throw new FunctionDatabase.DatabaseNonFatalException("Already inserted");
        }
        response.numexe = query.manage.getExecutableRecordSet().size();
        response.numfunc = query.manage.numFunctions();
    }

    /*
     * WARNING - void declaration
     */
    private void fdbQueryPair(QueryPair query) throws ElasticException, LSHException {
        ResponsePair response = query.pairResponse;
        double aveSim = 0.0;
        double aveSimSquare = 0.0;
        double aveSig = 0.0;
        double aveSigSquare = 0.0;
        int pairCount = 0;
        int missedExe = 0;
        int missedFunc = 0;
        int missedVector = 0;
        ArrayList<Object> aFuncList = new ArrayList<Object>();
        ArrayList<void> bFuncList = new ArrayList<void>();
        DescriptionManager resManage = new DescriptionManager();
        TreeMap<ExeSpecifier, ExecutableRecord> nameMap = new TreeMap<ExeSpecifier, ExecutableRecord>();
        for (PairInput pairInput : query.pairs) {
            void var22_19;
            Object funcA = null;
            Object var22_20 = null;
            ExecutableRecord erec = this.findSingleExeWithMap(pairInput.execA, resManage, nameMap);
            if (erec == null) {
                ++missedExe;
            } else {
                funcA = this.queryByNameAddress(resManage, erec, pairInput.funcA.funcName, pairInput.funcA.address, true);
                if (funcA == null) {
                    ++missedFunc;
                }
            }
            erec = this.findSingleExeWithMap(pairInput.execB, resManage, nameMap);
            if (erec == null) {
                ++missedExe;
            } else {
                FunctionDescription functionDescription = this.queryByNameAddress(resManage, erec, pairInput.funcB.funcName, pairInput.funcB.address, true);
                if (functionDescription == null) {
                    ++missedFunc;
                }
            }
            aFuncList.add(funcA);
            bFuncList.add(var22_19);
        }
        Iterator bIter = bFuncList.iterator();
        VectorCompare vectorData = new VectorCompare();
        for (FunctionDescription functionDescription : aFuncList) {
            FunctionDescription funcB = (FunctionDescription)bIter.next();
            if (functionDescription == null || funcB == null) continue;
            SignatureRecord sigA = functionDescription.getSignatureRecord();
            if (sigA == null) {
                ++missedVector;
                continue;
            }
            SignatureRecord sigB = funcB.getSignatureRecord();
            if (sigB == null) {
                ++missedVector;
                continue;
            }
            double sim = sigA.getLSHVector().compare(sigB.getLSHVector(), vectorData);
            double signif = this.vectorFactory.calculateSignificance(vectorData);
            PairNote pairNote = new PairNote(functionDescription, funcB, sim, signif, vectorData.dotproduct, vectorData.acount, vectorData.bcount, vectorData.intersectcount);
            response.notes.add(pairNote);
            ++pairCount;
            aveSim += sim;
            aveSimSquare += sim * sim;
            aveSig += signif;
            aveSigSquare += signif * signif;
        }
        response.averageSim = aveSim / (double)pairCount;
        response.averageSig = aveSig / (double)pairCount;
        double simVariance = aveSimSquare / (double)pairCount - response.averageSim * response.averageSim;
        response.simStdDev = Math.sqrt(simVariance);
        double sigVariance = aveSigSquare / (double)pairCount - response.averageSig * response.averageSig;
        response.sigStdDev = Math.sqrt(sigVariance);
        response.scale = this.vectorFactory.getSignificanceScale();
        response.pairCount = pairCount;
        response.missedExe = missedExe;
        response.missedFunc = missedFunc;
        response.missedVector = missedVector;
    }

    private void fdbQueryNearest(QueryNearest query) throws LSHException, ElasticException {
        FunctionDatabase.checkSettingsForQuery(query.manage, this.info);
        String filter = null;
        if (query.bsimFilter != null) {
            ExecutableRecord repexe = query.manage.getExecutableRecordSet().first();
            IDElasticResolution[] idres = new IDElasticResolution[query.bsimFilter.numAtoms()];
            for (int i = 0; i < idres.length; ++i) {
                FilterAtom atom = query.bsimFilter.getAtom(i);
                idres[i] = atom.type.generateIDElasticResolution(atom);
                if (idres[i] == null) continue;
                idres[i].resolve(this, repexe);
            }
            filter = ElasticEffects.createFilter(query.bsimFilter, idres);
        }
        ResponseNearest response = query.nearresponse;
        response.totalfunc = 0;
        response.totalmatch = 0;
        response.uniquematch = 0;
        DescriptionManager descMgr = new DescriptionManager();
        Iterator<FunctionDescription> iter = query.manage.listAllFunctions();
        this.queryFunctions(query, filter, response, descMgr, iter);
        response.manage.transferSettings(query.manage);
    }

    private void fdbQueryNearestVector(QueryNearestVector query) throws ElasticException, LSHException {
        FunctionDatabase.checkSettingsForQuery(query.manage, this.info);
        ResponseNearestVector response = query.nearresponse;
        response.totalvec = 0;
        response.totalmatch = 0;
        response.uniquematch = 0;
        int vectormax = query.vectormax;
        if (vectormax == 0) {
            vectormax = 9000;
        }
        Iterator<FunctionDescription> iter = query.manage.listAllFunctions();
        while (iter.hasNext()) {
            LSHVector thevec;
            double len2;
            FunctionDescription frec = iter.next();
            SignatureRecord srec = frec.getSignatureRecord();
            if (srec == null || (len2 = this.vectorFactory.getSelfSignificance(thevec = srec.getLSHVector())) < query.signifthresh) continue;
            ++response.totalvec;
            ArrayList<VectorResult> resultset = new ArrayList<VectorResult>();
            this.queryNearestVector(resultset, thevec, query.thresh, query.signifthresh, vectormax);
            if (resultset.isEmpty()) continue;
            SimilarityVectorResult simres = new SimilarityVectorResult(frec);
            simres.addNotes(resultset);
            response.totalmatch += simres.getTotalCount();
            if (simres.getTotalCount() == 1) {
                ++response.uniquematch;
            }
            response.result.add(simres);
        }
    }

    private void fdbQueryVectorId(QueryVectorId query) throws ElasticException {
        List<VectorResult> resultList = query.vectorIdResponse.vectorResults;
        for (Long id : query.vectorIds) {
            VectorResult vecRes = new VectorResult();
            vecRes.vectorid = id;
            resultList.add(vecRes);
        }
        Iterator<VectorResult> iter1 = resultList.iterator();
        Iterator<VectorResult> iter2 = resultList.iterator();
        while (iter1.hasNext()) {
            this.fetchVectors(iter1, iter2, 50);
        }
        iter1 = resultList.iterator();
        iter2 = resultList.iterator();
        while (iter1.hasNext()) {
            this.fetchVectorCounts(iter1, iter2, 100);
        }
    }

    private void fdbQueryVectorMatch(QueryVectorMatch query) throws ElasticException, LSHException {
        String filter = null;
        if (query.bsimFilter != null) {
            ExecutableRecord repexe = null;
            IDElasticResolution[] idres = new IDElasticResolution[query.bsimFilter.numAtoms()];
            for (int i = 0; i < idres.length; ++i) {
                FilterAtom atom = query.bsimFilter.getAtom(i);
                idres[i] = atom.type.generateIDElasticResolution(atom);
                if (idres[i] == null) continue;
                ((IDElasticResolution)idres[i]).resolve(this, repexe);
            }
            filter = ElasticEffects.createFilter(query.bsimFilter, idres);
        }
        ArrayList<VectorResult> vectorList = new ArrayList<VectorResult>();
        for (Long id : query.vectorIds) {
            VectorResult vecRes = new VectorResult();
            vecRes.vectorid = id;
            vectorList.add(vecRes);
        }
        Iterator<VectorResult> iter1 = vectorList.iterator();
        Iterator<VectorResult> iter2 = vectorList.iterator();
        while (iter1.hasNext()) {
            this.fetchVectors(iter1, iter2, 50);
        }
        iter1 = vectorList.iterator();
        iter2 = vectorList.iterator();
        while (iter1.hasNext()) {
            this.fetchVectorCounts(iter1, iter2, 100);
        }
        int count = 0;
        DescriptionManager manager = query.matchresponse.manage;
        for (VectorResult vecResult : vectorList) {
            if (count >= query.max) break;
            SignatureRecord srec = manager.newSignature(vecResult.vec, vecResult.hitcount);
            JsonArray descres = this.queryVectorIdMatch(vecResult.vectorid, filter, query.max - count);
            if (descres == null) {
                throw new ElasticException("Error querying vectorid: " + Long.toString(vecResult.vectorid));
            }
            if (descres.size() == 0) {
                if (filter != null) continue;
                throw new ElasticException("No functions matching vectorid: " + Long.toString(vecResult.vectorid));
            }
            count += descres.size();
            this.convertDescriptionRows(null, descres, vecResult, manager, srec);
        }
    }

    private void fdbDelete(QueryDelete query) throws ElasticException, LSHException {
        ResponseDelete response = query.respdelete;
        for (ExeSpecifier spec : query.exelist) {
            DescriptionManager manager = new DescriptionManager();
            ExecutableRecord erec = null;
            if (spec.exemd5.length() != 0) {
                JsonObject row = this.queryMd5ExeMatch(spec.exemd5);
                if (row != null) {
                    erec = ElasticDatabase.makeExecutableRecord(manager, row);
                }
            } else {
                erec = this.querySingleExecutable(manager, spec.exename, spec.arch, spec.execompname);
            }
            if (erec == null) {
                response.missedlist.add(spec);
                continue;
            }
            ResponseDelete.DeleteResult delrec = new ResponseDelete.DeleteResult();
            delrec.md5 = erec.getMd5();
            delrec.name = erec.getNameExec();
            ArrayList<FunctionDescription> funclist = new ArrayList<FunctionDescription>();
            RowKeyElastic eKey = ElasticDatabase.updateKey(manager, erec);
            String exeId = eKey.generateExeIdString();
            this.queryAllFunc(funclist, erec, exeId, manager, 0);
            TreeSet<IdHistogram> table = IdHistogram.buildVectorIdHistogram(funclist.iterator());
            ArrayList<IdHistogram> deleteList = new ArrayList<IdHistogram>();
            Iterator<IdHistogram> iter1 = table.iterator();
            Iterator<IdHistogram> iter2 = table.iterator();
            while (iter1.hasNext()) {
                this.decrementVectorCounters(deleteList, iter1, iter2, 100);
            }
            iter1 = deleteList.iterator();
            while (iter1.hasNext()) {
                this.deleteRawVectors(iter1, 100);
            }
            delrec.funccount = this.deleteExeDocuments(exeId);
            response.reslist.add(delrec);
        }
    }

    private void fdbUpdate(QueryUpdate query) throws ElasticException, LSHException {
        ResponseUpdate response = query.updateresponse;
        for (ExecutableRecord erec : query.manage.getExecutableRecordSet()) {
            int res = this.updateExecutable(query.manage, erec, response.badfunc);
            if (res < 0) {
                response.badexe.add(erec);
                continue;
            }
            if ((res & 1) != 0) {
                ++response.exeupdate;
            }
            response.funcupdate += res >> 1;
        }
    }

    private void fdbDatabaseDrop(DropDatabase query) throws LSHException {
        ResponseDropDatabase response = (ResponseDropDatabase)query.getResponse();
        if (!this.serverInfo.getDBName().equals(query.databaseName)) {
            throw new LSHException("Invalid databaseName name");
        }
        response.dropSuccessful = true;
        response.errorMessage = null;
        try {
            this.dropDatabase();
        }
        catch (ElasticException e) {
            response.dropSuccessful = false;
            response.errorMessage = e.getMessage();
        }
    }

    private void fdbPasswordChange(PasswordChange query) throws LSHException {
        ResponsePassword response = query.passwordResponse;
        if (query.username == null) {
            throw new LSHException("Missing username for password change");
        }
        if (query.newPassword == null || query.newPassword.length == 0) {
            throw new LSHException("No password provided");
        }
        response.changeSuccessful = true;
        response.errorMessage = null;
        try {
            this.changePasswordInternal(query.username, query.newPassword);
        }
        catch (ElasticException ex) {
            response.changeSuccessful = false;
            response.errorMessage = ex.getMessage();
        }
        query.clearPassword();
    }

    private FunctionDescription querySingleDescriptionId(DescriptionManager manager, String rowId) throws ElasticException, LSHException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"query\": { \"ids\": { \"values\": [ \"");
        buffer.append(rowId);
        buffer.append("\" ] } } }");
        JsonObject resp = this.connection.executeStatement("GET", "executable/_search", buffer.toString());
        JsonObject hits = (JsonObject)resp.get("hits");
        JsonObject totalRec = (JsonObject)hits.get("total");
        long total = totalRec.get("value").getAsLong();
        if (total == 0L) {
            throw new ElasticException("No function documents matching id=" + rowId);
        }
        JsonArray hitsArray = (JsonArray)hits.get("hits");
        JsonObject row = (JsonObject)hitsArray.get(0);
        JsonObject source = (JsonObject)row.get("_source");
        JsonObject joinfield = (JsonObject)source.get("join_field");
        String exeId = joinfield.get("parent").getAsString();
        RowKeyElastic eKey = RowKeyElastic.parseExeIdString(exeId);
        ExecutableRecord exeRec = manager.findExecutableByRow(eKey);
        if (exeRec == null) {
            ArrayList<RowKeyElastic> keyList = new ArrayList<RowKeyElastic>();
            keyList.add(eKey);
            this.queryExecutableRecordById(manager, keyList.iterator(), keyList.iterator(), 2);
            exeRec = manager.findExecutableByRow(eKey);
        }
        return ElasticDatabase.convertDescriptionRow(row, exeRec, manager, null);
    }

    private JsonArray queryCallgraphRows(FunctionDescription funcRecord) throws ElasticException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("executable/_doc/");
        RowKeyElastic eKey = (RowKeyElastic)funcRecord.getExecutableRecord().getRowId();
        eKey.generateFunctionId(buffer, funcRecord);
        buffer.append("?routing=");
        buffer.append(eKey.generateExeIdString());
        buffer.append("&_source_includes=childid");
        JsonObject resp = this.connection.executeURIOnly("GET", buffer.toString());
        JsonObject source = (JsonObject)resp.get("_source");
        JsonArray childid = (JsonArray)source.get("childid");
        return childid;
    }

    private void fillinChildren(FunctionDescription funcRecord, DescriptionManager manager, Map<RowKey, FunctionDescription> functionMap) throws ElasticException, LSHException {
        if (!this.info.trackcallgraph) {
            throw new ElasticException("Elasticsearch database does not have callgraph information enabled");
        }
        JsonArray callids = this.queryCallgraphRows(funcRecord);
        if (callids == null) {
            return;
        }
        for (JsonElement callid : callids) {
            String funcId = callid.getAsString();
            RowKeyElastic eKey = RowKeyElastic.parseFunctionId(funcId);
            FunctionDescription fdesc = functionMap.get(eKey);
            if (fdesc == null) {
                fdesc = this.querySingleDescriptionId(manager, funcId);
                functionMap.put(eKey, fdesc);
            }
            manager.makeCallgraphLink(funcRecord, fdesc, 0);
        }
    }

    private void fdbQueryChildren(QueryChildren query) throws LSHException, ElasticException {
        if (!this.info.trackcallgraph) {
            throw new LSHException("Database does not track callgraph");
        }
        ResponseChildren response = query.childrenresponse;
        ExecutableRecord exe = null;
        ExeSpecifier exeSpec = new ExeSpecifier();
        exeSpec.exemd5 = query.md5sum;
        exeSpec.exename = query.name_exec;
        exeSpec.arch = query.arch;
        exeSpec.execompname = query.name_compiler;
        exe = this.findSingleExecutable(exeSpec, response.manage);
        if (exe == null) {
            throw new LSHException("Could not (uniquely) match executable");
        }
        for (FunctionEntry entry : query.functionKeys) {
            FunctionDescription func = this.queryByNameAddress(response.manage, exe, entry.funcName, entry.address, true);
            if (func == null) {
                throw new LSHException("Could not find function: " + entry.funcName);
            }
            response.correspond.add(func);
        }
        TreeMap<RowKey, FunctionDescription> funcmap = new TreeMap<RowKey, FunctionDescription>();
        response.manage.generateFunctionIdMap(funcmap);
        for (FunctionDescription element : response.correspond) {
            this.fillinChildren(element, response.manage, funcmap);
        }
    }

    private void fdbDatabaseInfo(QueryInfo query) {
        ResponseInfo response = query.inforesponse;
        response.info = this.info;
    }
}

