/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import ghidra.dbg.jdi.rmi.jpda.JdiCommands;
import ghidra.dbg.jdi.rmi.jpda.JdiConnector;
import java.util.HashSet;
import java.util.Set;

class VmState {
    private JdiConnector connector;
    private JdiCommands cmds;
    private boolean firstPass;
    boolean classes;
    boolean modules;
    boolean regions;
    boolean threads;
    boolean breaks;
    boolean events;
    Set<Object> visited;

    public VmState(JdiConnector connector) {
        this.connector = connector;
        this.cmds = connector.getCommands();
        this.firstPass = true;
        this.classes = false;
        this.modules = false;
        this.regions = false;
        this.threads = false;
        this.breaks = false;
        this.events = false;
        this.visited = new HashSet<Object>();
    }

    public void recordState(String description) {
        boolean first = this.firstPass;
        if (description != null) {
            this.cmds.state.trace.snapshot(description, "", null);
        }
        this.firstPass = false;
        if (first) {
            this.cmds.putProcesses();
        }
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        this.cmds.putVM("VMs", vm);
        this.setState(vm);
        if (first || this.threads) {
            String path = this.cmds.getPath(vm);
            this.cmds.putThreadContainer(path, vm.allThreads(), false);
            this.cmds.putThreadGroupContainer(path, vm.topLevelThreadGroups());
            this.threads = false;
        }
        this.cmds.putCurrentLocation();
        ThreadReference thread = this.connector.getJdi().getCurrentThread();
        if (thread != null) {
            StackFrame frame;
            this.cmds.createLink(vm, "_event_thread", thread);
            if (first || !this.visited.contains(thread)) {
                this.cmds.putFrames();
                this.visited.add(thread);
            }
            if ((frame = this.connector.getJdi().getCurrentFrame()) != null) {
                try {
                    if (first || !this.visited.contains(frame)) {
                        this.cmds.putReg(frame);
                        this.visited.add(frame);
                    }
                }
                catch (InvalidStackFrameException e) {
                    this.connector.getJdi().setCurrentFrame(null);
                }
            }
        }
        if (this.classes) {
            this.classes = false;
            this.cmds.putReferenceTypeContainer(this.cmds.getPath(vm) + ".Classes", vm.allClasses());
        }
        if (first || this.modules) {
            this.modules = false;
            this.cmds.putModuleReferenceContainer();
        }
        if (first || this.breaks) {
            this.breaks = false;
            this.cmds.putBreakpoints();
        }
        if (first || this.events) {
            this.events = false;
            this.cmds.putEvents();
        }
    }

    public void setState(VirtualMachine vm) {
        boolean stopped = false;
        for (ThreadReference thread : vm.allThreads()) {
            stopped |= this.cmds.setStatus(thread, stopped);
        }
        this.cmds.setStatus(vm, stopped);
        Process process = vm.process();
        if (process != null) {
            this.cmds.setStatus(process, stopped);
        }
        if (stopped) {
            this.breaks = true;
            this.events = true;
        }
    }

    public void recordStateContinued(VirtualMachine vm) {
        Process proc = vm.process();
        String path = this.cmds.getPath(proc);
        if (path != null) {
            this.cmds.setValue(path, "Alive", proc.isAlive());
        }
        this.setState(vm);
    }

    public void recordStateExited(VirtualMachine eventVM, String description) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        String path = this.cmds.getPath(vm);
        int exitCode = -1;
        try {
            Process process = eventVM.process();
            if (process != null) {
                exitCode = process.exitValue();
                String procpath = this.cmds.getPath(vm.process());
                this.cmds.setValue(procpath, "ExitCode", exitCode);
                this.cmds.setValue(procpath, "_state", "TERMINATED");
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        if (description != null) {
            this.cmds.state.trace.snapshot(description, "", null);
        }
        this.cmds.setValue(path, "ExitCode", exitCode);
        this.cmds.setValue(path, "_state", "TERMINATED");
    }
}

