/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.sparseimage.SparseHeader;
import ghidra.file.formats.sparseimage.SparseImageFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class SparseImageFileSystemFactory
implements GFileSystemFactoryByteProvider<SparseImageFileSystem>,
GFileSystemProbeByteProvider {
    public SparseImageFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        return new SparseImageFileSystem(targetFSRL, byteProvider, fsService, monitor);
    }

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        BinaryReader reader = new BinaryReader(byteProvider, true);
        SparseHeader header = new SparseHeader(reader);
        return header.getMagic() == -316211398;
    }
}

