/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GTreeExpandNodeToDepthTask
extends GTreeTask {
    private final TreePath[] paths;
    private final int depth;

    public GTreeExpandNodeToDepthTask(GTree gTree, GTreeNode node, int depth) {
        super(gTree);
        this.paths = new TreePath[]{node.getTreePath()};
        this.depth = depth;
    }

    public void run(final TaskMonitor monitor) {
        this.runOnSwingThread(new Runnable(){

            @Override
            public void run() {
                monitor.setMessage("Expanding Paths");
                monitor.setIndeterminate(true);
                try {
                    for (TreePath path : GTreeExpandNodeToDepthTask.this.paths) {
                        GTreeExpandNodeToDepthTask.expandPath(GTreeExpandNodeToDepthTask.this.jTree, path, GTreeExpandNodeToDepthTask.this.depth, monitor);
                    }
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
                monitor.setProgress(monitor.getMaximum());
            }
        });
    }

    private static void expandPath(JTree tree, TreePath treePath, int currentDepth, TaskMonitor monitor) throws CancelledException {
        if (currentDepth <= 0) {
            return;
        }
        GTreeNode treeNode = (GTreeNode)treePath.getLastPathComponent();
        TreeModel treeModel = tree.getModel();
        int childCount = treeModel.getChildCount(treeNode);
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                monitor.checkCancelled();
                GTreeNode n = (GTreeNode)treeModel.getChild(treeNode, i);
                TreePath path = treePath.pathByAddingChild(n);
                GTreeExpandNodeToDepthTask.expandPath(tree, path, currentDepth - 1, monitor);
            }
        }
        tree.expandPath(treePath);
    }
}

