/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.feature.vt.api.db.VTMatchTagDBAdapter;
import ghidra.framework.data.OpenMode;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VTMatchTagDBAdapterV0
extends VTMatchTagDBAdapter {
    private Table table;

    public VTMatchTagDBAdapterV0(DBHandle handle) throws IOException {
        this.table = handle.createTable(TABLE_NAME, TABLE_SCHEMA, new int[0]);
    }

    public VTMatchTagDBAdapterV0(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        this.table = dbHandle.getTable(TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: " + TABLE_NAME);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    public DBRecord insertRecord(String tagName) throws IOException {
        if (tagName == null) {
            throw new IllegalArgumentException("Cannot insert a null name into the match tag table.");
        }
        if (tagName.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot create an empty string tag");
        }
        DBRecord record = TABLE_SCHEMA.createRecord(this.table.getKey());
        record.setString(VTMatchTagDBAdapter.ColumnDescription.TAG_NAME_COL.column(), tagName);
        this.table.putRecord(record);
        return record;
    }

    @Override
    DBRecord getRecord(long tagRecordKey) throws IOException {
        return this.table.getRecord(tagRecordKey);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    boolean deleteRecord(long matchRecordKey) throws IOException {
        return this.table.deleteRecord(matchRecordKey);
    }
}

